package  complex; 

//public 
 class Complex { 
   private static final double EPS = 1e-12; // 筮 ᫥  
   private double re, im;                   // ⢨⥫쭠    
                                            //    
   Complex(double re, double im) {  
      this.re = re; this.im = im; 
   } 
   Complex(double re){this(re, 0.0); } 
   Complex(){this(0.0, 0.0); } 
   Complex(Complex z){this(z.re, z.im) ; } 
      // ⮤ 㯠  
   public double getRe(){return re;}  
   public double getIm(){return im;}  
   public Complex getZ(){return new Complex(re, im);}  
   public void setRe(double re){this.re = re;}  
   public void setlm(double im){this.im = im;}  
   public void setZ(Complex z){re = z.re; im = z.im;} 
   //   㬥 ᭮ ᫠ 
   public double mod() { return Math.sqrt(re * re + im * im);}  
   public double arg() { return Math.atan2(re, im); } 
   // ஢ઠ: ⢨⥫쭮 ᫮?  
   public boolean isReal(){ return Math.abs(im) < EPS;} 
   public void pr() {  // 뢮  ࠭ 
      System.out.println( re + (im < 0.0 ? "" : "+") + im + "i"); 
   }; 
   // ८। ⮤  Object 
   public boolean equals(Complex z){  
      return Math.abs(re - z.re) < EPS &&  
             Math.abs(im - z.im) < EPS; 
   }; 
   public String toString() { 
      return "Complex: " + re + " " + im; 
   }; 
   // ⮤, ॠ騥 樨 +=, -=, *=, /=  
   public void add(Complex z) { re += z.re; im += z.im; }  
   public void sub(Complex z) { re -= z.re; im -= z.im;}  
   public void mul(Complex z){ 
      double t = re * z.re - im * z. im;  
            im = re * z.im + im * z.re;  
            re = t; 
   }; 
   public void div(Complex z){ 
      double m = z.mod(); 
      double t = re * z.re - im * z.im; 
      im = (im * z.re - re * z.im) / m; 
      re = t / m;  
   }; 
      // ⮤, ॠ騥 樨 +, -, *, /  
   public Complex plus(Complex z){ 
      return new Complex(re + z.re, im + z.im); 
   };  
   public Complex minus(Complex z){ 
      return new Complex(re - z.re, im - z.im);  
   }; 
   public Complex asterisk(Complex z){  
      return new Complex( 
         re * z.re - im * z.im, re * z.im + im * z.re); 
   }; 
public Complex slash(Complex z){  
   double m = z.mod();  
   return new Complex( 
      (re * z.re - im * z.im) / m, (im * z.re - re * z.im) / m); 
   }; 
};
 
// ஢ਬ ࠡ  Complex  
public class ComplexTest{ 
   public static void main(String [] args){  
      
      for (String ss : args) { 
        System.out.println(ss);

       };

      Complex zl = new Complex(), 
              z2 = new Complex(1.5),  
              z3 = new Complex(3.6, -2.2),  
              z4 = new Complex(z3); 
      System.out.println();       // ⠢塞  ப  
      System.out.print("zl = "); zl.pr();  
      System.out.print("z2 = "); z2.pr();  
      System.out.print("z3 = "); z3.pr();  
      System.out.print("z4 = "); z4.pr();  
      System.out.println(z4);     // ⠥ ⮤ toString() 
      z2.add(z3); 
      System.out.print("z2 + z3 = "); z2.pr(); 
      z2.div(z3); 
      System.out.print("z2 / z3 = "); z2.pr();  
      z2 = z2.plus(z2); 
      System.out.print("z2 + z2 = "); z2.pr();  
      z3 = z2.slash(zl); 
      System.out.print("z2 / zl = "); z3.pr();  
   }  
} 
