"""
Tests dal.local_disk.py module
# TODO: write tests
"""
import unittest
from unittest.mock import patch, mock_open
import os
from Lecture_2.ht_template.job1.dal.local_disk import save_to_disk

BASE_DIR = os.environ.get("BASE_DIR")

class SaveToDiskTestCase(unittest.TestCase):
    """
    Test dal.local_disk.save_to_disk function.

    """

    @patch('os.makedirs')
    @patch('builtins.open', new_callable=mock_open)
    def test_save_to_disk_creates_file(self, mock_file, mock_makedirs):
        # Example of the input data
        data = [{'client': 'Kelly Gomez',
               'purchase_date': '2022-08-09',
               'product': 'coffee machine',
               'price': 1008},
              {'client': 'Daisy Mcfarland',
               'purchase_date': '2022-08-09',
               'product': 'Laptop',
               'price': 2767}]
        directory = BASE_DIR + 'raw/'
        filename = '2022-08-09.json'

        # call save to disk
        save_to_disk(data, directory)

        # Check if make_directory was called
        mock_makedirs.assert_called_once_with(directory+'sales/', exist_ok=True)

        # Check if file was opened
        mock_file.assert_called_once_with(os.path.join(directory+'sales/', filename), 'w', encoding='utf-8')

        # Check if data was writen to the file at least once
        mock_file().write.assert_called_once()

if __name__ == '__main__':
    unittest.main()