"""
Tests sales_api.py module.
# TODO: write tests
"""
import unittest
from unittest.mock import patch
from Lecture_2.ht_template.job1.dal.sales_api import get_sales
# NB: avoid relative imports when you will write your code:

import ast


def read_list_of_dicts_from_file(filename):
    """
    Read list of dictionaries from file.
    """
    try:
        with open(filename, 'r', encoding='utf-8') as file:
            data = file.read()
            list_of_dicts = ast.literal_eval(data)
            return list_of_dicts
    except FileNotFoundError:
        print(f"File does not find: {filename}")
        return []
    except ValueError:
        print(f"Error during convert files: {filename}")
        return []
    except SyntaxError:
        print(f"Syntax error at the data file: {filename}")
        return []




class GetSalesTestCase(unittest.TestCase):
    """
    Test sales_api.get_sales function.
    # TODO: implement
    """

    def test_get_sales_returns_list_of_dicts(self):
        test_date = "2022-08-09"
        expected_output = read_list_of_dicts_from_file('expected_list.txt')

        # Call get_sales with test date
        result = get_sales(test_date)
        print(result)

        # Check if result is the list
        self.assertIsInstance(result, list)

        # Check if every element in the list is a dict
        for item in result:
            self.assertIsInstance(item, dict)

        # Compare with expected result
        self.assertEqual(result, expected_output)
