from typing import List, Dict, Any
import os
import shutil
import json


def save_to_disk(json_content: List[Dict[str, Any]], path: str) -> None:
    """
    Save json content to the local disk.

    :param json_content: list of dicts
    :param path: path to local disk
    :return: None
    """

    if not json_content:
        raise ValueError("json content is empty")

    # file_path = path + 'sales/'
    file_path = path

    # Check for equal purchase date
    purchase_date = json_content[0].get('purchase_date')
    if any(d.get('purchase_date') != purchase_date for d in json_content):
        raise ValueError("Not all dictionaries have the same purchase date.")

    if not os.path.exists(path):
        os.makedirs(file_path, exist_ok=True)
    else:
        shutil.rmtree(path)
        os.makedirs(file_path, exist_ok=True)

    # Path to the JSON
    json_filename = 'sales_' + f"{purchase_date}.json"
    json_path = os.path.join(file_path, json_filename)
    json_object = json.dumps(json_content, indent=4)

    # Record dicts to JSON
    with open(json_path, 'w', encoding='utf-8') as json_file:
        json_file.write(json_object)

    print(f"File saved as {json_path}")

