"""
Tests for main.py

"""
from unittest import TestCase, mock
import os
# NB: avoid relative imports when you will write your code
from Lecture_2.ht_template.job2 import main

BASE_DIR = os.environ.get("BASE_DIR")
AUTH_TOKEN = os.environ.get("AUTH_TOKEN")

class MainFunctionTestCase(TestCase):

    @classmethod
    def setUpClass(cls) -> None:
        main.app.testing = True
        cls.client = main.app.test_client()


    @mock.patch('Lecture_2.ht_template.job2.main')
    def test_return_400_stg_dir_param_missed(
            self,
            get_sales_mock: mock.MagicMock
        ):
        """
        Raise 400 HTTP code when no 'stg_dir' param
        """
        resp = self.client.post(
            '/',
            json={
                'raw_dir': BASE_DIR+'raw/',
                # no 'stg_dir' set!
            },
        )

        self.assertEqual(400, resp.status_code)

    @mock.patch('Lecture_2.ht_template.job2.main')
    def test_return_400_raw_dir_param_missed(
            self,
            get_sales_mock: mock.MagicMock
        ):
        """
        Raise 400 HTTP code when no 'raw_dir' param
        """

        resp = self.client.post(
            '/',
            json={
                # 'raw_dir': fake_date,
                'stg_dir': BASE_DIR+'stg/',
            },
        )
        # print(resp.status_code)
        self.assertEqual(400, resp.status_code)

    @mock.patch('Lecture_2.ht_template.job2.main.save_sales_to_local_disk')
    def test_save_sales_to_local_disk(
            self,
            save_sales_to_local_disk_mock: mock.MagicMock
    ):
        """
        Test whether api.get_sales is called with proper params
        """
        fake_stg_dir = BASE_DIR+'stg/'
        fake_raw_dir = BASE_DIR+'raw/'
        self.client.post(
            '/',
            json={
                'raw_dir': fake_raw_dir,
                'stg_dir': fake_stg_dir,
            },
        )

        save_sales_to_local_disk_mock.assert_called_with(
            raw_dir=fake_raw_dir,
            stg_dir=fake_stg_dir,
        )

    @mock.patch('Lecture_2.ht_template.job2.main')
    def test_return_201_when_all_is_ok(
            self,
            get_sales_mock: mock.MagicMock
    ):
        """
        Test whether api.get_sales is called with proper params
        """
        fake_stg_dir = BASE_DIR + 'stg/'
        fake_raw_dir = BASE_DIR + 'raw/'
        resp = self.client.post(
            '/',
            json={
                'raw_dir': fake_raw_dir,
                'stg_dir': fake_stg_dir,
            },
        )
        self.assertEqual(201, resp.status_code)