import shutil
import json
import fastavro
import os

def generate_avro_schema(json_data):
    fields = []
    example_record = json_data[0]
    for key, value in example_record.items():
        field_type = type(value).__name__
        avro_type = 'string' if field_type == 'str' else 'int' if field_type == 'int' else 'float' if field_type == 'float' else 'boolean' if field_type == 'bool' else 'null'
        fields.append({'name': key, 'type': [avro_type, 'null']})  # Дозволяємо значенням бути null

    schema = {
        'type': 'record',
        'name': 'AutoGeneratedRecord',
        'fields': fields
    }
    return schema

def convert_json_to_avro(json_path, avro_path):
    # Read JSON file
    with open(json_path, 'r', encoding='utf-8') as json_file:
        json_data = json.load(json_file)

    # Generate Avro schema
    schema = generate_avro_schema(json_data)

    print(schema)

    # Write data in the Avro format
    with open(avro_path, 'wb') as avro_file:
        fastavro.writer(avro_file, schema, json_data)

def convert_directory_json_to_avro(json_directory, avro_directory):
    # json_directory_sales = json_directory + 'sales/'
    # avro_directory_sales = avro_directory + 'sales/'
    avro_directory_sales = avro_directory

    if not os.path.exists(avro_directory_sales):
        os.makedirs(avro_directory_sales, exist_ok=True)
    else:
        shutil.rmtree(avro_directory)
        os.makedirs(avro_directory_sales, exist_ok=True)

    for file in os.listdir(json_directory):
        if file.endswith('.json'):
            json_path = os.path.join(json_directory, file)
            avro_filename = f"{file[:-5]}.avro"
            avro_path = os.path.join(avro_directory, avro_filename)
            convert_json_to_avro(json_path, avro_path)
            # print(f"Converted {file} to {avro_filename}")

def save_to_disk(path_raw: str, path_stg: str) -> None:
    if not path_raw:
        raise ValueError("raw path cannot be empty")

    if not path_stg:
        raise ValueError("stg path cannot be empty")

    try:
        convert_directory_json_to_avro(path_raw, path_stg)
        print(f"All files and subdirectories {path_raw} are copied {path_stg}.")
    except Exception as e:
        print(f"Copy error: {e}")
