# TEST FOR FJEFORMS PACKAGE 

with(share): readshare(fjeforms,algebra): # read `fjeforms.m`;
with(fjeforms):

# Test of defform   ************************************

defform(u=1,B=2,a=const,d(x)=u):
defform1 := `fjeforms/wdegree`(u):
  if defform1 = 1 then print(okay)
  else print(defform1)
  fi;
defform2 := `fjeforms/wdegree`(B):
  if defform2 = 2 then print(okay)
  else print(defform2)
  fi;
defform3 := `fjeforms/wdegree`(a):
  if defform3 = 0 then print(okay)
  else print(defform3)
  fi;
defform4 := d(x):
  if defform4 = u then print(okay)
  else print(defform4)
  fi;

defform(u=0,B=0,a=0,'d(x)'='d(x)'):  
defform1 := type(u,`scalar`):
  if defform1 = true then print(okay)
  else print(defform1)
  fi;
defform2 := type(B,`scalar`):
  if defform2 = true then print(okay)
  else print(defform2)
  fi;
defform3 := type(a,`scalar`):
  if defform3 = true then print(okay)
  else print(defform3)
  fi;
defform4 := d(x):
  if defform4 = 'd(x)' then print(okay)
  else print(defform4)
  fi;

# Test of coef   ************************************

defform(u=1,v=1,B=2):
expr := expand(x*y*&^(u,v)+z*B):
coef1 := coef(expr,B):
  if coef1 - z = 0 then print(okay)
  else print(coef1)
  fi;
coef2 := coef(expr,&^(u,v)):
  if coef2 - x*y = 0 then print(okay)
  else print(coef2)
  fi;
defform(u=0,v=0,B=0):

# Test of complex, re, im and cc   ************************************

defcomplex(x,y):
  if `fjeforms/iscomplex`(x) then print(okay)
  else print(x) 
  fi;
  if `fjeforms/iscomplex`(y) then print(okay)
  else print(y)
  fi;
rreal := expand(re(2*(x+I*y)-3*(y+I*z))):
  if rreal - x - I*y + 3/2*y - cc(x) + I*cc(y) + 3/2*cc(y) = 0 then print(okay) 
  else print(rreal) 
  fi;
imag := expand(im(2*(x+I*y)-3*(y+I*z))):
  if imag + I*x - y - 3/2*I*y + 3*z - I*cc(x) - cc(y) + 3/2*I*cc(y) = 0
    then print(okay)
  else print(imag)
  fi;
compcon := expand(cc(2*(x+I*y)-3*(y+I*z))):
  if compcon - 2*cc(x) + 2*I*cc(y) + 3*cc(y) - 3*I*z = 0 then print(okay)
  else print (compcon)
  fi;

# Test of type/const   ************************************

defform(a=const,b=const,c=const,d=const):
const1 := type(a,const):        
  if const1 = true
  then print(okay)
  else print(const1)
  fi;
const2 := type(a+b*c^d,const):  
  if const2 = true
  then print(okay)
  else print(const2)
  fi;
const3 := type(e+a,const):      
  if const3 = false
  then print(okay)
  else print(const3)
  fi;
defform(a=0,b=0,c=0,d=0):

# Test of d   ************************************

defform(k=1,m=1,e1=1,e2=1,e3=1,w1=1,w2=2):
dtest1 := d( x^2*y ): 
  if dtest1 - 2*x*y*d(x)-x^2*d(y) = 0
  then print(okay)
  else print(dtest1)
  fi;
dtest2 := d( f(x,y,z) ):           
  if dtest2 - diff(f(x, y, z),x)*d(x) - diff(f(x, y, z),y)*d(y) 
     - diff(f(x, y, z),z)*d(z) = 0
  then print(okay)
  else print(dtest2)
  fi;
dtest3 := d( f, [e1,`d[1]`], [e2,`d[2]`], [e3,`d[3]`]):
  if dtest3 - `d[1]`(f)*e1 - `d[2]`(f)*e2 - `d[3]`(f)*e3 = 0
  then print(okay)
  else print(dtest3)
  fi;
dtest4 := d( f, [k,`d[m]`] , [m,`d[k]`]):
  if dtest4 - `d[m]`(f)*k - `d[k]`(f)*m = 0
  then print(okay)
  else print(dtest4)
  fi;
dtest5 := d( f*&^(w1,w2) ):        
  if dtest5 - &^(d(f), w1, w2) - f*(d(w1) &^ w2) + f*(w1 &^ d(w2)) = 0
  then print(okay)
  else print(dtest5)
  fi;
dtest6 := d( [x*y,y^2,w2] ):       
  if dtest6 = [y*d(x) + x*d(y), 2*y*d(y), d(w2)]
  then print(okay)
  else print(dtest5)
  fi;
defform(k=0,m=0,e1=0,e2=0,e3=0,w1=0,w2=0):

# Test of type/form   ************************************

defform(a=const,f=1,g=2,h=1):
form1 := type(a*b*f, form):
  if form1 = true
  then print(okay)
  else print(form1)
  fi;
form2 := type(a * f &^ h + x * g,form):
  if form2 = true
  then print(okay)
  else print(form2)
  fi;
form3 := type(x * f &^ g,form(3)):
  if form3 = true
  then print(okay)
  else print(form3)
  fi;
defform(a=0,f=0,g=0,h=0):

# Test of perm   ************************************

defform(u=1,v=1,B=2):
perm1 := perm(u &^ v,v &^ u):
  if perm1 = -1 then print(okay) else print(perm1) fi;
perm2 := perm(u &^ B,B &^ u):
  if perm2 = 1 then print(okay) else print(perm2) fi;
perm3 := perm(u &^ v,w &^ v):
  if perm3 = 0 then print(okay) else print(perm3) fi;
defform(u=0,v=0,B=0):

# Test of type/scalar   ************************************

defform(a=const,b=const):
scalar1 := type(c+d^3,scalar):   
  if scalar1 = true
  then print(okay)
  else print(scalar1)
  fi;
scalar2 := type(a+d,scalar):     
  if scalar2 = true
  then print(okay)
  else print(scalar2)
  fi;
scalar3 := type(a+d+f,scalar):  
  if scalar3 = true
  then print(okay)
  else print(scalar3)
  fi;
scalar4 := type(a+b,scalar):     
  if scalar4 = false
  then print(okay)
  else print(scalar4)
  fi;
defform(a=0,b=0):
   
# Test of star   ************************************

defform(u=1,v=1,B=2):
DIMENSION := 3:
star1 := star(u &^ v + B):
  if star1 - star(u &^ v) - star(B) = 0
  then print(okay)
  else print(star1)
  fi;
star2 := wdegree(star1):
  if star2 = 1
  then print(okay)
  else print(star2)
  fi;
defform(u=0,v=0,B=0):

# Test of `&step`   ************************************

defform(u=1,v=1,w=1,B=2):
step1 := u &step (v &^ w):
  if step1 - v*(u &step w) + (u &step v)*w = 0
  then print(okay)
  else print(step1)
  fi;
step2 := (v &^ w) &step u:
  if step2 = 0
  then print(okay)
  else print(step2)
  fi;
step3 := (u &^ v) &step (u &^ w):
  if step3 - (v &step w)*(u &step u) + (v &step u)*(u &step w) = 0
  then print(okay)
  else print(step3)
  fi;
step4 := (u &^ v) &step B:
  if step4 - u &step (v &step B) = 0
  then print(okay)
  else print(step4)
  fi;
defform(u=0,v=0,w=0,B=0):

# Test of wdegree   ************************************

defform(x=1,c=const): 
wdeg1 := wdegree( c ):           
  if wdeg1 = 0
  then print(okay)
  else print(wdeg1)
  fi;
wdeg2 := wdegree( x ):          
  if wdeg2 = 1
  then print(okay)
  else print(wdeg2)
  fi;
wdeg3 := wdegree( y ):
  if wdeg3 = 0
  then print(okay)
  else print(wdeg3)
  fi;
wdeg4 := wdegree(d(y)):
  if wdeg4 = 1
  then print(okay)
  else print(wdeg4)
  fi;
defform(x=0,c=0):

#quit;

