#
## <SHAREFILE=algebra/ratsum/ratsum.mpl >
## <DESCRIBE>
##                Algorithms for rational function summation in Maple.
##                REFERENCE: Algorithms for Indefinite Summation of Rational
##                Functions in Maple, To Appear, Maple Technical Newsletter,
##                Volume 2, No 1, 1995.
##                AUTHOR: Roberto.Pirastu@risc.uni-linz.ac.at
## </DESCRIBE>
## <UPDATE=R4 >

###############################################
#
# Main function.
#
# ratsum (f, k) applies Moenck's method on f(k)
#
# ratsum (f, k, alg)  applies alg on f(k)
#
###############################################

ratsum:= proc()
  if nargs=2 then RETURN(moencksum(args[1],args[2]))
     fi;
  if nargs<>3 then ERROR(`Invalid number of parameters in ratsum`);
     fi;
  if args[3]=`abramov` then RETURN(abrsum(args[1],args[2]))
     elif
     args[3]=`newabramov` then RETURN(abrsumnew(args[1],args[2]))
     elif
     args[3]=`paule` then RETURN(paulesum(args[1],args[2]))
  fi;
  RETURN(moencksum(args[1],args[2]));
end:

	


####
#     Indefinite Summation of Rational Functions
#
#     A correct implementation of the algorithm of Moenck

#     R. Pirastu - RISC Linz, 1993
#
#
####


moencksum:= proc(e,x)
local f,ans;
f:=normal(e);
    if nargs <> 2 then ERROR(`expecting two arguments`)
    elif not type(f,ratpoly(anything,x)) then
        ERROR(`first argument must be a rational function`)
    elif not (type(x,'name')) then
            ERROR(`second argument must be a name`)
    fi;
    if not has(f,x) then RETURN(f*x) fi;
    if has(indets(f,`.`) union indets(f,indexed),x) then RETURN(FAIL) fi;
    if 1 < printlevel then
         lprint(`moencksum: indefinite summation of rational functions`) fi;
    if type(f,polynom(anything,x)) then ans := sum(f,x)
        elif type(f,ratpoly(anything,x)) then
            ans := frontend(`moencksum/ratpoly`,[numer(f),denom(f),x],[])
        fi;
end:


`moencksum/ratpoly`:=proc(apoly,bpoly,n)
local a,b,c,al,bl,bi,f,m,d,i,j,k,lc,p,s,t,funzi,res;
    if 1 < printlevel then lprint(`moencksum: ratpoly: applying Moenck's method`)
    fi;
    a := expand(apoly);
    c := 1/`moencksum/collconst`(bpoly,n);
    b := (bpoly*c);
    if b = 1 then RETURN(sum(a,n)/c) fi;
    if degree(b,n) <= degree(a,n) then
        a := sprem(a,b,n,'m','p'); p := sum(p,n); c := c/m
    else p := 0
    fi;
    if degree(b,n) = 1 then
        lc := coeff(b,n,1); RETURN(p*c+`Sum`(normal(c*a/b),n))
    fi;
    lc := icontent(b)*sign(lcoeff(b));
    b := b/lc;
    c := c/lc;
    k := `moencksum/shiftfree`(a,b,n,bl,'a','b');
    `moencksum/shfrpfd`(a,b,op(bl),k,n,al);
    `moencksum/cshfrpfd`(al,op(bl),k,n,'a');
    `moencksum/parts`(a,op(bl),k,n,f,d);
    s := 0; #r:=0;
    for i from 2 to k do
        t := 1;
        bi := bl[i];
        for j to i-1 do
            bi := subs(n = n-1,bi);
            t := expand(t*bi);
            s :=  s+normal(f[i,j]/t)
	od; 
    od;
    funzi:=(p*c+s*c);
    res:=0;
    for i to k do
      res:= normal(res + d[i]/bl[i]);
    od; 
    if res=0 then funzi 
    else funzi+`Sum`(c*res,n);
    fi
end:


`moencksum/part` := proc (p,h,v,w)
         local g,v1,w1;
         g:=gcd(p,h);
	 v1:=1;
	 w1:=p;
	 while g<>1 do
		divide(w1,g,'w1');
		v1:=v1*g;
		g:=gcd(w1,v1);
	 od;
	 v:=v1;
	 w:=w1;
	end:


`moencksum/shiftfree`:=proc(aa,bb,n,bl,aout,bout)
local b,bnpj,bt,bs,c,d,f,g,i,j,k,l,nroots,rootlist,rr,s,
      deco,rf,fl,rc,rm,disp,lmax,lmin,kk;
    if 3 < printlevel then
        lprint(`moencksum:shiftfree: computing shift-free decomposition`)
    fi;
    c := 1;
    disp:=0;
    rr :=convert( op(2, readlib(factors)(bb)),set);
    if nops(rr)>1 then
        rootlist := 0;
        deco:={};
        rf:={};
        for fl in rr do
         if not member(fl,rf) then
            rf:=`union`(rf,{fl});
            f := op(1,fl);
            # lprint(f);
            d := degree(f,n);
            if 0 < d then 
		lmin:=0; lmax:=0;rc:=f;rm:=op(2,fl);
                for j in (rr minus rf) do
                    if (degree(op(1,j),n) = d) and
                        (lcoeff(op(1,j),n) = lcoeff(f,n)) then
                        coeff(f,n,d-1)-coeff(op(1,j),n,d-1);
                        kk:="/d/lcoeff(f,n);
                        if type(kk,integer)  then
                            if expand(subs(n = n+kk,op(1,j))-f) = 0 then
                                rootlist := rootlist,kk;
                                lmax:=max(lmax,kk);
                                rm:=max(op(2,j),rm);
                                rf:=rf union {j}; # lprint(rf);
                                if kk<lmin then
                                   rc:=op(1,j);
                                   lmin:=kk;
                                fi;
                            fi
                        fi
                    fi
                od;
                disp:=max(disp,lmax-lmin);
                deco:=`union`(deco, {[rc,rm,lmax-lmin]});
            fi
         fi
        od;
	# lprint(deco);
        # rootlist := sort(convert({rootlist},'list'));
        # nroots := nops(rootlist)
     else deco:={[op(1,rr[1]),op(2,rr[1]),0]};
    fi;
        k := disp+1;
        for i to k do  b[i] := 1 od;
        for j in deco do
           b[op(3,j)+1] := b[op(3,j)+1]*op(1,j)^op(2,j)
        od;
        s:=1;
        for i from 1 to k do
           for j from 0 to (i-1) do
             s:=s*expand(subs(n=n-j,b[i]))
           od;
        od;
        divide(s,bb,'c');
    aout := aa*c;
    bout := s;
    bl := op(b);
    k
end:


`moencksum/collconst` := proc(a,x)
    if not has(a,x) then a
    elif type(a,`*`) then map(`moencksum/collconst`,a,x)
    elif type(a,`^`) then `moencksum/collconst`(op(1,a),x)^op(2,a)
    elif type(a,`+`) then icontent(a)
    else 1
    fi
end:

`moencksum/shfrpfd`:=proc(aa,bb,bl,k,n,a)
local b,c,e,f,i,j;
    if 3 < printlevel then
        lprint(`sum:shfrpfd: shift-free parfrac decomposition`)
    fi;
    b := bl;
    c := aa;
    e := bb;
    for i from k by -1 to 2 do
        if b[i] = 1 then a[i] := 0
        else
            map(proc(s,n,e) subs(n = s,e) end,[(n-i+j) $ (j = 1 .. i)],n,b[i]);
            f := expand(convert(",`*`));
            divide(e,f,'e');
            gcdex(e,f,c,n,evaln(a[i]),'c');
            gcd(e,f)
        fi
    od;
    a[1] := c
end:

`moencksum/cshfrpfd`:=proc(a,b,k,n,aa)
local bi,c,i,j;
    if 3 < printlevel then
        lprint(`sum:cshfrpfd: complete shift-free parfrac decompositon`)
    fi;
    for i to k do
        c := a[i];
        bi := expand(subs(n = n-i+1,b[i]));
        for j from i by -1 to 2 do
            aa[i,j] := rem(c,bi,n,'c');
            if 2 < j then bi := expand(subs(n = n+1,bi)) fi
        od;
        aa[i,1] := c
    od
end:

`moencksum/parts`:=proc(a,b,k,n,c,d)
local bdif,bi,e,g,h,i,j;
    for i from 2 to k do
        bi := expand(subs(n = n-i,b[i]));
        e := a[i,i];
        for j from i by -1 to 2 do
            bi := expand(subs(n = n+1,bi));
            bdif := expand(b[i]-bi);
            if e = 0 then g := 0; h := 0 else gcdex(bdif,bi,e,n,'g','h') fi;
            e := expand(a[i,j-1]+h+`moencksum/fdiff`(g,n));
            c[i,j-1] := -g
        od;
        d[i] := e
    od;
    d[1] := a[1,1]
end:

`moencksum/fdiff`:=proc(f,n)
local k;
    if nargs <= 2 then k := 1 else k := args[3] fi; expand(subs(n = n+k,f)-f)
end:





####
#     Indefinite Summation of Rational Functions
#
#     An implementation of the algorithm of Paule

#     R. Pirastu - RISC Linz, 1993
#
#
####



paulesum:= proc(e,x)
local f,ans;
f:=normal(e);
    if nargs <> 2 then ERROR(`expecting two arguments`)
    elif not type(f,ratpoly(anything,x)) then
        ERROR(`first argument must be a rational function`)
    elif not (type(x,'name')) then
            ERROR(`second argument must be a name`)
    fi;
    if not has(f,x) then RETURN(f*x) fi;
    if has(indets(f,`.`) union indets(f,indexed),x) then RETURN(FAIL) fi;
    if 1 < printlevel then
         lprint(`paulesum: indefinite summation of rational functions`) fi;
    if type(f,polynom(anything,x)) then ans := sum(f,x)
        elif type(f,ratpoly(anything,x)) then
            ans := frontend(`paulesum/ratpoly`,[numer(f),denom(f),x],[])
        fi;
    ans;
end:


`paulesum/ratpoly`:=proc(apoly,bpoly,n)
local b,c,bl,m,d,i,k,lc,p,funzi,res,bed,bd,xset,yset,gam,eps,listeq,solut,
      a,pol;
    if 1 < printlevel then lprint(`paulesum: ratpoly: applying Paule's method`)
    fi;
    a := expand(apoly);
    c := 1/`paulesum/collconst`(bpoly,n);
    b := (bpoly*c);
    if b = 1 then RETURN(sum(a,n)/c) fi;         # a/b is polynomial
    if degree(b,n) <= degree(a,n) then
        a := sprem(a,b,n,'m','p'); p := sum(p,n); c := c/m
    else p := 0
    fi;
    if degree(b,n) = 1 then
         RETURN(p*c+`Sum`(normal(a/b*c),n))
    fi;
    lc := icontent(b)*sign(lcoeff(b));
    b := b/lc;
    c := c/lc;
    k :=  `paulesum/shiftfree`(a,b,n,bl,'a','b');
    if k=1 then RETURN (p*c+Sum(normal(c*a/b),n)); fi;
    bd:=1;
    bed:=1;
    for i from 1 to k do bd:=bd*bl[i]; bed:=bed*subs(n=n-i+1,bl[i]); od;
    d:= normal(b/bd);
    gam:= `paulesum/genpol`('CGamma',degree(d,n)-1,`xset`,n);
    eps:= `paulesum/genpol`('CEpsi',degree(bd,n)-1,`yset`,n);
    
    pol:=expand(bed*subs(n=n+1,gam) - bd*gam+ d*eps);
    listeq:=array(0..max(degree(pol,n),degree(a,n)));
    for i from 0 to max(degree(pol,n),degree(a,n)) do
       listeq[i]:= coeff(pol,n,i) = coeff(a,n,i);
    od;
    
    solut:=solve(convert(listeq,set), `union`(xset,yset));

    if solut= NULL then RETURN(FAIL) fi;
    funzi:=normal(p*c+subs(solut,gam)/d*c);
    res:=normal(c*subs(solut,eps)/bd);
    if res=0 then funzi 
    else funzi+`Sum`(res,n);
    fi
end:


`paulesum/part` := proc (p,h,v,w)
         local g,v1,w1;
         g:=gcd(p,h);
	 v1:=1;
	 w1:=p;
	 while g<>1 do
		divide(w1,g,'w1');
		v1:=v1*g;
		g:=gcd(w1,v1);
	 od;
	 v:=v1;
	 w:=w1;
	end:


`paulesum/shiftfree`:=proc(aa,bb,n,bl,aout,bout)
local b,bnpj,bt,bs,c,d,f,g,i,j,k,l,nroots,rootlist,rr,s,
      deco,rf,fl,rc,rm,disp,lmax,lmin,kk;
    if 3 < printlevel then
        lprint(`paulesum:shiftfree: computing shift-free decomposition`)
    fi;
    c := 1;
    disp:=0;
    rr :=convert( op(2, readlib(factors)(bb)),set);
    if nops(rr)>1 then
        rootlist := 0;
        deco:={};
        rf:={};
        for fl in rr do
         if not member(fl,rf) then
            rf:=`union`(rf,{fl});
            f := op(1,fl);
            d := degree(f,n);
            if 0 < d then 
		lmin:=0; lmax:=0;rc:=f;rm:=op(2,fl);
                for j in (rr minus rf) do
                    if (degree(op(1,j),n) = d) and
                        (lcoeff(op(1,j),n) = lcoeff(f,n)) then
                        coeff(f,n,d-1)-coeff(op(1,j),n,d-1);
                        kk:="/d/lcoeff(f,n);
                        if type(kk,integer)  then
                            if expand(subs(n = n+kk,op(1,j))-f) = 0 then
                                # rootlist := rootlist,kk;
                                lmax:=max(lmax,kk);
                                rm:=max(op(2,j),rm);
                                rf:=rf union {j}; # lprint(rf);
                                if kk<lmin then
                                   rc:=op(1,j);
                                   lmin:=kk;
                                fi;
                            fi
                        fi
                    fi
                od;
                disp:=max(disp,lmax-lmin);
                deco:=`union`(deco, {[rc,rm,lmax-lmin]});
            fi
         fi
        od;
	# lprint(deco);
        # rootlist := sort(convert({rootlist},'list'));
        # nroots := nops(rootlist)
     else deco:={[op(1,rr[1]),op(2,rr[1]),0]};
    fi;
# lprint(deco);
        k := disp+1;
        for i to k do  b[i] := 1 od;
        for j in deco do
           b[op(3,j)+1] := b[op(3,j)+1]*op(1,j)^op(2,j)
        od;
        s:=1;
        for i from 1 to k do
           for j from 0 to (i-1) do
             s:=s*expand(subs(n=n-j,b[i]))
           od;
        od;
        divide(s,bb,'c');
    aout := expand(aa*c);
    bout := s;
    bl := op(b);
    k
end:


`paulesum/collconst` := proc(a,x)
    if not has(a,x) then a
    elif type(a,`*`) then map(`paulesum/collconst`,a,x)
    elif type(a,`^`) then `paulesum/collconst`(op(1,a),x)^op(2,a)
    elif type(a,`+`) then icontent(a)
    else 1
    fi
end:



`paulesum/genpol`:= proc(x,n,xl,y)
local i, p;
	xl:=array(0..n); p:=0;
	for i from 0 to n do
	    xl[i]:= x.i;
	    p:= p+(x.i)*y^i
	od;
	xl:=convert(xl,set);
	p;
end:


#######
#
#      Indefinite Summation of Rational Functions
#
#
#      A Modification of the Algorithm of Abramow
#
#      R. Pirastu, RISC Linz, March 1993
######




abrsumnew := proc(e,x)
local ans,f;
f:=factor(normal(e));
    if nargs <> 2 then ERROR(`expecting two arguments`)
    elif not type(f,ratpoly(anything,x)) then
        ERROR(`first argument must be a rational function`)
    elif not (type(x,'name')) then
            ERROR(`second argument must be a name`)
    fi;
    if not has(f,x) then RETURN(f*x) fi;
    if type(f,polynom(anything,x)) then ans := sum(f,x)
        elif type(f,ratpoly(anything,x)) then
           ans:= `abrsumnew/rec`(f,x,`abrsumnew/dis`(f,x))
    fi;
    ans;
end:

`abrsumnew/part` := proc (p,h,v,w)
         local g,v1,w1;
         g:=gcd(p,h);
	 v1:=1;
	 w1:=p;
	 while g<>1 do
		divide(w1,g,'w1');
		v1:=v1*g;
		g:=gcd(w1,v1);
	 od;
	 v:=v1;
	 w:=w1;
	end:
	
`abrsumnew/dis`:=proc(fu,n)
local bb,bt,d,f,i,j,rootlist,rr;
    if 3 < printlevel then
        lprint(`abrsumnew/dis: computing the dispersion`)
    fi;
    bb:=denom(fu);
    bt := factor(bb);
    rootlist := 0;
    if type(bt,`*`) then
        rr := map(
           proc(x) if type(x,`^`) then op(1,x) else x fi end,convert(bt,'list')
           );
        for i to nops(rr) do
            f := op(i,rr);
            d := degree(f,n);
            if 0 < d then
                for j to nops(rr) do
                    if (i <> j) and (degree(op(j,rr),n) = d) and
                        (lcoeff(op(j,rr),n) = lcoeff(f,n)) then
                        coeff(f,n,d-1)-coeff(op(j,rr),n,d-1);
                        "/d/lcoeff(f,n);
                        if type(",integer) and (0 < ") then
                            if expand(subs(n = n+",op(j,rr))-f) = 0 then
                                rootlist := rootlist,"
                            fi
                        fi
                    fi
                od
            fi
        od;
    else rootlist:=0
    fi;
    max(rootlist)
end:

	  


`abrsumnew/rec`:=proc(f,x,d)
local p,q,a,b,u,wm,vm,wp,vp,newf,cm,cp;
   	if f=0 then RETURN(0) fi;
	if d = 0 then  RETURN (`Sum`(normal(f),x))  fi;
	p:=numer(f);
	q:=denom(f);
	cp:=gcd(q,subs(x=x+d,q));
	if cp=1 then RETURN(`abrsumnew/rec`(f,x,d-1)) fi;
	cm:=subs(x=x-d,cp);
	`abrsumnew/part`(q,cp,'vp','wp');
	`abrsumnew/part`(q,cm,'vm','wm');
	if degree(vm,x)>degree(vp,x) then
		gcdex(vp,wp,p,x,'b','a');
		u:=(subs(x=x-1,a/vp));
	        newf:=normal(b/wp+u);
	else
		gcdex(vm,wm,p,x,'b','a');
		u:=-a/vm;
		newf:=normal(b/wm + subs(x=x+1,a/vm));
	fi;
	u + `abrsumnew/rec`(newf,x,d-1)
end:
	 

	


#######
#
#      Indefinite Summation of Rational Functions
#
#
#      An Implementation of the Algorithm of Abramow
#
#      R. Pirastu, RISC Linz, March 1993
######







abrsum:=proc(e,x)
local f,ans;
f:=normal(e);
    if nargs <> 2 then ERROR(`expecting two arguments`)
    elif not type(f,ratpoly(anything,x)) then
        ERROR(`first argument must be a rational function`)
    elif not (type(x,'name')) then
            ERROR(`second argument must be a name`)
    fi;
    if not has(f,x) then RETURN(f*x) fi;
    if type(f,polynom(anything,x)) then ans := sum(f,x)
        elif type(f,ratpoly(anything,x)) then
           ans:= `abrsum/rec`(f,x,`abrsum/dis`(f,x))
    fi;
    ans;
end:



`abrsum/part` := proc (p,h,v,w)
         local g,v1,w1;
         g:=gcd(p,h);
	 v1:=1;
	 w1:=p;
	 while g<>1 do
		divide(w1,g,'w1');
		v1:=v1*g;
		g:=gcd(w1,h);
	 od;
	 v:=v1;
	 w:=w1;
	end:
	
`abrsum/dis`:=proc(fu,n)
local bb,bt,d,f,i,j,rootlist,rr;
    if 3 < printlevel then
        lprint(`abrsum/dis: computing the dispersion`)
    fi;
    bb:=denom(fu);
    bt := factor(bb);
    rootlist := 0;
    if type(bt,`*`) then
        rr := map(
           proc(x) if type(x,`^`) then op(1,x) else x fi end,convert(bt,'list')
           );
        for i to nops(rr) do
            f := op(i,rr);
            d := degree(f,n);
            if 0 < d then
                for j to nops(rr) do
                    if (i <> j) and (degree(op(j,rr),n) = d) and
                        (lcoeff(op(j,rr),n) = lcoeff(f,n)) then
                        coeff(f,n,d-1)-coeff(op(j,rr),n,d-1);
                        "/d/lcoeff(f,n);
                        if type(",integer) and (0 < ") then
                            if expand(subs(n = n+",op(j,rr))-f) = 0 then
                                rootlist := rootlist,"
                            fi
                        fi
                    fi
                od
            fi
        od;
    else rootlist:=0
    fi;
    max(rootlist)
end:






`abrsum/rec`:=proc(f,x,d)
local p,q,v,w,a,b,c,u;
   	if f=0 then RETURN(0) fi;
	if d = 0 then  RETURN (`Sum`(normal(f),x))  fi;
	p:=numer(f);
	q:=denom(f);
	c:=gcd(q,subs(x=x+d,q));
	if c=1 then RETURN(`abrsum/rec`(f,x,d-1)) fi;
	`abrsum/part`(q,c,'v','w');
	gcdex(v,w,p,x,'b','a');
	u:=subs(x=x-1,a/v);
	u + `abrsum/rec`(normal(b/w + u),x,d-1)
end:
	 
#save `ratsum.m`;
#quit;
