with(share): readshare(Hurwitz,calculus): # read `Hurwitz.m`:
p1 := z^2 + z + 1:
Hurwitz(p1,z):
if "=true then print(ok) else print(") fi:
alias(h=Hurwitz):
p2 := 3*z^3 + 2*z^2 + z + c:
h(p2,z,'s2','g2'):
if "=FAIL then print(ok) else print(") fi:
s2:
if normal(")=[3/2*z,-4*z/(-2+3*c),-1/2*z*(-2+3*c)/c]
then print(ok) else print(") fi:
g2:
p3 := 4*z^4 + z^3 + z^2 + c:
h(p3,z,'s3','g3'):
if "=FAIL then print(ok) else print(") fi:
s3:
if "=[0,4*z,z,-z/c,-z] then print(ok) else print(") fi:
g3:
p4 := z^5 + 5*z^4 + 4*z^3 + 3*z^2 + 2*z + c:
h(p4,z,'s4','g4'):
s4:
if s4[3]=289/5*z/(1+5*c) then print(ok) else print(s4[3]) fi:
g4:
p5 := p2 + I*d:
h(p5,z,'s5','g5'):
s5:
g5:
if g5=1 then print(ok) else print(g5) fi:
p11 := expand((c*z^2 + 1)*(z+1)*(z^2 + 2*z + 2)):
h(p11,z,'s11','g11'):
s11:
g11:
if g11 = c*z^2 + 1 then print(ok) else print(g11) fi:
p13 := 1 + z + z^3:
h(p13,z,'s13','g13'):
if "=false then print(ok) else print(") fi:
s13:
g13:
p14 := 1 + z + c*z^3:
h(p14,z,'s14','g14'):
if "=FAIL then print(ok) else print(") fi:
s14:
g14:
p15 := 1 + z + z^4:
h(p15,z,'s15','g15'):
if "=false then print(ok) else print(") fi:
s15:
g15:
p16 := 1 + x + c*x^4:
h(p16,x,'s16','g16'):
if "=FAIL then print(ok) else print(") fi:
s16:
g16:
# From Lanczos, p. 45.  There is a typo on the page,
# found using Maple.
Lanczos_1 := x^4 + 7.6*x^3 + 23.34*x^2 + 38.44*x + 37.40:
Hurwitz(Lanczos_1,x,'s','g'):
if "=true then print(ok) else print(") fi:
s:
g:
# From Lanczos, p 46.
Lanczos_2 := x^6 + 4.24*x^5 + 8.5*x^4 + 10.27*x^3 + 8.09*x^2 + 3.96*x + 0.98:
Hurwitz(Lanczos_2,x):
if "=true then print(ok) else print(") fi:
Lanczos_3 := expand( (x^2-0.6*x+1)*Lanczos_2 ):
Hurwitz(Lanczos_3,x):
if "=false then print(ok) else print(") fi:
# From Lanczos, p 47.
Lanczos_4 := x^6 + 68.6*x^5 + 785*x^4 + 7213*x^3 
                 + 50700*x^2 + 8200*x + 435000:
Hurwitz(Lanczos_4,x):
if "=false then print(ok) else print(") fi:
#
# Now a series of examples from Henrici.
#
# Peter Henrici, Vol 2 of Applied and Computational Complex Analysis
# p 559-560, problems 1,2,3 (part),6 (part).
#
Henrici_1 := z^3 + mu*z^2 + delta*z + 1:
h(Henrici_1,z,'s','g'):
s:
# Stable iff delta > 0 and mu*delta > 1 according to Henrici.
Henrici_2 := z^4 + a*z^3 + b*z^2 + c*z + 1:
h(Henrici_2,z,'s','g'):
s:
# Stable iff c > 0 and b*c - a > 0 and a > c^2/(b*c-a) by Henrici.
ex_1 := 1 + x/1!:
h(ex_1,x):
if "=true then print(ok) else print(") fi:
ex_2 := ex_1 + x^2/2!:
h(ex_2,x):
if "=true then print(ok) else print(") fi:
ex_3 := ex_2 + x^3/3!:
h(ex_3,x):
if "=true then print(ok) else print(") fi:
ex_4 := ex_3 + x^4/4!:
h(ex_4,x):
if "=true then print(ok) else print(") fi:
ex_5 := ex_4 + x^5/5!:
h(ex_5,x):
if "=false then print(ok) else print(") fi:
ex_6 := ex_5 + x^6/6!:
h(ex_6,x):
if "=false then print(ok) else print(") fi:
#
# I am not sure if there aren't deep implications of the fact
# that ex_n is unstable for n >= 5...
#
Bessel_ex := n -> sum( '(n+k)!/(n-k)!/k!*(z/2)^k','k'=0..n):
Bessel_ex(10):
h(",z,'s','g'):
if "=true then print(ok) else print(") fi:
s:
if s=[0,z,3*z,5*z,7*z,9*z,11*z,13*z,15*z,17*z,19*z] then 
  print(ok)
else 
  print(") 
fi:
# Should have the pattern 1, 3, 5, ... , (2*n-1).
#
# From Henrici vol 1, p 488.
p := z^3 + z^2 + 4*z + 30:
h(p,z):
if "=false then print(ok) else print(") fi:
#
# Should be false.  This example was used to show that the simple
# necessary criterion of "all coefficients positive" is not sufficient.
#quit
