#
# These tests (RMC June 1991) execute in 165 seconds on a
# 25 MHz IBM 386 machine running Maple V.
#
# RowEchelon updated July 1992 to use Normalizer, and
# the routines BackSubstitute and RowEchelonSolve added.
#
# The tests now run in less than 1 minute on a 33Mhz IBM-
# compatible 486 machine.
#
# This file sets interface(echo=0) and then resets it to 
# interface(echo=2) on output.
#
# It also defines the utility operators "ones" and "zeros".
# In 5.1 there are better ways to define these utility operators.
#
interface(echo=0):
with(share): readshare(Echelon,linalg): # read `Echelon.m`;
ones := proc(m,n) option operator; local i,j; array(1..m,1..n,[seq([seq(1,i=1..n)],j=1..m)]) end:
zeros := proc(m,n) option operator; local i,j; array(1..m,1..n,[seq([seq(0,i=1..n)],j=1..m)]) end:
Strang := array(1..3,1..4,
  [ [ 1, 3, 3, 2],
    [ 2, 6, 9, 5],
    [-1,-3, 3, 0] ]):
R := RowEchelon(Strang,'dt'):
if (op(op(R)) = op(array(1..3,1..4,
  [ [ 1, 3, 0, 1],
    [ 0, 0, 1, 1/3],
    [ 0, 0, 0, 0] ]))  )        and 
   ( dt = 3) then print(okay) else print(R,dt) fi;
Goldberg1 := array(1..3,1..5,
  [ [ 0, 1, 1, 1, 1],
    [ 0,-1,-1, 1, 1],
    [ 0, 1, 1,-1, 2] ]):
R := RowEchelon(Goldberg1,'dt','rank','P','L','U'):
if (op(op(R)) = op(array(1..3,1..5,
  [ [ 0, 1, 1, 0, 0],
    [ 0, 0, 0, 1, 0],
    [ 0, 0, 0, 0, 1] ])) )   and
    (op(evalm( Goldberg1 - P &* L &* U &* R)) =
     op(zeros(3,5))) then print(okay) else print(R,dt) fi;
Goldberg2 := array(1..3,1..5,
  [ [ 1, 1, 1, 1, a],
    [ 0,-1,-1, 1, b],
    [ 0, 1, 1,-1, c]]):
R := RowEchelon(Goldberg2, 'dt','rank','P','L','U'):
if (op(op(R)) = op(array(
    1 .. 3, 1 .. 5,[(3, 1)=0,(3, 2)=0,(1, 1)=1,(3, 3)=0,(1, 2)=0,(3, 4
    )=0,(2, 1)=0,(1, 3)=0,(3, 5)=1,(2, 2)=1,(1, 4)=2,(2, 3)=1,(1, 5)=0,
    (2, 4)=-1,(2, 5)=0]))) and
   (op(evalm( Goldberg2 - P &* L &* U &* R)) = op(zeros(3,5))) then
   print(okay) else print(R,dt) fi;
Goldberg3 := subs(b=-c,op(Goldberg2)):
R := RowEchelon(Goldberg3,'dt','rank','P','L','U'):
if (op(evalm(Goldberg3 - P &* L &* U &* R)) = op(zeros(3,5))) then
   print(okay) else print(R,dt) fi;
Noble1 := array(1..3,1..4,[[1,-2,3,1],[2,k,6,6],[-1,3,k-3,0]]):
R := RowEchelon(Noble1,'dt','rank','P','L','U'):
if (dt=k*(k+4)) and 
   (op(map(normal,evalm( Noble1 - P&*L&*U&*R))) = op(zeros(3,4))) 
then print(okay) else print(R,dt) fi;
#
# Test two degenerate cases
#
Degenerate1 := zeros(5,8):
R := RowEchelon(Degenerate1,'dt','rank','P','L','U'):
if ( op(evalm(P&*L&*U&*R-Degenerate1)) = op(zeros(5,8)) )
then print(okay) else print(R,dt,rank) fi;
Degenerate2 := ones(1,1):
R := RowEchelon(Degenerate2,'dt','rank','P','L','U'):
if (dt = 1) and (rank=1) and 
   ( op(evalm(P&*L&*U&*R-Degenerate2)) = op(zeros(1,1)) ) 
then print(okay) else print(R,dt,rank) fi;
#
# Test complex numbers
#
Normalizer := evalc:
Complex1 := array(1..2,1..2,[[ I, 1],[-I,1]]):
R := RowEchelon(Complex1,'dt','rank','P','L','U'):
if (rank = 2) and (dt = 2*I) and
   (op(evalm(P&*L&*U&*R-Complex1)) = op(zeros(2,2)))
then print(okay) else print(R,dt,rank) fi;
Complex2 := array(1..2,1..2,[[ 1, I],[-I,1]]):
R := RowEchelon(Complex2,'dt','rank','P','L','U'):
if (rank = 1) and
   (op(evalm(P&*L&*U&*R-Complex2)) = op(zeros(2,2)))
then print(okay) else print(R,dt,rank) fi;
#
# Now test the algebraic numbers (in a simple way)
#
alias(I=RootOf(z^2+1,z)):
Normalizer := x -> evala(Normal(x)):
Algebraic1 := array(1..2,1..2,[[ I, 1],[-I,1]]):
R := RowEchelon(Algebraic1,'dt','rank','P','L','U'):
if (rank = 2) and
   (op(map(Normalizer,evalm(P&*L&*U&*R-Algebraic1)))
        = op(zeros(2,2)))
then print(okay) else print(R,dt,rank) fi;
Algebraic2 := array(1..2,1..2,[[ 1, I],[-I,1]]):
R := RowEchelon(Algebraic2,'dt','rank','P','L','U'):
if (rank = 1) and
   (op(map(Normalizer,evalm(P&*L&*U&*R-Algebraic2)))
        = op(zeros(2,2)))
then print(okay) else print(R,dt,rank) fi;
#
# One that is not convenient for hermite normal form:
#
Normalizer := normal:
Transcendental1 := array(1..2,1..2,[[x,tan(x)],[tan(x),x]]):
R := RowEchelon(Transcendental1,'dt'):
if (dt = x^2-tan(x)^2) then print(okay) else print(R,dt) fi;

#quit
