#
#       TEST FILE FOR KINETICS
# 

#read `kinetics.m`;
with(share):readshare(kinetics,science):

#
# Test 1
# all possible uniary and binary reactions
#

R:=[a>a,a>b,a>a+b,a>b+c,a>a+a,b>a+a,a+b>c,a+b>a,a+a>b,a+a>a,
a+b>c+d,a+b>a+c,a+b>a+a,a+a>c+d,a+a>a+c,a+a>a+a,b+c>a+a]:

odes():

if 
        op(2,ode.1)=-k2*a-k4*a+k5*a+2*k6*b-k7*a*b-2*k9*a**2-k10*a**2-k11*a*b+k13*a*b-2*k14*a**2-k15*a**2+2*k17*b*c
or 
        op(2,ode.1)=k2*a+k3*a+k4*a-k6*b-k7*a*b-k8*a*b+k9*a**2-k11*a*b-k12*a*b-k13*a*b-k17*b*c
or 
        op(2,ode.1)=k4*a+k7*a*b+k11*a*b+k12*a*b+k14*a**2+k15*a**2-k17*b*c
then 
        print(`OK FOR TEST 1.a`)
else 
        print(`TEST 1.a FAILED`,ode.1)
fi;
print();

laws():

if nlaws=0 then
        print(`OK FOR TEST 1.b`)
        else print(`TEST 1.b FAILED`,nlaws)
fi;

steady():

if nzeros=0 then
        print(`OK FOR TEST 1.c`)
        else print(`TEST 1.c FAILED`,species[1],species[2])
fi;
print();

#
#       TEST 2 (ozone)
#

R:=[O2+Hv>OO + OO,OO + O2+M>O3+M,O3+Hv>O2+OO,O3+OO>O2+O2];


odes():

laws():

print();
if nlaws=2 then
        print(`OK FOR TEST 2.a`)
        else print(`TEST 2.a FAILED`,nlaws)
fi;

steady():

if nzeros=0 then
        print(`OK FOR TEST 2.b`)
        else print(`TEST 2.b FAILED`,nzeros)
fi;
print();

#
#       TEST 3 (liddell)
#

R:=[u2>y2,x>u2,x>v2,v2>z2,x>v,v>x,v>z,x>u,u>x,u>y];

odes():

laws():

print();
if nlaws=4 then
        print(`OK FOR TEST 3.a`)
        else print(`TEST 3.a FAILED`,nlaws)
fi;

steady():
result := zeros[1]+zeros[2]+zeros[3]+zeros[4]+zeros[5]:
if result=u2+x+v2+v+u then
	print(`OK FOR TEST 3.b`)
	else print(`TEST 3.b FAILED`,result)
fi;             

#quit
