#
## <SHAREFILE=analysis/partials/partials.mpl >
## <DESCRIBE>
## Maple procedures for partial and functional derivatives
##                 Author: E.S.Cheb-Terrab, TERRAB@BRUERJ.BITNET
## </DESCRIBE>
## <UPDATE=R4 >

#partials:=`_partials`:
macro( TABLEREF = 6,
       FUNCTION = 13 );
########################################################################
# Date: September/20/94. Version: 1.2
#
# Author: E.S.Cheb-Terrab
#         Departamento de Fisica Teorica
#         Instituto de Fisica
#         Universidade do Estado do Rio de Janeiro, Brasil.
#         E-mail: TERRAB@BRUERJ.BITNET
#
# Partials package: Maple procedures for partial and functional derivatives
#
# Contents: - the main commands of the package (lines 27-1473)
#           - type subroutines used by the commands of the package, maybe
#             interesting by themselves (lines 1473-1594)
#           - help for the commands in Maple help style (lines 1594-2585)
#           - Instructions for building a library and the MAKELIB command,
#             for future loading of the package using the with command
#             (lines 2585-2991)
#
########################################################################
# Necessary for procedures depending on expand/int:

readlib(`expand/int`):
########################################################################
#                The main commands
########################################################################
pdiff := proc(a::{algebraic,`=`},b::{name,function})
local a1,a2,a3,i,k,uu,ff,vv,frozendiff,restore_diff,s1,s2,s3,frozen;

options `Copyright 1993 by E. S. Cheb-Terrab`;

    if nargs=3 and args[3]={} then RETURN(pdiff(args[1],args[2]))
    elif type(args[1],`=`) then RETURN(map(pdiff,args[1],args[2..nargs])):
    elif type(args[1],'procedure') then
        ERROR(`Invalid first argument of type procedure while not evaluated`
            )
    elif not type(args[nargs],{'set','function','name'}) then
        ERROR(`pdiff expects its last argument to be of type {set`,
            `function, name} but received`,args[nargs])
    elif 2 < nargs and
        not map(type,{args[2 .. nargs-1]},{'function','name'}) = {'true'}
         then
        ERROR(`Derivation variables`,op({args[2 .. nargs]} minus
            indets({args[2 .. nargs]},{'function','name'})),
            `must be functions or names`)

# High order derivatives

    elif 3 <= nargs and not type(args[nargs],set) then
        args[1];
        for i in [args[2 .. nargs]] do
            pdiff(",i); if " = 0 then RETURN(0) fi
        od;
        RETURN(")
    elif 3 < nargs then
        args[1];
        for i in [args[2 .. nargs-1]] do
            pdiff(",i,args[nargs]); if " = 0 then RETURN(0) fi
        od;
        RETURN(")
    fi;

# Here begins the job

    a1 := eval(args[1]);
    a2 := eval(args[2]);
    if nargs=3 then a3 := eval(args[3]) fi:

# Partial derivative with args[2] = name (explicit when nargs=3)

    if type(a2,'name') then
        if not has(a1,a2) then RETURN(0)
        elif nargs = 2 then RETURN(diff(a1,a2))
        fi:

# Case no functions are to be frozen

        if assigned(_Env_frozen) then frozen := _Env_frozen
            else
            if not has(a3,a2) then RETURN(diff(a1,a2))

# Case there are functions to be frozen; they are collected in "frozen"

            else

# Warning: Functions `$`, `@@`, `@` may lead to errors !!

                indets(a3,'Function');
                if has(a3,'D') then
                    indets(a3,'De');
                    map(u -> op(op(0,u))(op(u)),") union ""
                fi;
                frozen := map(proc(x) if has(args) then x fi end,",a2);
                if frozen = {} then RETURN(diff(a1,a2)) fi
            fi;
        fi;

# Case there are functions to be frozen: the set is completed with the
# functions' derivatives found inside a1. As a first step, Diff -> diff when
# necessary

        frozendiff := {}:
        if has(a1,'Diff') then
            proc(x) if has(op(1,x),map(u -> op(0,u),args[2])) then x fi end;
            map(",indets(a1,Diff),frozen);
            map(u -> u = subs('Diff' = 'diff',u),");
            a1 := subs(",a1)
        fi;

# The derivatives which are going to be frozen are selected

        if has(a1,{'diff','D'}) then
            proc(x)
                op(0,x):
                map(u -> op(0,u),args[2]):
                if "" = 'diff' and has(op(1,x),") or member(op(""),")
                    then  x
                fi
            end;
            frozendiff := map(",indets(a1,{'diff','De'}),frozen);
        fi;

# Complete the "frozen" set:

        proc(u,v,w,x)
            if has(u,w) then op(0,u):
                if member(",v) then u elif member(",{'Int','int'}) then op(x)
                fi
            fi
        end:
        map(",indets(a1,'function'),map(u -> op(0,u),frozen),a2,frozen);

# If none of them exist inside a1 then RETURN

        if "={} and frozendiff=" then RETURN(diff(a1,a2))
        else frozen := {op("),op(frozen)} :
        fi:

# Here, the integrals which are going to be frozen are selected.
# Criterion: the integrals are viewed as the RESULT, not as a Sum over
# an integrand.
# Also, definite integrals are treated as functions of the
# integration limits, but are also frozen to avoid int to be spontaneously
# evaluated after the freezing of part of the integrand.

        if has(a1,{'int','Int'}) then

# Note the expand command to take objects not depending on the integration
# variable out of the process...

            a1 := (eval@subs)({'Int'=`expand/Int`,'int'=`expand/int`},a1):
            _Env_frozen := frozen:
            _Env_frozen_diff := frozendiff:
            _Env_uu := uu = a2:

# Below is a procedure which selects integrals to be treated with special care.
# If the integral contains diff_var, then it is frozen (Int->pdiff/frozenInt).
# Also, the diff_var is introduced as a third argument in order to allow
# diff/pdiff/Int to work (remember that diff_var is changed into uu, and,
# if no indication about the existence of diff_var remains, then diff will
# not send the task to diff/pdiff/Int).
# Additionally, the Has routine is used, in order to consider only the true
# functional dependence of definite integrals (i.e. not the integation
# variable).

            proc(f,diff_var)
                if Has(f,diff_var) then
                f = subs({int=`pdiff/int`,Int=`pdiff/Int`},op(0,f))
                    (op(f),diff_var):   # Introduce third argument = diff_var.
                fi:
            end:

# The procedure above is mapped over two arguments:
# 1) the integrals
# 2) the differentiation variable
# Finally, the result is inserted in a1

            map(",indets(a1,{'int','Int'}),a2):

# Case integrals inside integrals...

            if nops(") > 1 then
               map((u,v) -> lhs(u)=subs(v,rhs(u)),",");
            fi:
            a1 := subs(",a1);
        fi;

# The freezing is done by changing the name of the differentiation variable
# inside derivatives and functions

        [op(frozendiff),op(frozen)];
        subs(a2 = uu,");
        a1 := subs([seq(""[k] = "[k],k = 1 .. nops("))],a1):

# The derivative is realized
subs(     uu = a2,
{`pdiff/int` = (() -> 'int'(args[1..2])),
 `pdiff/Int` = (() -> 'Int'(args[1..2]))}, diff(a1,a2));
RETURN("):

##############################
# Case differentiation variable of type function.
# The idea is: after analysis, subs the differentiation function a2 by ff,
# realize diff(..,ff), and afterwards subs(ff=a2,"):

    elif type(a2,'function') then
        if nargs=3 then
            eval(args[3]):
            if has(",'D') then
                indets(",'De');
                map(u -> op(op(0,u))(op(u)),") union ""
            fi;
            if member(a2,") then
            ERROR(`It does not make sense to differentiate with respect to`,
            a2,` keeping`,{a2},` fixed`):
            fi:

# The next two lines are related to other steps below which call pdiff

            indets(subs(a2=ff,"),'Function');
            _Env_frozen := map(proc(x) if has(args) then x else NULL fi end,",ff);

        elif op(0,a2) = `$` then
            if type(op(1,a2),{'diff','Diff'}) then
                if not has(a1,useD(op(1,a2))) then RETURN(0) fi:
            elif type(op(1,a2),'De') then
                if not has(a1,usediff(op(1,a2))) then  RETURN(0) fi:
            elif not has(a1,op(1,a2)) then RETURN(0)
            fi:
                if nargs = 2 then RETURN('pdiff'(a1,a2))
                else RETURN('pdiff'(a1,a2,args[3]))
                fi:
        fi;
        if not (has(a2,{'Diff','diff','D'}) or has(a1,{'int','Int',a2}))
             then
            RETURN(0)
        fi;

# In this part, the task which will be realized by either diff or pdiff is prepared.
# First, the derivatives of a2 are converted to the D syntax.

        if has(a2,{'Diff','diff'}) then a2 := useD(a2) fi;

# Next, the diff inside a1 are also converted (if required).  To keep the user's
# syntax unchanged as much as possible, a restore set (restore_diff) is
# created.
# In the end, all derivatives converted to D syntax during the calculation
# will be restored.
# If a converted diff derivative already exists with the D format inside a1,
# then it will not be restored. (The rules are better explained in the HELP).

        restore_diff := {};
        if has(a1,{'Diff','diff'}) then
            s1 := [op(indets(a1,'De'))];
            s2 := [op(indets(a1,{'Diff','diff'}))];
            s3 := useD(s2);
            restore_diff := map(
            proc(u) if member(op(1,args[1]),args[2]) then NULL else u fi end,
                                   {seq(s3[k] = s2[k],k = 1 .. nops(s3))},s1);
            a1 := subs({seq(s2[k] = s3[k],k = 1 .. nops(s3))},a1);
            if has(a1,'diff') then ERROR(`Unknown failure`) fi
        fi;

# An exit point happens if no int,Int or a2 exist inside a1.

        if not has(a1,{'int','Int',a2}) then RETURN(0) fi;

# Next, derivatives of a2 appearing with D format inside a1 are frozen:

        if has(a1,'D') then

# Only occurrences of a2 appearing inside the derivand, here represented by
# op(op(0,i)), need to be frozen.
# Probably, what follows is not necessary, since D(f(x)) is an ERROR.

            for i in indets(a1,'De') do
                if has(op(op(0,i)),a2) then
                    a1 := subs(i = subs(op(a2) = vv,i),a1)
                fi
            od
        fi;

# Integrals containing a2 are frozen here.

        if has(a1,{'int','Int'}) then

# Note the expand command taking objects not depending on the integration
# variable out of the process

            a1 := (eval@subs)({'Int'=`expand/Int`,'int'=`expand/int`},a1):
            _Env_ff := ff = a2:
            proc(f,dfv)       # f = an integral.
                              # dfv = differentiation_(function)_variable
            map((var,f) -> Has(f,var),{op(dfv)},f):
                if " = {'true'} or has(f,op(0,dfv)) then
                f = subs({int=`pdiff/int`,Int=`pdiff/Int`},op(0,f))
                    (op(f),dfv):  # Introduce third argument dfv = diff_var.
                fi:
            end:

# The procedure above is mapped over two arguments:
# 1) the integrals
# 2) the differentiation variable

            map(",indets(a1,{'int','Int'}),a2):

# Case integrals inside integrals...

            if nops(") > 1 then
               map((u,v) -> lhs(u)=subs(v,rhs(u)),",");
            fi:
            a1 := subs(",a1);
        fi;

# Next, a2 is frozen and the derivative is evaluated.  To make explicit
# partial derivatives w.r.t. functions possible (when a third argument
# exists), pdiff is called with the _Env_frozen indication. This
# indication will avoid the repetition of some steps.

        if nargs = 2 or  _Env_frozen = {} then diff(subs(a2 = ff,a1),ff)
        else subs('pdiff'=''pdiff'',pdiff(subs(a2 = ff,a1),ff,_Env_frozen)):
        fi;

# Now, a conversion to D is necessary to avoid errors with diff taking
# functions as second argument

        if has(",'diff') then useD(") fi
    fi;

# Here begins the restoring procedure. The intermediate variables ff and vv are
# also eliminated.  Finally, one more level of evaluation, for the restoration
# of integrals, is realized

    subs([ff = a2,vv = op(a2),pdiff=''pdiff''],
    {`pdiff/int` =(() -> int(args[1..2])) ,
     `pdiff/Int` =(() -> Int(args[1..2]))},
    restore_diff,"):
";
end:
########################################################################
#           Selection criteria for integrals which will be analyzed
#
# Case type(diff_var,'name') and  _Env_frozen <> {}
#
#           if Has(integral,diff_var) then integral fi
#
# Case type(diff_var,'function')
#
#           if Has(integral,ALL_op_of_diff_var) or has(integral,op(0,dfv))
#           then integral
#           fi
#
# The "or" case above gives a protection, avoiding errors after freezing dfv
# (dfv = diff_var of type function) inside integrals.
#####################################################################
`diff/pdiff/Int` := proc(integrand,dx)

# Arguments: both the integrand and dx arrive with the diff_var = uu, where uu
# is given by the lhs of _Env_uu. (_Env_uu := (uu=diff_var)).
#
# Remember that pdiff/Int contains three arguments, where the third is the
# diff_var. Thus, diff/pdiff/Int receives four arguments, of which the
# fourth is also equal to diff_var.
#
# If the diff_var corresponds to a partial derivative w.r.t functions, then
# the third and fourth arguments received here are equal to the lhs of
# _Env_ff.  (_Env_ff := (ff=dfv)).

local func,vars,diff_var,int_var,int_limits,integral,definite,w,Case_name,
      via_diff,via_pdiff;

options `Copyright 1993 by E. S. Cheb-Terrab`;

# Define diff_var, int_var, int_limits and the case.

diff_var := args[3]:
definite := type(dx,`=`):
Case_name := has(_Env_uu,diff_var):
if _Env_uu='_Env_uu' then _Env_uu:= 0 = 0 fi:

# Case: type(diff_var,'name')

if Case_name then
    if definite then

# The following step restores true variables in definite integrals (freezing
# the int_var) in order to analyze the integral


        int_var := subs(_Env_uu,op(1,dx)):    # True int_var
        int_limits := subs(_Env_uu,op(2,dx)): # True int_limits
        integral := [subs(_Env_uu,int_var=w,integrand),w=int_limits]
                                              # Integral with frozen int_var.
                                              # Note uu was eliminated.
    else int_var := dx:
        integral := subs(_Env_uu,[integrand,dx]) # True indefinite integral
    fi:

# The following result is correct both for definite and indefinite integrals.
# If the integral contains ALL the functionality of ANY of the frozen
# functions (_Env_frozen), then the RESULT may contain the frozen function in
# an unpredictable manner.  Thus, the program returns unevaluated through
# pdiff.
#
# Else, the RESULT cannot contain ANY of the frozen functions. Thus, one can
# obtain the result straight through diff

    for func in _Env_frozen do
        vars := {op(func)}:             # The variables of func

# The integral is checked to see if it contains all the functional dependence
# of the frozen functions. If true, any function of _Env_frozen can appear in
# the RESULT of the integral.  Thus, the routine returns unevaluated through
# pdiff.

        map((var,integral) -> Has(integral,var),vars,integral):
            if "={'true'} then
            subs(w=int_var,Int(op(integral))):
RETURN(''pdiff''(",diff_var,_Env_frozen)) fi:     # Returns unevaluated
    od:

# Else, the routine returns evaluated via diff, since it is impossible to
# receive any of _Env_frozen in the RESULT.

    subs(_Env_uu,Int(integrand,dx)):
    RETURN(diff(Int(integrand,dx),diff_var)):

else       # Case type(diff_var,'function').

# Case definite integral. ff (of type string) represents a mask for dfv.

    if definite then
    int_var := op(1,dx):                      # True int_var
    int_limits := op(2,dx):                   # int_limits(ff)
    integral := [subs(int_var=w,integrand),w=(int_limits)]:
                                              # Integral with frozen int_var
                                              # as function of (ff).
    else

# Case indefinite integral

    int_var := dx:                            # True int_var
    integral := [integrand,dx]:               # Integral as function of (ff).
    fi:

# The following result is correct both for definite and indefinite integrals.

# Has(integral(diff_var), All_op_of_dfv)

    map((var,f) -> Has(f,var),{op(rhs(_Env_ff))},integral):
    if " = {'true'} then via_pdiff
    elif has(integral,diff_var) then
        if has([op(rhs(_Env_ff))],int_var) then
            if definite then
                if has(int_limits,diff_var) then
                    if _Env_frozen='_Env_frozen' then via_diff else via_pdiff
                    fi
                else RETURN(0)
                fi:
            else via_pdiff
            fi:
        elif _Env_frozen='_Env_frozen' then via_diff
        else via_pdiff
        fi:
    else RETURN(0)
    fi:

# The via_... are transformed into a result.

    if " = via_diff then
        if member(_Env_frozen ,{'_Env_frozen',{}}) then
            if definite then subs({w=int_var,_Env_ff},integrand)
            else integrand
            fi:
            subs({w=int_var,_Env_ff},useD(diff(Int(",dx),diff_var))):
            RETURN("):
        else useD(pdiff(Int(op(integral)),diff_var,_Env_frozen)):
        RETURN(subs({w=int_var,_Env_ff},")):
        fi:
   else
       if not member(_Env_frozen ,{'_Env_frozen',{}})
            then {_Env_frozen}
            else {}
       fi:
       subs({w=int_var,_Env_ff},Int(integrand,dx)):
       RETURN(''pdiff''(",diff_var,op("")))            # Returns unevaluated
   fi:

fi;      # End of "if" which started at the beginning of the proc.
end:
#####################################################################
`diff/pdiff/int` := subs('Int'='int',eval(`diff/pdiff/Int`)):
#####################################################################
Has := proc(f,x)
options `Copyright 1993 by E. S. Cheb-Terrab`;
map(`Has/definite_int`,indets(f,{'int','Int'})):

# Case inner integrals exists, one must assure that all the RHS contains
# frozen via (change of dx into duu) definite integrals

if nops(") > 1 then
    map((u,v) -> lhs(u)=subs(v,rhs(u)),",");
fi:

# Next, the uu freezing in introduced inside the expression and the result is
# evaluated:

if has(subs(",f),x) then 'true' else 'false' fi:
end:
#####################################################################
`Has/definite_int` := proc(U) local uu;
options remember;
if type(op(2,U),`=`) then
        op(2,U):
        op(1,U),op(1,"),op(2,"):
         U = subsop(1=subs("[2]=uu,"[1]),2=(uu="[3]),U):
fi:
end:
########################################################################
`diff/pdiff` := proc()
'pdiff'(diff(args[1],args[nargs]),args[2..nargs-1])
end:
########################################################################
`diff/Pdiff` := proc()
'Pdiff'(diff(args[1],args[nargs]),args[2..nargs-1])
end:
########################################################################
usepdiff := proc(aa::{algebraic,`=`})
            local u,diff_vars,w,i,k,name0,name1,nome,vars,set3;
            options `Copyright 1993 by E. S. Cheb-Terrab`;

if not has(aa,'D') then  RETURN(aa)
else u := aa:
fi:
for k in indets(u,'De')
do:

# Case of assigned function, (else next till exit through od)

# eval(op(op(0,k))):
# if '"'(op(k))="(op(k)) then next fi:

name1 := op(0,k):
vars := op(k):
nome := op(name1):

if not type(nome,'procedure') then next
else
    if op(4,eval(nome))= NULL then next fi:
    proc(u) if lhs(u) <> rhs(u) then [lhs(u)] fi end:
    map(",op(op(4,eval(nome)))):
    if not has(",[[vars]]) then next fi:
fi:

if type(name1,{'indexed','function'}) then name0 := op(0,name1):
    if not type(name0,{'name',`@@`(anything,anything)}) then next fi:
fi:

# Case k = D(?)(?)

    if name0='D' then
        if nops(k)<>1 then
        ERROR(`Missing index in D derivative of a multivariate function:`,k)
        elif not type(vars,{'function','name'}) then next
        else w := pdiff(op(name1)(vars),vars):
        fi:

# Case k = D[?,?,..](?)(?) (Multivariate function)

    elif op(0,name0)='D'
           then if not type(name0,'indexed') then next
                else diff_vars := NULL:
                    for i in [op(name0)] do:
                        if type(i,'posint') then
                            diff_vars := diff_vars,traperror(vars[i])
                        elif type(i,`$`('posint','anything')) then
                            diff_vars := diff_vars,traperror(vars[op(1,i)])$op(2,i)
                        else diff_vars := FAIL: break:
                        fi:
                    od:
                fi:
           if diff_vars = FAIL or not map(type,{diff_vars},{'function','name'})={'true'}
                then next
           elif has([diff_vars],lasterror) then
           ERROR(`Wrong syntax for derivatives using D with too high index was found:`,k)
           fi:

#           `usepdiff/aux` := proc(var,diff_vars)
#           options trace;
           proc(var,diff_vars)
           if not member(var,diff_vars) then
               if type(var,{'diff','Diff'}) then op(1,var)
               elif type(var,'De') then op(op(0,var))(op(var))
               else RETURN(var):
               fi:
               if not member(",diff_vars) then var fi
           fi
           end:
           proc(u) if type(u,'function') and op(0,u)=`$` then op(1,u) else u
                   fi
           end:
           map(",{diff_vars}):
           map(""",{vars},"):
           if "={} then set3 := NULL else set3 := " fi:
           w := pdiff(nome(vars),diff_vars,set3):

# Case k = D^(?)(?)(?) = `@@`(D,?)(?)(?)

    elif op(0,name0)=`@@`
           then if nops(k) > 1 then
ERROR(`Ambiguous derivative of order`,op(2,name0),
      `with no indication of the differentiation variable`):
                fi:
           w := pdiff(op(name1)(vars),vars$op(2,name0))
    fi:
u := subs(k=w,u) ;
if not has(u,'D') then RETURN(u) fi:
od:
RETURN(u);
end:
########################################################################
# alias(delta=Dirac);

fdiff := proc(a::algebraic)
local
i,j,k,l,n,u,nome,frozen_name,a1,func_in_a1,D_derivatives,i_derivatives,delta,
diff_delta,simple_int,Y,Y_int,inv_Y_int,diff_Y_int,r_Int,r_deriv,res;
options `Copyright 1993 by E. S. Cheb-Terrab`;

# Problems with option remember: the arguments of procedures, when they are
# assigned functions, are evaluated only one level and not fully evaluated.
# For instance f(x) := g(x) followed by g(x) := h(x), will lead to a wrong
# result, since fdiff(f(x),...) will be evaluated over g(x) and not over h(x).
# This may be solved using alternative remember table technics...
#
# Error messages

if nargs<2 then ERROR(`Missing arguments`):
elif not map(type,{args[2..nargs]},'function')={'true'}
     then ERROR(`Derivation variables`,op({args[2..nargs]}
     minus indets({args[2..nargs]},'function')),`must be functions`):
elif nargs >= 3
  then args[1]:
  for i in [args[2..nargs]] do:
  fdiff(",i):
  if " = 0 then RETURN(0); fi:
  od:
  RETURN(");
fi:

# Here begins the job

nome :=  op(0,args[2]):
if has(nome,{'diff','Diff','D'}) then
ERROR(`Functional differentiation variables cannot be derivatives as in`,
args[2]):
fi:
a1 := eval(args[1]):
if not has(",nome) then RETURN(0) fi:

if has(a1,{'diff','Diff'}) then
_Env_NOME := nome:
a1 := eval(subs({diff=`fdiff/auxdiff`,Diff=`fdiff/auxDiff`},a1)):
fi:

# D derivatives of the functional differentiation variable "nome"

if has(a1,'D') then
    proc(u,nome) if op(op(0,u))= nome then u fi end:
    D_derivatives := map(",indets(a1,'De'),nome):
    func_in_a1 := map((u,nome) -> nome(op(u)),",nome):
else D_derivatives := {}: func_in_a1 := {}:
fi:

# Case nome with index !!.  A[mu] is viewed as different from A. That is
# fdiff(A[mu](x),A(u)) = fdiff(A(x),A[mu](u)) = 0
# In the following line, if no functions with nome appears inside a1, even
# inside a "D(nome)(...)" statement, then 0

proc(u,nome) if op(0,u) = nome then u fi end;
func_in_a1 := {op(func_in_a1),op(map(",indets(a1,'function'),nome))}:
if "={} then RETURN(0) fi:

# Checking the consistency of the number of arguments of the differentiation
# function named "nome", appearing in the derivand

map(z -> nops({op(z)}),"):
if nops(") > 1 or op(")<>nops(args[2]) then
ERROR(`The number of parameters of`,args[2],
      `must be the same as that of`,op(func_in_a1),
      `Additionally, repeated parameters inside one function are not allowed`):
elif not map(z -> op(z),func_in_a1) intersect {op(args[2])}={} then
ERROR(`All the arguments of the derivation function`,args[2],
      `must be different from those used for`,nome,` inside`,args[1]):
fi:

# Building set of integrals containing the differentiation function and
# functional differentiation of the integrands.
#
# The main idea of this command is:
# - 1) evaluate the functional derivative of integrals.
# - 2) evaluate the functional derivative with respect to any term but
#      not integrals
# - 3) add the results.
#
# The lines which follows corresponds to the first step.

if has(a1,'int') then a1 := subs('int'='Int',a1): fi:
simple_int := {}:
Y_int := {}:                  # Special frozen set
inv_Y_int := {}:              # Inverse set
diff_Y_int := {}:             # Equations: fdiff @ Int = Int @ fdiff
if has(a1,'Int') then
   simple_int := indets(a1,'simpleint'):
   for i in simple_int do:
     if has(simple_int minus {i},{i}) then # Selects external integrals
     simple_int := simple_int minus {i}:
     elif not has(op(1,i),nome) then
     simple_int := simple_int minus {i}:   # Throw away those not 'having' nome
     else Y_int := {Y[nops(Y_int)+1](u)=i,op(Y_int)}:
                                           # Above keeps information about the
                                           # integration variable to avoid
                                           # errors when expand/Int
          diff_Y_int := {diff(Y[nops(Y_int)](u),u)
                      = Int(fdiff(op(1,i),args[2]),op(2,i)), op(diff_Y_int)}:
                                           # Above:  fdiff @ Int = Int @ fdiff
     fi:
   od:
   inv_Y_int := map(z -> rhs(z)=lhs(z),Y_int):
fi:

# Functional differentiation of the integrals. Result accumulated in r_Int
# after elimination of Y integrals through Y_int and diff_Y_int

if simple_int={} then r_Int := 0:

# If there are integrals, substitute them by their Y_int(u) expressions,
# differentiate w.r.t  u and restore the integrals before evalDi-evaluation of
# those containing the Dirac delta function

   else a1 := subs(inv_Y_int,a1):
   r_Int := subs(diff_Y_int,Y_int,diff(a1,u)):

# Evaluation of integrals containing the Dirac delta function

   r_Int := evalDi(r_Int):
fi:

#####################################################
# Here begins the second of the steps mentioned above.
# Functional differentiation not taking into account the integrals. Results
# accumulated in r_deriv and in res
# To differentiate without taking into account that part inside integrals
# already evaluated, the "nome" inside that part will be frozen.

if not Y_int = {} then
a1 := subs(subs(nome=frozen_name,Y_int),a1):
fi:

res := 0:
for i in func_in_a1 do:

# Preparation of the Dirac delta function

   delta := product(Dirac(op('k',[op(i)])-op('k',[op(args[2])])),
          'k'=1..nops([op(args[2])])):

# Selection of Derivatives of Function i (i exists inside func_in_a1),
#
# Criteria: we look if the functionality of the derivand is the same as that
# of function i.  The idea is to create a special set, i_derivatives, with D
# derivatives of the function i.  Afterwards, the contribution to the
# functional derivative, appearing because of these i_derivatives, is
# built using pdiff.  The reason for using the set i_derivatives instead of
# the set D_derivatives is that, the elements of func_in_a1 are functions with
# the same name but evaluated at different points (different functionality).
# Then, a different delta function must be built for each i. Now, D_derivatives
# contains all the derivatives of nome but i_derivatives contains only those of
# the i element of func_in_a1, that is, derivatives evaluated at the same point
# as i.  This allows to evaluate the contribution of each i_derivative in the
# correct manner, with the correct delta function.
# To understand how the i_derivatives set works one can trace fdiff and input:
#
#                fdiff(diff(f(x),x) + diff(f(y),y) , f(u))
#
# Finally, two special cases can be evaluated immediately:
# - when no D_derivatives of nome exist at all, or
# - when "nome" appears in the derivand (a1) with only one functionality
#   (evaluated at only one point), since the result will require only one delta
#   function:

   if D_derivatives={} then i_derivatives := {}:
   elif nops(func_in_a1)=1 then i_derivatives := D_derivatives:
   else
      i_derivatives := {}:
      for j in D_derivatives
      do:
          if op(j)=op(i) then
          i_derivatives := {op(i_derivatives), j}:
          D_derivatives := D_derivatives minus {j}:
          fi:
      od:
   fi:

# Differentiation of a1 with respect to each element of i_derivatives, not
# taking into account the integrals, using pdiff.  First, the contribution
# to the result due to the derivatives is calculated. The contribution coming
# from main functions will be evaluated in the last step.
#
# The motivation for an intersection between indets(a1) and i_derivatives (see
# below) is related to the fact that, in many cases, the derivative inside
# i_derivatives occur inside an integral, and its contribution was already
# evaluated (remember that, in this step, all integrals inside a1 appear as
# Y[..](u)).
#
# Finally, the contribution of each derivative to the result is accumulated in
# r_deriv.

   r_deriv := 0:
   if has(a1,nome) and has(a1,{op(i)})  then
      for k in ( indets(a1) intersect i_derivatives )
      do:
              for l in [op(i)]
              do:
              n := odiff(k,l):
                if n > 0 then
                     if 'diff_delta' = diff_delta
                     then diff_delta := pdiff(delta,l$n):
                     else diff_delta := pdiff(diff_delta,l$n):
                     fi:
                fi:
              od:
           if 'diff_delta' = diff_delta then
           ERROR(`Ambiguous derivatives as`,k,`are not allowed`):
           fi:
           r_deriv := r_deriv + pdiff(a1,k) * diff_delta:
           diff_delta := 'diff_delta':
      od:
   fi:

# Finally, the contribution of main functions i (from func_in_a1), not taking
# into account integrals or derivatives,is evaluated and added to the result
# res, which was initialized at the beginning of the i loop and will also
# incorporate the contribution coming from the derivatives

   if has(a1,i) then delta * pdiff(a1,i) + r_deriv: else r_deriv fi:
   res := res + " :
od:

# The final step adds the contribution coming from the integrals to that
# coming from the part not containing integrals

res := subs(frozen_name = nome,res + r_Int):
if has(res,'Y') then subs(Y_int,res) else res fi:
end:
########################################################################
`fdiff/auxdiff` := proc() if has(args[1],_Env_NOME)
                   then useD(diff(args))
                   else 'diff'(args)
                   fi: end:
`fdiff/auxDiff` := proc() if has(args[1],_Env_NOME)
                   then useD(diff(args))
                   else Diff(args)
                   fi: end:
########################################################################
evalDi := proc(a::algebraic)
local i,integrals,res;
options `Copyright 1994 by E. S. Cheb-Terrab`;


# Only works with +..- infty as limits of integration and when Dirac is
# present in the integrands.  A superficial check avoids working useless:

if not (has(a,{'Int','int'}) and has(a,'Dirac') and has(a,'infinity'))
then res := a:
    integrals := indets(a,{'int','Int'}):
    for i in integrals do
        integrals minus {i}:
        if has(",i) then integrals := ": next fi;
        `expand/Int`(op(i)):
        if `evalDi/oInt`(i) > `evalDi/oInt`(")
            then res := subs(i=",res):
            integrals := integrals minus {i}:
        fi
    od;
RETURN(res):
fi:

# Diff functions are expanded (via evalDi/Diff) and those containing Dirac
# are evaluated via diff. res only contains expanded Diff's not containing
# Dirac and only Int's (no more int's):

if has(a,'Diff') then
    proc(f)
        if has(f,'Dirac') then diff(op(map(Value,[args])))
        else `evalDi/Diff`(f,args[2..nargs])
        fi
    end;
(eval @ subs)('Diff' = ",a)
else a
fi;

subs({'int' = '`evalDi/integrate`','Int' = '`evalDi/integrate`'},");
subs(`evalDi/Int`=Int,");
end:
########################################################################
`evalDi/oInt` := proc(A)
local integrals,i,ord;
options remember;
integrals := indets(A,{'int','Int'}):
ord[1] := 0:
for i in integrals do
ord[i] := 0;
    integrals minus {i};
    if has(",i) then integrals := ": next fi;
    ord[i] := ord[i] + 1 + `evalDi/oInt`(op(1,i)):
od;
max(op(map(op,[entries(ord)])));
end:
########################################################################
`evalDi/integrate` := proc(f,dx)
local res,integrand,k,int_var,c0,c1,n;
options `Copyright 1994 by E. S. Cheb-Terrab`;

if not ( has(f,'Dirac')
         and type(dx,`=`)
         and member(op(2,dx),{-infinity .. infinity, infinity .. -infinity}) )
then RETURN(`evalDi/Dirac_out`(f,dx));
fi;

if not assigned(_Env_working) then
_Env_working := 1 ;
res := `expand/Int`(f,dx);
    if not type(res,'Int')
    then RETURN((eval@subs)('Int'=`evalDi/integrate`,res))
    fi;
fi;

# Evaluation of integrals containing Dirac. Begins evaluating the case which
# contains derivatives of Dirac

int_var := op(1,dx);
integrand := f;

for k in indets(f,'DDirac') do

# Only works if the integrand is proportional to the Dirac and if the argument
# of the Dirac is linear in the integration variable.  This may be extended...

    if [traperror(degree(integrand,k),ldegree(integrand,k))]=[1,1]
       and type(op(2,k),linear(int_var))
       then                # Entering here will RETURN with a res(ult)

# In what follows, k = Dirac(n,c1*x+c0)

        n := op(1,k);
        op(2,k):
        c0 := coeff(frontend(expand,["]),int_var,0);
        c1 := coeff(frontend(expand,[""]),int_var,1);
            if c1 = 1 and nops(abs(c0))=1 and type(op(abs(c0)),'name')
                then
                res := (-1)^n*diff(subs(k = 1,int_var = -c0,integrand),
                                                        op(abs(c0))$n)
                else
                (-1)^n*subs('diff'=`useD/subdiff`,
                diff(subs(k=1,int_var=(int_var-c0)/c1,integrand),
                                            int_var $ n))/abs(c1):
                res := usediff(limit(",int_var = 0));
            fi;
        RETURN(res);

# To be extended:
#       elif... other cases

    fi;
od;

# Evaluation of integrals containing Dirac. Now, those containing Dirac
# Main rule: delta(g(x))=Sum(1/abs(D(g)(x0[n]))*delta(x-x0[n]),n=1..N)
#            were x0[n] are the simple roots of g(x)

for k in indets(integrand,'Dirac') do

# Only works if the integrand is proportional to the Dirac and if the argument
# of the Dirac is linear in the integration variable.  This may be extended.

    if [degree(integrand,k),ldegree(integrand,k)] = [1,1]
       and type(op(k),linear(int_var))
        then               # Entering here will RETURN with a res(ult)

# In what follows: k = Dirac(n) = Dirac(c1*x + c0)

        n := op(k):
        c0 := coeff(frontend(expand,[n]),int_var,0);
        c1 := coeff(frontend(expand,[n]),int_var,1);
        subs({'Diff'=`useD/subdiff`,'diff'=`useD/subdiff`},integrand):
        res := 1/abs(c1)*subs(k=1,int_var=-c0/c1,"):
    fi;
    RETURN(res);
od;

# End of evaluation of the integrals containing Dirac. If arrives at this
# point it is because no any integration was realized. Thus, the only thing to
# be done is to put out on Int all Diracs not containing int_var.

`evalDi/Dirac_out`(f,dx);
end:
########################################################################
`evalDi/Dirac_out` := proc(f,dx)
local int_var;
options `Copyright 1994 by E. S. Cheb-Terrab`;

if type(dx,`=`) then int_var := op(1,dx) else int_var := dx fi;
if type(f,{'Dirac','DDirac'})
    then RETURN(f*int(1,dx));
elif type(f,`*`)
    then traperror(select(type,f,{'Dirac','DDirac'}));
    if not "=lasterror
        then map(u -> if not has(args) then u else 1 fi,"*int_var,int_var);
        RETURN("*`evalDi/Int`(f/",dx));
    fi;
elif type(f,`+`)
    then map(`evalDi/Dirac_out`,f,dx);
    if not " = map(`evalDi/Int`,f,dx) then RETURN("); fi
fi;
`evalDi/Int`(f,dx);
end:
########################################################################
`diff/evalDi/Int` := () -> subs('Int'=`evalDi/Int`,`diff/Int`(args)):
########################################################################
`evalDi/Diff`:=  # works as what would be `expand/Diff`.
                 # It also allows for the elimination of terms such as
                 # Diff(0,x)
proc(f,x)
local c,c1,c2,y,i;
options `Copyright 1993 by E. S. Cheb-Terrab`,remember;

    if nargs < 2 then ERROR(`Invalid number of arguments`,args):
    elif nargs > 2 then
  RETURN(`evalDi/Diff`(`evalDi/Diff`(args[1],args[2..(nargs-1)]),args[nargs])):
    fi:
    if not has(args[1],x) then RETURN(0): fi:
    y := frontend(expand,[args[1]]);
    if type(y,`+`) then c := map(procname,y,args[2])
    elif type(factor(y),`*`) then
          c1:=factor(y): c2 := 1:
          for i to nops(c1) do:
          if not has(op(i,factor(y)),x) then
          c1:= c1/op(i,factor(y)):
          c2:= c2*op(i,factor(y)):
          fi:
          od:
    c := c2*Diff(c1,args[2]):
    else RETURN(Diff(args)):
    fi:
c:
end:
########################################################################
odiff := proc(a::algebraic)
         local u,v,aux,name0,name1;
         options `Copyright 1993 by E. S. Cheb-Terrab`,remember;

if not member(nargs,{1,2})
   then ERROR(`Invalid number of arguments`):
elif type(a,{'diff','Diff'})
   then u := useD(args[1]);
elif type(a,'De')
   then u := a;
else aux := indets(useD(a),'De'):
   if aux = {} then RETURN(0):
   elif nargs=1 then
   RETURN(max(op(map(odiff,aux)))):
   else
        proc(u,x) if has([op(u)],x) then odiff(u,x) else 0 fi end:
        RETURN(max(op(map(",aux,args[2])))):
   fi:
fi:

# Prepare name1 and name0 to avoid repetition of op statements

name1 := op(0,u):
if type(name1,{'indexed','function'}) then name0 := op(0,name1):
    if not type(name0,{'name',`@@`(anything,anything)}) then
    ERROR(`Cannot handle expressions as`,a):
    fi:
fi:

# Here begins the job

if has(u,`$`) then
ERROR(`Not implemented for objects containing $ as`,u)

elif nargs = 2 and not has([op(u)],args[2]) then RETURN(0):

# Case D(f),D(^n)(f),

elif name1 ='D' then RETURN(1):
elif name0 =`@@` then RETURN(op(2,name1)):

# Case D(f)(x) or (indexed) D[f](x)

elif name0='D' then
  if type(name1,'indexed') then
     RETURN(nops(name1)):
  elif nops(u)=1 then RETURN(1):
  else ERROR(`Multivariate use of D`):
  fi:

# Case D(^n)(f)(x)

elif op(0,name0)=`@@` then
  if nops(u)=1 then RETURN(op(2,name0)):
  else ERROR(`Multivariate use of D`):
  fi:

# Case (indexed) D[a](f)(x,y,z)

elif not op(map(type,{op(name0)},'posint')) then
    if nargs=1 then RETURN(nops([op(name0)]))
    else ERROR(`Unable to determinate`):
    fi:

elif max(op(name0)) <= nops(u) then
        if nargs = 1 then
        RETURN(nops(name0)):
        else member(args[2],[op(u)],v);
        RETURN(nops(name0) - nops(subs(v=NULL,[op(name0)]))):
        fi:
else nops(u):
ERROR(`Index out of range: function takes only `.".` arguments`)
fi:
end:
########################################################################
`expand/Int` :=
proc(f,dx)
local c,y,x;
options remember,`Date: 02/10/93`;
    if has(f,{'Int','int'}) then
        (eval@subs)({'int'=`expand/int`,'Int'=`expand/Int`},f)
        else f
    fi:
    frontend(expand,["]):
    if hastype(",1/'algebraic') then
         y := frontend(expand,[factor(")])
    else y := ":
    fi;
    x := op(1,dx);
    if type(y,`+`) then map(procname,y,args[2 .. nargs])
    elif type(y,`*`) then
        c := map(proc(g,x) if not has(g,x) then g else 1 fi end,y,x);
        if not has(y/c,x)
            then c*int(y/c,args[2 .. nargs])
            else c*Int(y/c,args[2 .. nargs])
        fi;

#    elif not has(y,x) then y*Int(1,args[2 .. nargs])
    elif not has(y,x) then y*int(1,args[2 .. nargs])
    else Int(args)
    fi
end:
########################################################################
Intc := proc(a,b)
Int(args[1],op(1,args[2])=-infinity..infinity):
end:
########################################################################
Int2c := proc(a,b,c)
Int(Int(args[1],op(1,args[2])=-infinity..infinity),
                op(1,args[3])=-infinity..infinity):
end:
########################################################################
Int3c := proc()
Int(Int(Int(args[1],op(1,args[2])=-infinity..infinity),
                op(1,args[3])=-infinity..infinity),
                op(1,args[4])=-infinity..infinity):
end:
########################################################################
Int4c := proc()
Int(Int(Int(Int(args[1],op(1,args[2])=-infinity..infinity),
                op(1,args[3])=-infinity..infinity),
                op(1,args[4])=-infinity..infinity),
                op(1,args[5])=-infinity..infinity):
end:
########################################################################
parameters := proc()
local i;
global `parameters/PARAMETERS`;
options `Copyright 1993 by E. S. Cheb-Terrab`;
    if `parameters/PARAMETERS` = '`parameters/PARAMETERS`' then
        `parameters/PARAMETERS` := {}
    fi;
    if 1 <= nargs then
        for i to nargs do
           `parameters/PARAMETERS` := {args[i],op(`parameters/PARAMETERS`)};
            assign(args[i],
               proc() options `p a r a m e t e r`; RETURN('procname') end)
        od
    fi;
    for i in `parameters/PARAMETERS` do
        if not has(eval(i),`p a r a m e t e r`) then
            `parameters/PARAMETERS` :=`parameters/PARAMETERS` minus {eval(i)}
        fi
    od;
    `parameters/PARAMETERS`
end:
########################################################################
seldiff := proc(u::{algebraic,`=`},v::{posint})
local a,i,res,w;
options `Copyright 1993 by E. S. Cheb-Terrab`;
    if type(u,`=`) then RETURN(map(seldiff,args)): fi:
    a := frontend(expand,[Value(u)]);
    res := a;
    if nargs = 3 then w := args[3] else w := NULL fi;
    if type(res,'function') then if odiff(res,w) <> v then RETURN(0) fi
    elif type(res,'algebraic') then
        for i to nops(a) do
            if odiff(op(i,a),w) <> v then res := res-op(i,a) fi
        od
    else ERROR(`Not implemented`)
    fi;
    res
end:
########################################################################
useD := proc(a::{list,set,`=`,algebraic})
options `Copyright 1993 by E. S. Cheb-Terrab`;
    if type(a,{`=`,'set','list'}) then RETURN(map(useD,a)) fi;
    subs('Diff' = 'diff',a);
    subs('diff' = `useD/subdiff`,");
    "
end:
########################################################################
`useD/subdiff` := proc(u,v) local n;
options `Copyright 1993 by E. S. Cheb-Terrab`,remember;
if nargs > 2 then
ERROR(`The diff command cannot handle an abstract derivation variable \
built with the ``$`` operator and another derivation variable \
at the same time as in`,'diff'(args));
fi:

# Case diff(f(x),x)=D(f)(x), diff(f(x),y$n)=0, diff(f(x),x$n)=`@@`(D,n)(f)(x)

if nops(u)=1 then
  if type(v,'`$`'(anything,anything)) then
     if has(op(u),op(1,v)) then `@@`('D',op(2,v))(op(0,u))(op(u)):
     else 0
     fi:
  else D(op(0,u))(op(u)):
  fi:
else

# Case diff(f(...),x$n)=D[?$n](f)(...), diff(f(...),y$n)=0,
#      diff(f(...),x)=D[...](f)(...),

  if type(v,'`$`'(anything,anything)) then
     if has([op(u)],op(1,v)) then
     member(op(1,v),[op(u)],'n'):
     D[n$op(2,v)](op(0,u))(op(u)):
     else 0
     fi:
  elif member(v,[op(u)],'n') then D[n](op(0,u))(op(u)):
  else ERROR(`Unable to handle, try convert(args,D)`):
  fi:
fi;
end:
########################################################################
usediff := proc(a::{algebraic,list,set,`=`})
options `Copyright 1993 by E. S. Cheb-Terrab`;
if type(a,{'list','set',`=`}) then RETURN(map(usediff,a))
elif not has(a,'D')
	then a:
    else map(u -> u = `usediff/subD`(u),indets(a,'De')):
    subs(",a):
fi:
end:
########################################################################
`usediff/subD` := proc(u)
options `Copyright 1993 by E. S. Cheb-Terrab`,remember;

# Case D(f), D[n](f), D...(..)(..,f(x),..) RETURN(u)
# From this point to '#$' the " will refer to op(0,u).

op(0,u):
if "='D' or (type(",'indexed') and op(0,")='D')
         or not map(type,{op(u)},'name')={'true'} then RETURN(u)

# Case D(f)(x), D(...)(f)(x)

elif op(0,")='D' then
   if nops(u) = 1 then
   RETURN(diff(op(")(op(u)),op(u))):
   else ERROR(`Unable to handle non-sensical expression`,u):
   fi

# Case D(^n)(f),

elif op(0,op(0,"))=`@@` then
RETURN(diff(op(")(op(u)),op(u)$op(2,op(0,")))):

# Case D[1](f)(x) or indexed D[1,2...](f)(x,y,...)

elif op(0,op(0,"))='D' then

# If contains $, then, if only contains a$b, then,
# if the indicated number (a) is less or equal to the number of variables,
# then, the transformation is realized; else RETURN(u) or reports an ERROR

   if has([op(op(0,"))],`$`) then
        if nops(op(0,"))=1 and type(op(1,op(op(0,"))),'posint') then
            if nops(u) >= op(1,op(op(0,"))) then
            RETURN(diff(op(")(op(u)),
                       op(op(1,op(op(0,"))),[op(u)])$
                       op(2,op(op(0,")))) ):
            else ERROR(`Cannot derivate the function`,
                        op(")(op(u)),
                       `with respect to the argument number`,
                        op(1,op(op(0,"))),`as in`,u):
            fi:
        else RETURN(u)
        fi:
   fi:


# Case high order derivative. Create seq of differentiation variables

zip((a,b) -> traperror(op(a,b)),[op(op(0,"))],[[op(u)]$nops(op(0,"))]);

#$

# Analize the result. If any problem appear, as for example in the case of
# D[...] such that one of the numbers inside [...] is greated than the number
# of variables, then, a 'lasterror' will appear inside the last result and an
# ERROR will be reported. Else the conversion is realized.

   if has(",lasterror) then
   ERROR(`Unable to handle non-sensical expression`,u):
   else RETURN(diff(op("")(op(u)),op("))):            # Here, "" means op(0,u)
   fi:
fi:
end:
########################################################################
# Necessary for the loading of `value/define` !!, called by Value.

readlib(value):

Value := proc(f)
local g,nm;
options `Copyright 1993 by E. S. Cheb-Terrab`;
if nargs <> 1 then ERROR(`incorrect number of arguments`) fi;
g := x -> x;
if type(f,'function') then
nm := op(0,f):
    if type(nm,'name') then

#$ Allows for the evaluation with Value rules before looking at value/... rules
# and for Value evaluation of indexed procedures:

        if type(`Value/`.nm,'procedure') then g := `Value/`.nm;
        elif type(nm,'indexed')
            and has(eval(cat(`Value/`,op(0,nm))),`i n d e x e d`)
            then g := cat(`Value/`,op(0,nm)):
        else g := traperror(`value/define`(`value/`.nm));
        fi:

#$

        if g = lasterror then

#$ Allows for a Value evaluation from inside to outside

            if hastype([op(f)],'function') then
                map(Value,[op(f)]);
                if not [op(f)] = " then RETURN(op(0,f)(op("))) fi
            fi;

#$

            g := x -> x
        fi;
        RETURN(eval(g(f)))
    elif hastype(op(0,f),'function') then
        g := procname([op(f)]); RETURN(procname(op(0,f))(op(g)))
    fi
elif hastype(f,'function') then
    if type(f,'indexed') then RETURN(Value(op(0,f))[Value(op(f))])
    else RETURN(map('procname',f))
    fi:
#    elif hastype(f,'function') then RETURN(OK)

#$ Allows for a Value evaluation of a parameter.

elif has(eval(f),`p a r a m e t e r`) then RETURN(f)

#$

fi;
RETURN(eval(g(f)))
end:

########################################################################
# Introduce Value rules from inside to outside (exception for Sum, normal
#  and Product). Introduce a Value/Limit behavior such to Value evaluate
#  Limits of indexed functions.

`Value/Sum` := proc(x) sum(op(x)); Value(") end:
`Value/Normal` := proc(x) evala(x); Value(") end:
`Value/Product` := proc(x) product(op(x)); Value(") end:

`Value/Diff` := proc(x) Value([op(x)]); diff(op(")) end:
`Value/Int` := proc(x) Value([op(x)]); int(op(")) end:
`Value/Pdiff` := proc(x) Value([op(x)]); pdiff(op(")) end:

`Value/Limit` := proc(x)
 local f,var;
options `Copyright 1993 by E. S. Cheb-Terrab`;
f := Value(op(1,x));
var := Value(op(2,x));
indets(f,function);
    proc(u) if type(op(0,u),'indexed') then op(0,u) fi end;
map(","") union indets(f,'indexed');
    (u,v) -> u = op(0,u)[op(map(limit,[op(u)],v))];
map(","",var);
f := subs(",f);
limit(f,var)
end:
########################################################################
# Necessary for well working of usepdiff and D.

readlib('D'):
`D/procedure` := proc(f)
local d,n,i,Index,check;
options `16/10/93`;
if not type(f,procedure) then ERROR(`internal error`) fi;
###$
###$ Change behaviour for the case of automatic proc() creation:
###$ f := proc() options remember; 'procname'(args) end:
###$ occurring  when assigning values to f(anything) while not
###$ defining any explicit proc() for f.
###$
check() := check();
if 1 < nargs and
	map(u -> if not has(u,`&hashtab`) then u fi,readlib('procbody')(f))
	= map(u -> if not has(u,`&hashtab`) then u fi,procbody(check))
	and type(op(4,eval(f)),'table') then
    Index := args[2];
    if not type(Index,list(integer)) then RETURN(FAIL) fi;
    n := max(op(map(z -> nops([op(1,z)]),op(2,op(4,eval(f))))));
    if n < max(op(Index)) then
        ERROR(`Function `.f.` can take no more than `.n.` arguments`)
    fi;
    RETURN(FAIL)
fi;
###$ End of change. These lines are the only added lines.

n := nops([op(1,eval(f))]);
if nargs = 1 then
    if 1 < n then ERROR(`function must be unary`)
    elif n = 1 then RETURN(`D/procedure`(f,[1]))
    else RETURN(FAIL)
    fi
fi;
Index := args[2];
if not type(Index,list(integer)) then RETURN(FAIL) fi;
if n < max(op(Index)) then
    ERROR(`index out of range: function takes only `.n.` arguments`)
fi;
d := f;
for i in convert(Index,multiset) do
    d := traperror(readlib(`PD/PD`)(eval(d,1),op(i)));
    if d = FAIL then RETURN(FAIL) fi;
    if d = lasterror then ERROR(d) fi
od;
eval(d,1)
end:
#####################################################################
#                The type/... subroutines
#####################################################################
`type/Dirac` := proc(a)
options `Copyright 1993 by E. S. Cheb-Terrab`,remember;
disassemble(addressof(a)):
if "[1]=FUNCTION and "[2] = addressof('Dirac') and nops(a)=1
then 'true'
else 'false'
fi:
end:
#####################################################################
`type/DDirac` := proc(a)
options `Copyright 1993 by E. S. Cheb-Terrab`,remember;
disassemble(addressof(a)):
if "[1]=FUNCTION and "[2] = addressof('Dirac') and nops(a)=2
then 'true'
else 'false'
fi:
end:
#####################################################################
`type/Definite_int` := proc(f)
options `Copyright 1993 by E. S. Cheb-Terrab`;
if type(f,{'int','Int'}) and type(op(2,f),`=`)
then 'true' else 'false'
fi
end:
#####################################################################
`type/Indefinite_int` := proc(f)
options `Copyright 1993 by E. S. Cheb-Terrab`;
if type(f,{'int','Int'}) and type(op(2,f),'name')
then 'true' else 'false'
fi
end:
#####################################################################
`type/De` := proc(a)
options `Copyright 1993 by E. S. Cheb-Terrab`,remember;
if not has(a,'D') then RETURN('false'): fi:
disassemble(addressof(a)):
do:
if "[1]=FUNCTION or "[1]=TABLEREF then
   if "[2] = addressof('D') then RETURN('true')
   elif "[2] = addressof(`@@`) then
       if disassemble("[3])[2] = addressof('D') then RETURN('true')
       else RETURN('false')
       fi:
   else disassemble("[2]): next
   fi:
else RETURN('false'):
fi:
od:
end:
#####################################################################
`type/Int` := proc(a)
options `Copyright 1993 by E. S. Cheb-Terrab`,remember;
disassemble(addressof(a)):
if "[1]=FUNCTION and "[2] = addressof('Int') then 'true'
else 'false'
fi:
end:
#####################################################################
`type/int` := proc(a)
options `Copyright 1993 by E. S. Cheb-Terrab`,remember;
disassemble(addressof(a)):
if "[1]=FUNCTION and "[2] = addressof('int') then 'true'
else 'false'
fi:
end:
#####################################################################
`type/simpleint` := proc(a)
options `Copyright 1993 by E. S. Cheb-Terrab`,remember;
disassemble(addressof(a)):
if "[1]=FUNCTION and ( "[2] = addressof('int') or "[2] = addressof('Int') )
   and not disassemble(disassemble("[3])[2])[2] = addressof('int')
   and not disassemble(disassemble("[3])[2])[2] = addressof('Int')
then 'true'
else 'false'
fi:
end:
#####################################################################
`type/csimpleint` := proc(a)
options `Copyright 1993 by E. S. Cheb-Terrab`,remember;
disassemble(addressof(a)):
if "[1]=FUNCTION and ( "[2] = addressof('int') or "[2] = addressof('Int') )
   and not has(pointto(disassemble("[3])[2]),{'int','Int'})
then 'true'
else 'false'
fi:
end:
#####################################################################
`type/diff` := proc(a)
options `Copyright 1993 by E. S. Cheb-Terrab`,remember;
disassemble(addressof(a)):
if "[1]=FUNCTION and "[2] = addressof('diff') then 'true'
else 'false'
fi:
end:
#####################################################################
`type/Diff` := proc(a)
options `Copyright 1993 by E. S. Cheb-Terrab`,remember;
disassemble(addressof(a)):
if "[1]=FUNCTION and "[2] = addressof('Diff') then 'true'
else 'false'
fi:
end:
#####################################################################
`type/Function` :=
proc(a)
options `Copyright 1993 by E. S. Cheb-Terrab`,remember;
    disassemble(addressof(a));
    if "[1] = FUNCTION then
        if not ( member("[2],{addressof('Int'),addressof('int'),
            addressof('diff'),addressof('Diff'),addressof('limit'),
            addressof('Limit'),addressof('sum'),addressof('Sum')}) or
            ( has(a,'D') and type(a,'De') ) ) then
            'true'
        else 'false'
        fi
    else 'false'
    fi
end:
#####################################################################
#                          THE LIBRARY
#####################################################################
#
# Here begins the building of the library.
# It will contain the following files:
#
# - partials/routines.m
# - partials/help.m
# - partials/Value.m
# - partials/pdiff.m
# - partials/usepdiff.m
# - partials/fdiff.m
# - partials/Intc.m
# - partials/Int2c.m
# - partials/Int3c.m
# - partials/Int4c.m
# - partials/evalDi.m
# - partials/odiff.m
# - partials/parameters.m
# - partials/seldiff.m
# - partials/usediff.m
# - partials/useD.m
# - partials/init.m
# - partials/D/procedure.m
#
# that is, 18 files.  They are all created through the instruction:
#
# > MAKELIB();
#
# which is a procedure that comes inside the file partials.  In turn, the
# file partials must be in the working directory, available for reading
# through the instruction :
#
# > read partials:
#
# Note that the MAKELIB command will discuss with the User about the library
# in which the .m files should be saved. As the first option, MAKELIB will
# proppose the library situated in the directory indicated as the first
# operand of the global variable libname, where the bugs of the standard
# library are usually fixed.
#
# If this library does not exist at all, or the global variable libname
# contains only one directory (with the main maple.lib library) one can
# proceed as follows.
#
#- First, to build the library (if it does not exist yet), at the DOS prompt,
#  type:
#
# c:\> march -c c:/maplev/mydirectorylib 100
#
# The command above will create an index file named "maple.ind" and an empty
# "maple.lib"  file at the directory c:\maplev\mydirectorylib.
#
#- Second, start a Maple session and, at the Maple prompt, enter the
#  instruction
#
# > libname := `c:/maplev/mydirectorylib`,libname;
#
#- Third, still inside the Maple session, enter the instructions
#
# > read partials: MAKELIB():
#
# Alternatively, if the Second step is skipped and only one library is found
# (probably the standard one) the MAKELIB() instruction will save the package
# in this library (maple.ind and maple.lib files which come with the DOS
# version)
#
# After the .m files are added to the library, the package becomes available
# using the with command in the standard way:
#
# > with(partials):
#
# for the loading of all the commands, or
#
# > with(partials,<command>):
#
# for the loading of only one command.  Note that, from now on, to use the
# package, the libname variable must contain the directory of the library
# containing the partials package. This can be achieved by introducing the
# instruction
#
# libname := `c:/maplev/mydirectorylib`,libname;
#
# in the maple.ini file of the DOS version, or by typing this instruction
# (after starting a Maple session) before loading the package.
#
##################################################
#                   The MAKELIB procedure.
##################################################
`MAKELIB/reassign` := proc(L_commands::list)
          local L1,L2;

# 1) Assign `partials/pdiff` := eval(pdiff)
  map(u -> assign(cat(`partials/`,u) = eval(u)),L_commands);

# 2) Assign partials[pdiff] := 'readlib('`partials/pdiff`')'
  L1 := map(u -> subs(u = cat(`partials/`,u),'readlib('u')'),L_commands);
  L2 := map(u -> partials[''u''],L_commands);
  zip('assign',L2,L1);

# 3) Assign pdiff := 'readlib('`partials/pdiff`')'
  zip('assign',L_commands,L1);
end:
##################################
MAKELIB := proc()

local K,i,directory;
global
`partials/D/procedure`,`partials/help`,`partials/init`,`partials/routines`;

options `Copyright 1993 by E. S. Cheb-Terrab`;

K := 0:     # K = Counter for User errors below.

# Case only one library exists

if nops([libname])=1 then
do
if K=0 then
print(`Warning !. Only one library exists.`):
print(_____________________________________________________):
print(
`You may save the partials package in this library or create a new one.`):
print(cat(
`(For creating a library see the instructions at the end of the `,
`"partials" file...)`)):
fi:
print(_____________________________________________________):
print(cat(
`Would you like to save the partials package in the only existing `,
`library ?  (Y/N)`));
readline(terminal):
if member(",{y,Y,n,N}) then break
elif K=0 then
print(_____________________________________________________):
print(cat(`Wrong answer.  Expected:  y, Y, n or N.`)):
print(cat(`Received:  `,",` . Please try again.`)):
K:=1:
else ERROR(`Aborted MAKELIB procedure: Two consecutive wrong answers`)
fi:
od;

# Case more than one library exist

elif nops([libname]) > 1 then
K := 0:
do
if K=0 then
print(cat(`Your system contains `,nops([libname]),` MAPLE libraries at:`)):
print(libname):
print(_____________________________________________________):
print(cat(
`By default, the partials package will be saved in the first library, `,
`situated in the `,op(1,[libname]),` directory.`)):
print(cat(
`You may save the package in this library or in another one, `,
`by indicating the corresponding "libname" number.`)):
fi:
print(_____________________________________________________):
print(`Would you like to save the partials package in the first library ?`):
print(cat(`(Your answer must be one of:   Y, N,  or a number between 1 and `,
nops([libname]),`)`)):
readline(terminal):
if member(",{y,Y,n,N,op(map(convert,[seq(i,i=1..nops([libname]))],'string'))})
then break
elif K=0 then
print(_____________________________________________________):
print(cat(`Wrong answer.  Expected:  y, Y, n, N or a number between 1 and `,
nops([libname]))):
print(cat(`Received:  `,",` . Please try again.`)):
K:=1:
else ERROR(`Aborted MAKELIB procedure: Two consecutive wrong answers`)
fi:
od;
else
ERROR(`Unexpected error.  No library exists at all`):
fi:

###################################################
# Analizing the answers

parse("):
if type(",'posint') then
directory := op(",[libname]):
elif member(",{y,Y}) then directory := op(1,[libname]):
elif member(",{n,N}) then RETURN(`MAKELIB procedure aborted by the User`):
else ERROR(`Unexpected error happens`):
fi:

###################################################
# ERROR filter: To force avoiding any specific library

# if directory = libname[2] then ERROR(`!!!!`): fi:

###################################################
#    End of interactive requests
#    Beginning of the builiding of the library
###################################################
#    Reassign names: 14 commands (`MAKELIB/reassign` defined at line 2688)

[Int2c,Int3c,Int4c,Intc,Value,evalDi,fdiff,odiff,parameters,pdiff,seldiff,
useD,usediff,usepdiff]:
#`MAKELIB/reassign`("):

###################################################
#  All in one

`partials/routines` := 1:

save
`expand/Int`,

`value/define`,
Value,`Value/Sum`,`Value/Normal`,`Value/Product`,`Value/Diff`,
`Value/Int`,`Value/Pdiff`,`Value/Limit`,Has,`Has/definite_int`,

`type/De`,`type/Diff`,`type/diff`,`type/Function`,`type/Int`,
`type/int`, `type/simpleint`,`type/csimpleint`,`type/Definite_int`,
`type/Indefinite_int`,`type/Dirac`,`type/DDirac`,

`D/procedure`,`diff/Pdiff`,`diff/pdiff`,
`partials/routines`,

cat(directory,`/partials/routines.m`):

###################################################
# All Help in one
#
#`partials/help` := 1:
#
#save
#`help/text/partials`,`help/text/pdiff`,`help/text/usepdiff`,
#`help/text/fdiff`,`help/text/evalDi`,`help/text/parameters`,
#`help/text/odiff`,`help/text/seldiff`,`help/text/usediff`,
#`help/text/Intc`,`help/text/usediff`,`help/text/useD`,
#`help/text/Value`,`partials/help`,
#
#cat(directory,`/partials/help.m`):

###################################################
#             Saving procedures
###################################################

`partials/D/procedure` := eval(`D/procedure`):

save
`partials/D/procedure`,

cat(directory,`/partials/D/procedure.m`):
###################################################

save
`value/define`,`Value/Sum`,`Value/Normal`,`Value/Product`,
`Value/Diff`,`Value/Int`,`Value/Pdiff`,`Value/Limit`,`partials/Value`,

cat(directory,`/partials/Value.m`):
###################################################

save
`diff/pdiff/int`,`diff/pdiff/Int`,`diff/pdiff`,
`partials/pdiff`,

cat(directory,`/partials/pdiff.m`):
###################################################

save
pdiff,
`partials/usepdiff`,

cat(directory,`/partials/usepdiff.m`):
###################################################

save
`fdiff/auxdiff`,`fdiff/auxDiff`,
pdiff,usepdiff,evalDi,odiff,parameters,seldiff,Intc,Int2c,Int3c,Int4c,
`partials/fdiff`,

cat(directory,`/partials/fdiff.m`):
###################################################

save
Int2c,Int3c,Int4c,`partials/Intc`,

cat(directory,`/partials/Intc.m`):
###################################################

save
Intc,Int3c,Int4c,`partials/Int2c`,

cat(directory,`/partials/Int2c.m`):
###################################################

save
Int2c,Intc,Int4c,`partials/Int3c`,

cat(directory,`/partials/Int3c.m`):
###################################################

save
Int2c,Int3c,Intc,`partials/Int4c`,

cat(directory,`/partials/Int4c.m`):
###################################################

save
Intc,Int2c,Int3c,Int4c,
`evalDi/Diff`,`diff/evalDi/Int`,`evalDi/integrate`,`evalDi/Dirac_out`,
`evalDi/oInt`,
`partials/evalDi`,

cat(directory,`/partials/evalDi.m`):
###################################################

save
`partials/odiff`,

cat(directory,`/partials/odiff.m`):
###################################################

save
`partials/parameters`,

cat(directory,`/partials/parameters.m`):
###################################################

save
`partials/seldiff`,

cat(directory,`/partials/seldiff.m`):
###################################################

save
`usediff/subD`,`partials/usediff`,


cat(directory,`/partials/usediff.m`):
###################################################

save
`useD/subdiff`,`partials/useD`,

cat(directory,`/partials/useD.m`):
###################################################

save partials, cat(directory,`/partials.m`):

###################################################
#         The initialization file
###################################################

`partials/init` := proc ()

global
`D/procedure`,Dirac,`help/text/Int2c`,`help/text/Int3c`,`help/text/Int4c`,
`help/text/useD`,`partials/initialized`,useD,usediff;

options `Copyright 1993 by E. S. Cheb-Terrab`;

readlib('D'):
readlib('`partials/D/procedure`'):
`D/procedure` := eval(`partials/D/procedure`):

# To be done the first time:

if not `partials/initialized`='true' then

# Standard routines to be loaded before:

    readlib('forget')('expand'):
    readlib(`expand/int`):

# Loading of the main routines

    readlib('`partials/routines`'):

# Loading of the help routines

    readlib('`partials/help`'):
    `help/text/Int2c` := '`help/text/Intc`':
    `help/text/Int3c` := '`help/text/Intc`':
    `help/text/Int4c` := '`help/text/Intc`':
    `help/text/useD` := '`help/text/usediff`':

# Most common routines called by almost all the commands of the package:

    usediff := readlib('`partials/usediff`'):
    useD := readlib('`partials/useD`'):
    `partials/initialized` := 'true';
fi:

######  End of the partials/init procedure:

end:

#save  `partials/init`,cat(directory,`/partials/init.m`):


######  End of the MAKELIB procedure:

print(`Succesful saving of the partials package in the library found at:`):
print(directory):
print(_____________________________________________________):
print(cat(
`You can now load the package or any of its commands through the "with" `,
`command.`)):
end:
###################################################

#partials:='partials':
#for XX in 
#[Int2c,Int3c,Int4c,Intc,Value,evalDi,fdiff,odiff,parameters,pdiff,seldiff,
#useD,usediff,usepdiff] do
#  partials[XX]:=eval(`pdiff/`.XX) ;
#  assign(XX, eval(XX,1));
#od:
#XX:='XX':
#
##save `partials.m`;
##quit;

