# FILE anton0.mpl
# including all the Maple in anton0.tex

interface(echo=3);
printlevel:=2;

vvec:=array([v1,v2]);
# Access to the {\tt linalg} package requires
with(linalg):

vec:= array( [x,y] );

with(linalg,vector):                                vector( [x,y] );

A:= array( 1..2,1..2,[[a11,a12], [a21,a22] ]);

mat:=array([eval(vec),eval(vec)]):            # NOT a matrix
# creates a structure where one addresses individual entries through, 
# for example, {\tt mat[1][2]}. 
# With {\tt eval} replaced by {\tt convert/list} we would get a matrix
# (see help on {\tt convert} for the syntax). 

#The commands for the rest of this section will be treated as a continuous Maple
#session. In particular, the next command indicates that most of the functions
#are in the {\tt linalg} package.

with(linalg):
A:= matrix( 2,2,[[a11,a12], [a21,a22] ]);
# Shorter, but still valid Maple, are the following:
A:= matrix([ [a11,a12], [a21,a22] ]):
A:= matrix( 2,2,[a11,a12, a21,a22] ):

# Trying to display the matrix $A$ as you would a scalar
# merely results in the letter {\tt A} being shown.
A;
# The matrix entries can, however, be displayed by using one of the following.
       print(A);                 op(A);                evalm(A);

# Maple can interchange the rows of a matrix.
B:= swaprow( A,1,2 );

evalm( A+A ):
C := ";

C2:= evalm( 2*A );

equal( C,C2 );

evalm( ca*A+cb*B );

evalm( A &* A );

inverse(A);

evalm( A &* " );

Id:= diag(1,1);  # The symbol I cannot be used as it is reserved for sqrt(-1)
# This can be generalised for any  n by n  matrix (Here n is 2):
n:=2:                   diag( 1$n ):            equal( ",Id);

array(1..n,1..n,identity):        # This can be done outside linalg
equal( ",Id);

band( [1],n ):                            equal( ",Id);

C:= evalm( A+B );

inverse(C);
# Error, (in inverse) singular matrix
# This error is because the two rows of  C  are the same.

Atr:= transpose(A);

n:=3:               b:= [-1,2,-1]:               A.n:= band([-1,2,-1],n);

toeplitz([2,-1,0]);

h.n:=hilbert(n);

vandermonde([11,12,13]);


# One can set up general matrices in the form given above:
with(linalg):
f:= proc(i,j)            a.i.j            end:
A:= matrix(2,3,f); 

col(A,1);

submatrix( A,1..2,[1,3] );

# Verify, by running the Maple below
# or otherwise, that the matrix $I$ is given by
# $$I_M={1\over 24} \pmatrix{2a^3b&a^2b^2\cr
#                                   a^2b^2&2ab^3\cr}.$$

with(linalg,matrix):
a:='a': b:='b':
i:='i'; j:='j'; func:=x[i]*x[j];
imij:=proc(i1,j1)
 int(int(subs(i=i1,j=j1,func),x[1]=0..a*(1-x[2]/b)),x[2]=0..b);
 end;
imij(1,2); # returned ((a*b)^2)/24 which checks
IM:=matrix(2,2,imij); # returns the matrix as required.


with(linalg):
A:= band( [-x,2*x+x^2,-x],3 );

B:= subs( x=a+y,op(A) ):
Bs:= map( simplify,B );

Be:= map( expand,B );

# The entries in Be are, in this case, the same as in Bs.
#
subs( y=1/10,a=3/10,op(B) ):
Bf:= map( evalf," );

with(linalg):
# Maple can deal with matrices with general entries.  Set one up as before.
f:= proc(i,j)            a.i.j            end:
A:= matrix(2,2,f); 
type(A,matrix);

t:= trace(A);                                               d:= det(A);

# The following yields a formula which is true for any  2 by 2  matrix
map( simplify, evalm( A^2 - t*A + d) );

print(` end of test of anton0`);
printlevel:=1;
interface(echo=1);
