#
# Produce all reduced expressions for an element w of the Coxeter group W.
#
#  redex(w,R);  (R = root system for W)
#  redex(w,S);  (S = list of base vectors for W)
#
# In both cases, w=[i_1,i_2,...,i_l] should be a list of integers,
# representing a product of simple reflections (not necessarily reduced).
# The output is in lexicographic order.
#
redex:=proc(w,R) local S,v,v0,i;
  if type(R,'list') then S:=R else S:=coxeter['base'](R,0) fi;
  v0:=coxeter['interior_pt'](S); v:=coxeter['reflect'](seq(S[i],i=w),v0);
  `redex/vec`(v,S);
end;
#
`redex/vec`:=proc(v,S) local res,i,new,w;
  res:=[];
  for i to nops(S) do;
    if iprod(S[i],v)<0 then 
      new:=`redex/vec`(reflect(S[i],v),S);
      res:=[op(res),seq([i,op(w)],w=new)]
    fi;
  od;
  if nops(res)=0 then [[]] else res fi;
end;
#
