#% FILE antonLT.mpl

interface(echo=2);
interface(plotdevice=postscript,plotoutput=LTplotfile1);
with(linalg):
# 
surface:= [x*sin(x)*cos(y), x*cos(x)*cos(y), x*sin(y) ]:
domain:= x=0..Pi, y=0..Pi:
plot3d(surface,domain);

interface(plotoutput=LTplotfile2);
Q:= matrix([ [cos(Pi/4),sin(Pi/4),0], [-sin(Pi/4),cos(Pi/4),0], [0,0,1] ]):
rotated:= convert( evalm(Q&*surface), list):   # To make it possible to plot
plot3d(rotated,domain);

interface(plotoutput=LTplotfile3);
Q:= matrix([ [-1,0,0], [0,-1,0], [0,0,1] ]):  # Rotation of Pi in the xy-plane
rotated:= convert( evalm(Q&*surface), list):
plot3d(rotated,domain);

interface(plotoutput=LTplotfile4);
Q1:= matrix([ [1,0,0], [0,cos(Pi/3),sin(Pi/3)], [0,-sin(Pi/3),cos(Pi/3)] ]):
Q2:= matrix([ [cos(Pi/3),0,sin(Pi/3)], [0,1,0], [-sin(Pi/3),0,cos(Pi/3)] ]):
rotated:= convert(evalm(Q1&*Q2&*surface),list): #Rotations in xz and yz-planes
plot3d(rotated,domain);

interface(plotoutput=LTplotfile5);
Q:= matrix([ [1,0,0], [0,-1,0], [0,0,1] ]):   # Reflection through xz-plane
reflected:= convert( evalm(Q&*surface), list):
plot3d(reflected,domain);


with(linalg):
# Show that the induced function of  A  is a linear transformation where
A:= matrix( [[a11,a12,a13],  
             [a21,a22,a23]] ):
u:= vector( [u1,u2,u3] ):                         v:= vector( [v1,v2,v3] ):
evalm( A&*(u+v) - (A&*u+A&*v) ); 

evalm( A&*(r*u) - r*A&*u ); 

# 
# Consider a linear transformation  T  from  R^3  to  R^2
# MAPLE VERSION DEPENDENT PART
interface(version);
# Up to  Maple Vr2
define( linear(T) );     # This ensures that  T  is a linear transformation
# In Maple Vr3
# define( Linear(T) );
# Write
T([1,0,0]):= vector( [a11,a21] ):         T([0,1,0]):= vector( [a12,a22] ):
T([0,0,1]):= vector( [a13,a23] ):
# Show that the matrix A above is the matrix induced by  T.
evalm( T(Pi*[1,0,0]+E*[0,1,0]+gamma*[0,0,1]) - A&*vector([Pi,E,gamma]) );
# Pi, E and gamma must be used since define/linear only works with constants
#
# AR6 Section 7.1 Example 12 p303; AR7 Section 8.1 Example 11 p387
# Show that differentiation is a linear transformation
diff(f(x),x) + diff(g(x),x) - diff(f(x)+g(x),x);
diff(r*f(x),x) - r*diff(f(x),x);

# Example 1 - AR6 Section 7.6 p352; AR7 Section 8.5 p427
with(linalg):
# Consider the linear transformation  T  from R^2 to R^2 where
T:= proc(v) local x,y: x:=v[1]: y:=v[2]: vector([x+y,-2*x+4*y]) end:
#
# 1st part: Find the matrix of  T  relative to the (standard) basis  B  where
e1:= vector([1,0]):      e2:= vector([0,1]):     B:= augment( e1,e2 ):
#
#    Find the coordinates of  T(e1), T(e2) 
T_BB:= augment( linsolve(B,T(e1)), linsolve(B,T(e2)) );

# 2nd part:     Find the matrix of  T  relative to the basis  C  where
 v1:= vector([1,1]):    v2:= vector([1,2]):   C:= augment( v1,v2):
 T_CC:= augment( linsolve(C,T(v1)), linsolve(C,T(v2)) );
P:= C: equal( evalm(P^(-1) &* T_BB &* P), T_CC );



