interface(echo=0);
#read `gfun.m`;
with(share):readshare(gfun,analysis):
readshare(fparfrac,calculus): # needed for ratpolytocoeff
with(gfun):
testdiffeq:=proc(deq1,deq2,y,z)
local eq1,eq2,Y;
    if type(deq1,set) and type(deq2,set) then
	if select(hastype,deq1,function(0))<>select(hastype,deq2,function(0))
	then RETURN(false) fi;
	eq1:=op(select(has,deq1,z));
	eq2:=op(select(has,deq2,z))
    elif type(deq1,set) or type(deq2,set) then RETURN(false)
    else eq1:=deq1; eq2:=deq2 fi;
    RETURN(evalb(type(normal(subs((D@@3)(y)(z)=Y^4,(D@@2)(y)(z)=Y^3,
	(D)(y)(z)=Y^2,y(z)=Y,eq1/eq2)),rational)))
end:

testrec:=proc(rec1,rec2,u,n)
local eq1,eq2,Y;
    if type(rec1,set) and type(rec2,set) then
	if select(hastype,rec1,function(integer))<>
		select(hastype,rec2,function(integer))
	then RETURN(false) fi;
	eq1:=op(select(has,rec1,n));
	eq2:=op(select(has,rec2,n))
    elif type(rec1,set) or type(rec2,set) then RETURN(false)
    else eq1:=rec1; eq2:=rec2 fi;
    RETURN(evalb(type(normal(subs(u(n+3)=Y^4,u(n+2)=Y^3,
	u(n+1)=Y^2,u(n)=Y,eq1/eq2)),rational)))
end:


# listtoseries
print(`Testing listtoseries`);
res1:=convert(listtoseries([1,1,2,5,14,42,132,429,1430,4862,16796,58786],
x,'egf'),polynom):
res2:=1+1*x+1*x^2+5/6*x^3+7/12*x^4+7/20*x^5+11/60*x^6+143/1680*x^7+143/4032*x^
8+2431/181440*x^9+4199/907200*x^10+4199/2851200*x^11:
if res1=res2 then ok else res1,res2 fi;

# seriestolist
print(`Testing seriestolist`);
res1:=seriestolist(series(z-2*t*z^2+5*t^2*z^3-14*t^3*z^4+42*t^4*z^5+O(z^6),z),
revogf):
res2:=[0,1,2*t,3*t^2,4*t^3,5*t^4]:
if res1=res2 then ok else res1,res2 fi;

# listtohypergeom
print(`Testing listtohypergeom`);
res1:=listtohypergeom([2,5,14,42,132,429,1430],x):
res2:=[-16/(1-4*x)^(1/2)/(1+(1-4*x)^(1/2))^3*x-3/(1-4*x)^(1/2)/x+
3/(1-4*x)^(1/2)/x^2-1/2/(1-4*x)^(1/2)/x^3+1/2/x^3*(1-4*x), ogf]:
if res1=res2 then ok else res1,res2 fi;

# listtoratpoly
print(`Testing listtoratpoly`);
res1:=listtoratpoly([1,1,2,3,5,8,13],x):
res2:=[-1/(-1+x+x**2), ogf]:
if res1=res2 then ok else res1,res2 fi;

# listtorec
print(`Testing listtorec`);
res1:=listtorec([1, 1, 2, 5, 14, 42, 132, 429, 1430, 4862, 16796, 58786],u(n)):
res2:=[{(-2-4*n)*u(n)+(n+2)*u(n+1), u(0) = 1}, ogf]:
if op(2,res1)=op(2,res2) and testrec(op(1,res1),op(1,res2),u,n)
	then ok else res1,res2 fi;
# from <Christian.Mallinger@risc.uni-linz.ac.at>
ll:=[0, 0, 1, 0, 5/6, 0, 13/18, 0, 325/504, 0, 2665/4536, 0, 162565/299376, 0, 
1062925/2095632, 0, 24022105/50295168, 0, 204894425/452656512, 0, 7417178185/
17200947456, 0, 1639196378885/3973418862336, 0, 434387040404525/
1096663606004736, 0, 418348134297281/1096663606004736, 0, 152697069018507565/
414538843069790208, 0]:
res1:=listtorec(ll,a(n)):
# used to give [{a(0)=0, a(1)=0, (-2*n-2*n^2-n^3)*a(n)+(2*n+3*n^2+n^3)*a(n+2)}, ogf]
# where the recurrence contains the factor n so that a(2) is not defined
res2:={a(2) = 1, a(0) = 0, a(1) = 0, (5+4*n+n^2)*a(n+1)+(-6-5*n-n^2)*a(n+3)}:
if testrec(res1[1],res2,a,n) then ok else res1,res2 fi;

# listtodiffeq
print(`Testing listtodiffeq`);
res1:=listtodiffeq([1,2,6,22,91,408,1938,9614,49335,260130,1402440,7702632,
42975796,243035536,1390594458,8038677054,46892282815,275750636070,1633292229030,
9737153323590],y(x)):
res2:=[{y(0)=1,(D(y))(0)=2,4/9+(-4/9+20/9*x)*y(x)+(-2/3*x+4*x**2)*diff(y(x),x)+
(-4/27*x**2+x**3)*diff(diff(y(x),x),x)}, ogf]:
if op(2,res1)=op(2,res2) and testdiffeq(op(1,res1),op(1,res2),y,x) then
	ok else res1,res2 fi;

# seriestodiffeq
print(`Testing seriestodiffeq`);
res1:=seriestodiffeq(series(exp(x)/sqrt(1-x),x,7),y(x)):
res2:=[{(3/2-x)*y(x)+(x-1)*diff(y(x),x), y(0) = 1}, ogf]:
if op(2,res1)=op(2,res2) and testdiffeq(op(1,res1),op(1,res2),y,x)
	then ok else res1,res2 fi;

# listtoalgeq
print(`Testing listtoalgeq`);
res1:=listtoalgeq([1,1,2,5,14,42,132,429,1430,4862,16796,58786],y(x)):
res2:=[1-y(x)+x*y(x)**2, ogf]:
if op(2,res1)=op(2,res2) and type(normal(subs(y(x)=Y,op(1,res1)/op(1,res2))),
	rational) then ok else res1,res2 fi;

# seriestoalgeq
print(`Testing seriestoalgeq`);
res1:=seriestoalgeq(series((1-sqrt(1-4*x)),x,9),y(x)):
res2:=[4*x-2*y(x)+y(x)**2, ogf]:
if op(2,res1)=op(2,res2) and type(normal(subs(y(x)=Y,op(1,res1)/op(1,res2))),
	rational) then ok else res1,res2 fi;

# guessgf
print(`Testing guessgf`);
res1:=guessgf([1,2,4,7,11,16,22],x):
# res2:=[-(1-x+x**2)/(x-1)**3, ogf]:
res2:=FAIL: # 7 coeff in the rat fct and only 7 elts in the list
if res1=res2 then ok else res1,res2 fi;
s:=seriestolist(map(collect,series((1/(1-x))^t,x,7),t)):
res1:=guessgf(s,x):
res2:=[(x-1)^(-t)/(-1)^(-t), ogf]:
res3:=[(1-x)^(-t),ogf]:
res4:=[(x-1)^(-t)/exp(-I*Pi*t), ogf]:
if res1=res2 or res1=res3 or res1=res4 then ok else res1,res3 fi;
res2:=guessgf(s,x,[lgdogf]):
res3:=[-t/(x-1),lgdogf]:
if res2=res3 then ok else res2,res3 fi;
res1:=guessgf([ 9,8,7,6,5,4,3,2,1,2,3,4,5,6,7,8,9],x):
res2:=[-10/(x^2-2*x+1)*x+9/(x^2-2*x+1)+2/(x^2-2*x+1)*x^9, ogf]:
res3:=[-(9/10*x+17/20*x^2+4/5*x^3+3/4*x^4+7/10*x^5+13/20*x^6+3/5*x^7+x^8-81/20)/(-1/2*x+9/20-1/20*x^8), ogf]:
if res1=res2 or res1=res3 then ok else res1,res2,res3 fi;
res1:=guessgf([1, 1, 2, 5, 14, 42, 132, 429, 1430, 4862, 16796, 58786],x,[revogf]):
if res1=[x-x^2,revogf] then ok else res1,FAIL fi;

# ratpolytocoeff
print(`Testing ratpolytocoeff`);
res1:=ratpolytocoeff(1/(1-x-x^2),x,n):
res2:=Sum(-(-1/5-2/5*alpha)/alpha*alpha^(-n),alpha = RootOf(-1+_Z+_Z^2)):
if res1=res2 then ok else res1,res2 fi;

# rectoproc
print(`Testing rectoproc`);
res1:=rectoproc({f(i)=f(i-1)+f(i-2),f(0)=0,f(1)=1},f(i))(100):
res2:=354224848179261915075:
if res1=res2 then ok else res1,res2 fi;
res1:=rectoproc({(1-n**2)*u(n+1)+3/2*u(n-1)+(1/2+3/2*n+n**2)*u(n),u(0)=1,u(2)=a}
,u(n))(10):
res2:=86773903/3440640*a-41665019/17203200:
if res1=res2 then ok else res1,res2 fi;
res1:=rectoproc(f(i)=f(i-1)+f(i-2),f(i))(100):
res2:=354224848179261915075*f(1)+218922995834555169026*f(0):
if res1=res2 then ok else res1,res2 fi;

# diffeqtorec
print(`Testing diffeqtorec`);
res1:=traperror(diffeqtorec(z^2*diff(w(z),z,z)+z*diff(w(z),z)+(z^2-nu^2)*w(z),
y(z),u(n))):
res2:=`non-polynomial coefficients`:
if res1=res2 then ok else res1,res2 fi;
res1:=traperror(diffeqtorec(-z**2*diff(y(z),z)+z*diff(y(z),z)-10*y(z)*z-y(z)+1,
y(z),u(n))):
res2:=`no valid initial conditions`:
if res1=res2 then ok else res1,res2 fi;
res1:=diffeqtorec((67/2000*t^2+129/1000)*diff(diff(f(t),t),t)+
77/500*t*diff(f(t),t)+5859/125*f(t) = 34/625,f(t),u(n)):
res2:=(468720+1205*n+335*n^2)*u(n)+(1290*n^2+3870*n+2580)*u(n+2):
if testrec(res1,res2,u,n) then ok else res1,res2 fi;
res1:=diffeqtorec((67/2000*t^2+129/1000)*diff(diff(f(t),t),t)+77/500*t*
diff(f(t),t)+5859/125*f(t) = 34/625,f(t),f(n)):
res2:=(468720+1205*n+335*n^2)*f(n)+(1290*n^2+3870*n+2580)*f(n+2):
if testrec(res1,res2,f,n) then ok else res1,res2 fi;
res1:=diffeqtorec({diff(diff(y(x),x),x)+3*x*diff(y(x),x)+y(x)=0,y(0)=0,
(D(y))(0)=1},y(x),c(n)):
res2:={c(0) = 0, c(1) = 1, (1+3*n)*c(n)+(n^2+3*n+2)*c(n+2)}:
if testrec(res1,res2,c,n) then ok else res1,res2 fi;
res1:=diffeqtorec(y(z)=a*diff(y(z),z),y(z),v(n)):
res2:=v(n)+(-a*n-a)*v(n+1):
if testrec(res1,res2,v,n) then ok else res1,res2 fi;
# used to give an order 4 recurrence
res1:=diffeqtorec(-y(z)+1/(1-z)+D(y)(z)-1/(1-z)^2+z*((D@@2)(y)(z)-2/(1-z)^3),
y(z),u(n)):
res2:=u(n)+(-2*n-1-n^2)*u(n+1)+n^2+2*n:
if testrec(res1,res2,u,n) then ok else res1,res2 fi;

# rectodiffeq
print(`Testing rectodiffeq`);
res1:=rectodiffeq({a(n) = l*(a(n-1)+l), a(0) = l},a(n),y(z)):
res2:=(1-z)*(-l*z+1)*y(z)-l*(1-z)-z*l^2:
if testdiffeq(res1,res2,y,z) then ok else res1,res2 fi;
res1:=rectodiffeq(op(1,listtorec([0,2,10,42,168,660,2574,10010,38896,151164,
587860,2288132,8914800,34767720,135727830,530365050,2074316640,8119857900,
31810737420,124718287980],t(n))),t(n),y(z)):
res2:={(-18*z^2+13*z-2)*y(z)+(-12*z^3+7*z^2-z)*(D(y))(z)+6*z,y(0)=0,D(y)(0)=2}:
if testdiffeq(res1,res2,y,z) then ok else res1,res2 fi;
res1 := rectodiffeq((1+k^2)*f(k)=1,f(k),y(z)):
res2 :={(1-z)*y(z)+(1-z)*z*(D(y))(z)+(1-z)*z^2*((D@@2)(y))(z)-1,y(0)=1,D(y)(0)=1/2}:
if testdiffeq(res1,res2,y,z) then ok else res1,res2 fi;
res1:=rectodiffeq((n-10)*u(n+1)-u(n),u(n),y(z)):
res2:=-y(z)+(-z-10)*D(y)(z)+z*(D@@2)(y)(z):
if testdiffeq(res1,res2,y,z) then ok else res1,res2 fi;
res1:=rectodiffeq({(5*n+10)*u(n)+k*u(n+1)-u(n+2),u(0)=0,u(1)=0},u(n),f(t)):
res2:=(-10*t^2-k*t+1)*f(t)-5*t^3*(D(f))(t):
if testdiffeq(res1,res2,f,t) then ok else res1,res2 fi;
# bug from <Christian.Mallinger@risc.uni-linz.ac.at> (fixed pz 111194) #
res1:=rectodiffeq({a(n+3)=a(n),a(0)=1,a(1)=1,a(2)=1},a(n),f(x)):
res2:=1+(x-1)*f(x):
if testdiffeq(res1,res2,f,x) then ok else res1,res2 fi;
# This used to return a non-homogeneous equation
# with lots of (D@@k)(y)(0). Changed BS Jan 95.
res1:=rectodiffeq(f(n)-6*f(n+2)-3*f(n+3)+2*f(n+4),f(n),y(z)):
res2:=24*y(z)+96*z*(D(y))(z)+(72*z^2-72)*(D@@2)(y)(z)+
(16*z^3-48*z-12)*(D@@3)(y)(z)+(z^4-6*z^2-3*z+2)*(D@@4)(y)(z):
if testdiffeq(res1,res2,y,z) then ok else res1,res2 fi;
# This used to lose the condition a(2)=1.
res1:=rectodiffeq({a(0) = 0, a(1) = 0, a(2) = 1,
(1+4/5*n+1/5*n^2)*a(n+1)+(-6/5-n-1/5*n^2)*a(n+3)},a(n),y(z)):
res2:={y(0)=0,D(y)(0)=0,-2*y(z)-3*z*D(y)(z)+(-z^2+1)*(D@@2)(y)(z)-2}:
if testdiffeq(res1,res2,y,z) then ok else res1,res2 fi;

# diffeq+diffeq, diffeq*diffeq, hadamardproduct
print(`Testing diffeq+diffeq, diffeq*diffeq, cauchyproduct`);
eq := diff(y(z),z,z)+y(z):
res1:=`diffeq*diffeq`(eq,eq,y(z)):
res2:=(D@@3)(y)(z)+4*D(y)(z):
if testdiffeq(res1,res2,y,z) then ok else res1,res2 fi;
rec1:={u(n+1)=(n+1)*u(n),u(0)=1}:
rec2:={u(n+1)=2*u(n),u(0)=1}:
deq1:=rectodiffeq(rec1,u(n),y(z)):
deq2:=rectodiffeq(rec2,u(n),y(z)):
deq3:=`diffeq+diffeq`(deq1,deq2,y(z)):
rec3:=diffeqtorec(deq3,y(z),u(n)):
rectoproc(rec3,u(n))(100)-(2^100+100!):
if "=0 then ok else ",0 fi;
eq1 := D(y)(x)-y(x):
eq2 := (1+x)*(D@@2)(y)(x)+D(y)(x):
res1:=`diffeq+diffeq`(eq1,eq2,y(x)):
res2:=(-x-3)*(D(y))(x)+(-x^2+1-2*x)*((D@@2)(y))(x)+(2+3*x+x^2)*((D@@3)(y))(x):
if testdiffeq(res1,res2,y,x) then ok else res1,res2 fi;
res1:=`diffeq*diffeq`(eq1,eq2,y(x)):
res2:=y(x)*x+(-2*x-1)*(D(y))(x)+(1+x)*((D@@2)(y))(x):
if testdiffeq(res1,res2,y,x) then ok else res1,res2 fi;
res1:=hadamardproduct(eq1,eq2,y(x)):
res2:=(-x-1)*(D(y))(x)-(D@@2)(y)(x)*x:
if testdiffeq(res1,res2,y,x) then ok else res1,res2 fi;
de:={f(x)+diff(f(x),x$2),f(0)=0,D(f)(0)=1}:
# bug from <Christian.Mallinger@risc.uni-linz.ac.at> (fixed pz 111194) #
res1:=`diffeq*diffeq`(de,de,f(x)):
res2:={f(0)=0,4*D(f)(x)+(D@@3)(f)(x),D(f)(0)=0,(D@@2)(f)(0)=2}:
if testdiffeq(res1,res2,f,x) then ok else res1,res2 fi;
# Initial conditions were lost. Fixed BS Jan 95.
Sin:={diff(y(z),z,z)=-y(z),y(0)=0,D(y)(0)=1}:
Cos:={diff(y(z),z,z)=-y(z),y(0)=1,D(y)(0)=0}:
Sin2:=`diffeq*diffeq`(Sin,Sin,y(z)):
Cos2:=`diffeq*diffeq`(Cos,Cos,y(z)):
one:=`diffeq+diffeq`(Sin2,Cos2,y(z)):
res:={4*D(y)(z)+(D@@3)(y)(z),y(0)=1,D(y)(0)=0,(D@@2)(y)(0)=0}:
if testdiffeq(one,res,y,z) then ok else one,res fi;
# Invalid format for the result. Fixed BS Jan 95.
deq:=(1-z-z^2)*y(z)-1:
res1:=`diffeq+diffeq`(deq,deq,y(z)):
res2:=(1-z-z^2)*y(z)-2:
if testdiffeq(res1,res2,y,z) then ok else res1,res2 fi;
# Invalid initial conditions in the result. Fixed BS Feb 95.
res1:=`diffeq+diffeq`(
 {y(0) = D(y)(0), y(z)+(3*z-1)*D(y)(z)+z^2*(D@@2)(y)(z)},
 {y(0) = D(y)(0)/2, 2*y(z)+(4*z-1)*D(y)(z)+z^2*(D@@2)(y)(z)},y(z)):
res2:=-4*y(z)+(-32*z+8)*D(y)(z)+(-38*z^2+10*z-1)*(D@@2)(y)(z)+(-12*z^3+2*z^2
)*(D@@3)(y)(z)-z^4*(D@@4)(y)(z):
if testdiffeq(res1,res2,y,z) then ok else res1,res2 fi;

# rec+rec, rec*rec, cauchyproduct
print(`Testing rec+rec, rec*rec, cauchyproduct`);
rec1:=u(n+1)=(n+1)*u(n):
rec2:=u(n+1)=2*u(n):
res1:=`rec*rec`(rec1,rec2,u(n)):
res2:=(-2*n-2)*u(n)+u(n+1):
if testrec(res1,res2,u,n) then ok else res1,res2 fi;
res1:=cauchyproduct(rec1,rec2,u(n)):
res2:=(2*n+4)*u(n)+(-n-4)*u(n+1)+u(n+2):
if testrec(res1,res2,u,n) then ok else res1,res2 fi;
# This used to lose the initial conditions. Fixed BS Jan 95
res1:=`rec*rec`({f(n+2)=f(n+1)+f(n),f(0)=1,f(1)=1},f(n)=-1,f(n)):
res2:={f(n)+f(n+1)-f(n+2),f(0)=-1,f(1)=-1}:
if testrec(res2,res2,f,n) then ok else res1,res2 fi;
# This didn't work for many reasons. Fixed BS Jan 95.
fib:={f(n+2)=f(n+1)+f(n),f(0)=0,f(1)=1}:
rec1:=`rec*rec`(fib,fib,f(n)):
rec2:=`rec*rec`({f(n+2)=f(n+1)+f(n),f(0)=1,f(1)=1},{f(n+2)=f(n+1)+f(n),f(1)=0,f(2)=1},f(n)):
rec2:=`rec*rec`(rec2,f(n)=-1,f(n)):
res1:=`rec+rec`(rec1,rec2,f(n)):
res2:={f(n+1)+f(n),f(0)=1}:
if testrec(res2,res2,f,n) then ok else res1,res2 fi;
# This used to find a 3rd order recurrence. Fixed BS March 95.
rec1:={u(n+1)=(n+1)*u(n),u(1)=1}:
rec2:={u(n+1)=2*u(n),u(1)=1}:
res1:=`rec+rec`(rec1,rec2,u(n)):
res2:={(2*n+2*n^2)*u(n)+(-1+n)*u(n+2)+(2-n^2-3*n)*u(n+1),
u(1) = 2, u(0) = 3/2, u(2) = 4, u(3) = 10}:
if testrec(res2,res2,f,n) then ok else res1,res2 fi;
# an example with parameters
rec:=y(n+1)=a*y(n)-y(n-1): ini:=y(0)=c[0],y(1)=c[1]:
res1:=`rec+rec`(`rec*rec`(y(n)=-1,
      `rec*rec`({rec,y(0)=c[1],y(1)=a*c[1]-c[0]},
                {rec,y(1)=c[0],y(2)=c[1]},y(n)),y(n)),
      `rec*rec`({rec,ini},{rec,ini},y(n)),y(n)):
res2:=
{-y(n)+(a^4+2-3*a^2)*y(n+2)+(2*a^2-a^4)*y(n+3)+(-1+a^2)*y(n+4), y(2) = c[1]^2
-a*c[1]*c[0]+c[0]^2, y(1) = c[1]^2-a*c[1]*c[0]+c[0]^2, y(0) = c[1]^2-a*c[1]*c[0
]+c[0]^2, y(3) = c[1]^2-a*c[1]*c[0]+c[0]^2}:
if testrec(res1,res2,y,n) then ok else res1,res2 fi;

# borel, invborel
print(`Testing borel, invborel`);
rec:=a(n)-a(n-1)-a(n-2):
res1:=borel(rec,a(n)):
res2:=-a(n)+(-n-1)*a(n+1)+(n^2+3*n+2)*a(n+2):
if testrec(res1,res2,a,n) then ok else res1,res2 fi;
res1:=invborel(res1,a(n)):
res2:=a(n+2)-a(n+1)-a(n):
if testrec(res1,res2,a,n) then ok else res1,res2 fi;
rec:={a(n+2)-a(n+1)-a(n),a(0)=0,a(1)=1}:
borel(rec,a(n)):
invborel(",a(n)):
if "=rec then ok else rec," fi;
rectodiffeq(""",a(n),f(t)):
invborel(",f(t),'diffeq'):
res:=diffeqtorec(",f(t),a(n)):
if testrec(res,rec,a,n) then ok else rec,res fi;
eq:={z^2*diff(y(z),z,z)+y(z)=z,D(y)(0)=1}:
res1:=borel(eq,y(z),'diffeq'):
res2:=y(z)-z:
if res1=res2 then ok else res1,res2 fi;
res1:=borel(rectodiffeq(invborel({a(n)=a(n-1)+a(n-2),a(0)=0,a(1)=1},a(n)),a(n),
f(t)),f(t),'diffeq'):
res2:=(-t^2-t+1)*f(t)-t:
if testdiffeq(res1,res2,f,t) then ok else res1,res2 fi;
res1:=borel({y(0)=1, (D(y))(0) = 1, (1-z)*y(z)-z^2*(D(y))(z)-1},y(z),'diffeq'):
res2:=(-z+1)*y(z)-1:
if testdiffeq(res1,res2,y,z) then ok else res1,res2 fi;

# algeqtodiffeq
print(`Testing algeqtodiffeq`);
res1:=algeqtodiffeq(y=1+z*y^2,y(z)):
res2:={y(0)=1,(-z/4+z**2)*D(y)(z)+(-1/4+z/2)*y(z)+1/4}:
if testdiffeq(res1,res2,y,z) then ok else res1,res2 fi;
res1:=algeqtodiffeq(y^2-x^2,y(x)):
res2:=x*D(y)(x)-y(x):
if testdiffeq(res1,res2,y,x) then ok else res1,res2 fi;
eq:=-28*x**2+3*y*x-31*y+y^2:
res1:=algeqtodiffeq(eq,y(x)):
res2:=1736/121*x+(-x+93/121)*y(x)+(x^2-186/121*x+961/121)*(D(y))(x):
if testdiffeq(res1,res2,y,x) then ok else res1,res2 fi;
res1:=algeqtodiffeq(eq,y(x),{y(0)=0}):
res2:={1736/121*x+(-x+93/121)*y(x)+(x^2-186/121*x+961/121)*(D(y))(x),y(0) = 0}:
if testdiffeq(res1,res2,y,x) then ok else res1,res2 fi;
res1:=traperror(algeqtodiffeq(eq,y(x),{y(0)=1})):
res2:=`invalid initial conditions`:
if res1=res2 then ok else res1,res2 fi;
eq:=56*a^3+7*a^3*y^3-14*y*z:
tt:=rectoproc(diffeqtorec(algeqtodiffeq(eq,y(z),{y(0)=-2}),y(z),u(n)),u(n),
remember):
res1:=map(normal,series(subs(y=listtoseries([seq(tt(i),i=0..10)],z,ogf),eq),z,10)):
res2:=series(O(z^10),z):
if res1=res2 then ok else res1,res2 fi;
eq:=y=1+z*(y^2+y^3):
tt:=rectoproc(diffeqtorec(algeqtodiffeq(eq,y(z),{}),y(z),u(n)),u(n),remember):
res1:=series(subs(y=listtoseries([seq(tt(i),i=0..10)],z,ogf),op(1,eq)-op(2,eq))
,z,10):
res2:=series(O(z^10),z):
if res1=res2 then ok else res1,res2 fi;
res1:=algeqtodiffeq(y^5*(1-x)=1,y(x),{y(0)=1}):
res2:={y(x)+(-5+5*x)*D(y)(x),y(0)=1}:
if res1=res2 then ok else res1,res2 fi;
res1:=algeqtodiffeq(x*y^4-1,y(x)):
res2:=y(x)+4*x*(D(y))(x):
if res1=res2 then ok else res1,res2 fi;

# algebraicsubs
print(`Testing algebraicsubs`);
deq:={y(0)=1,(D(y))(0)=1/2,(1-z)*y(z)+(1-z)*z*(D(y))(z)+(1-z)*z^2*((D@@2)(y))(z)-1}:
res1:=algebraicsubs(deq,(1-z)*y+z,y(z)):
res2:=y(z)+(z-3*z^2+2*z^3)*(D(y))(z)+(z^2-2*z^3+z^4)*((((D@@2))(y))(z)-
(-1+2*z-z^2)/(-1+z)^3/z^2):
if testdiffeq(res1,res2,y,z) then ok else res1,res2 fi;
res1:=`diffeq*diffeq`(res2,y(z)*(1-z)-1,y(z)):
res2:={(2*z^2-z+1)*y(z)+(4*z^3-5*z^2+z)*(D(y))(z)+(z^4-2*z^3+z^2)*
(((D@@2))(y))(z)-1, y(0) = 1, (D(y))(0) = 1/2}:
if testdiffeq(res1,res2,y,z) then ok else res1,res2 fi;
res1:=diffeqtorec(res2,y(z),g(n)):
res2:={g(0) = 1, g(1) = 1/2, (n^2+3*n+2)*g(n)+(-6-7*n-2*n^2)*g(n+1)+(4*n+5+n^2)
*g(n+2)}:
if testrec(res1,res2,g,n) then ok else res1,res2 fi;
res1:=rectoproc(res2,g(n))(20):
res2:=-3845848802828440117248/7315582032468906326065:
if res1=res2 then ok else res1,res2 fi;
res1:=algebraicsubs((D@@2)(f)(t)+f(t),f^2-1+4*t,f(t)):
res2:=-f(t)+D(f)(t)/2+(t-1/4)*(D@@2)(f)(t):
if testdiffeq(res1,res2,f,t) then ok else res1,res2 fi;
res1:=algebraicsubs({y(0) = 1, -1+(z+1)*y(z)+(z^2+z)*diff(y(z),z)
+(z^2+z^3)*diff(diff(y(z),z),z), (D(y))(0) = -1/2},z*y^2+(2*z-1)*y+z,y(z)):
res2:=2*y(z)+(36*z^2-18*z+2)*(D(y))(z)+(3*z-28*z^2+64*z^3)*((D@@2)(y)(z)-(1+4*
z^2-5*z)/z^2/(4*z-1)^2)+(16*z^4-8*z^3+z^2)*(((D@@3)(y))(z)+(-3+32*z-96*z^2+
64*z^3)/(4*z-1)^3/z^3):
if testdiffeq(res1,res2,y,z) then ok else res1,res2 fi;
#quit

