# Test file for "ilp", an integer linear program solver: Anu Pathria

with(share): readshare(ilp,numerics): # read `ilp.m`:
#ILP infeasible, LP feasible
s := ilp(3*x1 + x2,{x1 <=10,3*x2<= 8, 3*x2 >= 7}):
evalb(s={});

#ILP infeasible, LP unbounded
s := ilp(-3*x1 + x2,{x1 <=10,3*x2<= 8, 3*x2 >= 7}):
evalb(s={});

#ILP unbounded
s := ilp(-3*x1 + x2,{x1 <=10,3*x2<= 10, 3*x2 >= 7}):
evalb(s=NULL);

#Various examples
s := ilp(-3*x1 + x2,{x1 >= -10,3*x2<= 10, 3*x2 >= 7}):
testeq(subs(s,-3*x1+x2),33);

s := ilp(5*x1+4*x2,{6*x1+13*x2 <= 67,8*x1+5*x2 <=55},NONNEGATIVE):
testeq(subs(s,5*x1+4*x2),34);

s := ilp(75*x1+6*x2+3*x3+33*x4,{774*x1+76*x2+22*x3+42*x4 <= 875,
            67*x1+27*x2+794*x3+53*x4 <= 875,
            x1 <= 1, x2 <= 1, x3 <= 1, x4 <= 1},NONNEGATIVE):
testeq(subs(s,75*x1+6*x2+3*x3+33*x4),108);

s := ilp(4*x1-2*x2+7*x3,{x1+5*x3 <= 10,x1+x2-x3 <=1,6*x1-5*x2 <=0},
             NONNEGATIVE):
testeq(subs(s,4*x1-2*x2+7*x3),14);

#Test use of optional 3rd argument
s := ilp(5*x1+8*x2,{x1+x2 <=6,5*x1+9*x2<=45,x1>=0,x2>=0}):
testeq(subs(s,5*x1+8*x2),40);
s := ilp(5*x1+8*x2,{x1+x2 <=6,5*x1+9*x2<=45,x1>=0,x2>=0},UNRESTRICTED):
testeq(subs(s,5*x1+8*x2),40);
s := ilp(5*x1+8*x2,{x1+x2 <=6,5*x1+9*x2<=45},NONNEGATIVE):
testeq(subs(s,5*x1+8*x2),40);

s := ilp(3*x1 + 2*x2,{x1-3*x2 <= 10,x2 +5*x1 >=3,x1+2*x2 <= 20},UNRESTRICTED):
testeq(subs(s,3*x1+2*x2),52);
s := ilp(3*x1 + 2*x2,{x1-3*x2 <= 10,x2 +5*x1 >=3, x1 +2*x2 <= 20}):
testeq(subs(s,3*x1+2*x2),52);

#quit
