#
## <SHAREFILE=combinat/symmpoly/symmpoly.mpl >
## <DESCRIBE>
##                Utility routine for generating the symmetric polynomials.
##                AUTHOR: Michael Monagan, monagan@inf.ethz.ch
## </DESCRIBE>

#--> symmpoly([x1,x2,...,xn]);  or  symmpoly([x1,x2,...,xn],m);
#
# Return the m'th (default a sequence for m = 0..n) symmetric polynomial
# in the variables x1,x2,...,xn (which may not necessarilly be distinct).
# Author MBM: Aug/90
# Updated MBM: Jun/93 to use combinat[choose]
#

symmpoly := proc(x,m) local n, i, t;

    if not type(x,list(name)) then
	ERROR(`1st argument must be a list of names`) fi;

    n := nops(x);

    if nargs=1 then RETURN( seq( symmpoly(x,i), i=0..n ) ) fi;

    if not type(m,integer) or m < 0 or m > n then 
    	ERROR( `2nd argument must be an integer in the range`,0..n) fi;

    convert( [seq( convert(t,`*`), t=combinat[choose](x,m) )], `+` )

end:
`combinat/symmpoly` := eval(symmpoly):

#save `symmpoly.m`;
#quit
