#
## <SHAREFILE=geometry/turtle/turtle.mpl >
## <DESCRIBE>
##         SEE ALSO: geometry/turtle/turtle.ms
##            A package for supporting the Turtle graphics
##                 SEE ALSO Maple Technical Newsletter, Speical Issue on
##                 Maple in Mathematics and the Sciences for a written document.
##                 AUTHOR Eugenio Roanes Lozano, roanes@mat.ucm.es
##                 AUTHOR Eugenio Roanes Macias, eroanes@fi.upm.es
## </DESCRIBE>
## <UPDATE=R4 >

turtle:=`turtle `:
##########################
# standard input
###
# Convert from 5.2 to Release 3

#  (***************************************************************)
#  (*                                                             *)
#  (*         GEOMETRIA DE LA TORTUGA EN MAPLE V.2                *)
#  (*                                                             *)
#  (***************************************************************)

# Authors: Eugenio Roanes Lozano & Eugenio Roanes Macias
#          Sec. Dptal Algebra
#          Fac. Educacion (Univ. Complutense)
#          c/ Santisima Trinidad 37
#          E-28010-Madrid (SPAIN)
#          e-mail: roanes@mat.ucm.es   ;   eroanes@fi.upm.es


# The following are the global variables:
   macro(XMax=200,YMax=150);     # Maximun abs. value of x coordinates
                                 # and y coordinates on the screen
                                 # (not internally).
   macro(dib=`turtle/dib`);      # List where the CURVES are stored
   # XCor;                       # Turtle position (x)
   # YCor;                       # Turtle position (y)
   # Heading;                    # Turtle orientation
   # PenColor;                   # Color of the trail
                                 # (RGB or HUE)
   macro(posicion_lapiz=`turtle/posicion_lapiz`);  # 1 leaves trail/0 doesn't


#  {***************************************************************}
#  {         IMPLEMENTACION DE PRIMITIVAS DE LA TORTUGA            }
#  {***************************************************************}

  ClearScreen:=proc()
          global  XCor, YCor, Heading, PenColor, posicion_lapiz, dib;
          XCor := 0;  YCor := 0;
          Heading := 0;
          PenColor := COLOUR(RGB,0,0,0);
          posicion_lapiz := 1;
          dib:={};
          NULL;
      end:   #ClearScreen


  PenUp:=proc()
           global  posicion_lapiz;
           posicion_lapiz := 0;
           NULL;
      end:    #PenUp


  PenDown:=proc()
           global  posicion_lapiz;
           posicion_lapiz := 1;
           NULL;
      end:    #PenDown


  Forwd:=proc(distancia :: algebraic)
         global  XCor, YCor, dib;
         local antigua_absc_tort, antigua_ord_tort, angulo_radianes;
         angulo_radianes := Pi * (90-Heading) / 180;
         antigua_absc_tort := XCor;
         antigua_ord_tort := YCor;
         XCor := XCor + distancia * cos(angulo_radianes);
         YCor := YCor + distancia * sin(angulo_radianes);
         if posicion_lapiz = 1 then
                dib:={op(dib),CURVES(
                      [[evalf(antigua_absc_tort),evalf(antigua_ord_tort)],
                       [evalf(XCor),evalf(YCor)]],
                       PenColor
                     )} fi;
         NULL;
      end:    #Forwd


  Back:=proc(distancia :: algebraic)
         Forwd(-distancia);
         NULL;
      end:    #Back


  SetPosition:=proc(nueva_abscisa_tortuga :: algebraic,
                    nueva_ordenada_tortuga :: algebraic)
         global  XCor, YCor, dib;
         local antigua_absc_tort, antigua_ord_tort;
         antigua_absc_tort := XCor;
         antigua_ord_tort := YCor;
         XCor := nueva_abscisa_tortuga;
         YCor := nueva_ordenada_tortuga;
         if posicion_lapiz = 1 then
                dib:={op(dib),CURVES(
                      [[evalf(antigua_absc_tort),evalf(antigua_ord_tort)],
                       [evalf(XCor),evalf(YCor)]],
                       PenColor
                     )} fi;
         NULL;
      end:    #SetPosition


  SetX:=proc(nueva_abscisa_tortuga :: algebraic)
         SetPosition(nueva_abscisa_tortuga,YCor);
         NULL;
      end:    #SetX


  SetY:=proc(nueva_ordenada_tortuga :: algebraic)
         SetPosition(XCor,nueva_ordenada_tortuga);
         NULL;
      end:    #SetY


  Home:=proc()
         SetPosition(0,0);
         SetHeading(0);
         NULL;
      end:    #Home


  TurnRight:=proc(angulo :: algebraic)
         global  Heading;
         Heading := Modu(Heading + angulo);
         NULL;
      end:    #TurnRight


  TurnLeft:=proc(angulo :: algebraic)
         global  Heading;
         Heading := Modu(Heading - angulo);
         NULL;
      end:    #TurnLeft


  SetHeading:=proc(rumbo :: algebraic)
         global  Heading;
         Heading := Modu(rumbo);
         NULL;
      end:   #SetHeading


  SetHeadingTowards:=proc(abscisa :: algebraic, ordenada :: algebraic)
     global  Heading;
     local ang;
     if (abscisa - XCor) = 0 and (ordenada - YCor) = 0 then
          Heading := Heading
       else
         if evalf(abscisa - XCor) = 0 then  ang := 90
          else ang := (180 * arctan((ordenada-YCor) / (abscisa-XCor)) / Pi) fi;
         if (evalf(abscisa - XCor) < 0) and (evalf(ordenada - YCor) >= 0) then
                               ang := ang + 180 fi;
         if (evalf(abscisa - XCor) <= 0) and (evalf(ordenada - YCor) < 0) then
                               ang := ang - 180 fi;
         Heading := Modu(90 - ang) fi;
     NULL;
     end:   #SetHeadingTowards

  FullScreen:=proc()
         PLOT(op(dib),VIEW(-XMax..XMax,-YMax..YMax),AXESSTYLE(NONE));
      end:   #FullScreen

  SetPenColor:=proc(nuevo_color_lapiz)
global  PenColor;
;
         PenColor := nuevo_color_lapiz;
         NULL;
      end:   #SetPenColor

  Dot:=proc(abscisa_punto::algebraic,ordenada_punto::algebraic)
         global  dib;
         dib:={op(dib),CURVES(
               [[evalf(abscisa_punto),evalf(ordenada_punto)],
                [evalf(abscisa_punto),evalf(ordenada_punto)]],
                PenColor
                )};
         NULL;
      end:   #Dot

  Modu:=proc(num::algebraic)
         if evalf(num) > 0 then
                        if evalf(num)>360 then Modu(num-360) else num fi
                    else
                        if evalf(num)<(-360) then Modu(num+360) else num fi
                    fi;
      end:   #Modu


  ClearScreen();    #Para inicializar las variables.


#save `turtle.m`;
#quit
