#
## <SHAREFILE=program/gdegree/gdegree.mpl >
## <DESCRIBE>
##                An example of programming with Maple expressions (formulae).
##                This program computes the degree of an expression allowing
##                rational and symbolic exponents.
##                AUTHOR: Michael Monagan, monagan@inf.ethz.ch
## </DESCRIBE>

#--> gdegree(a:algebraic,x:{name,list(name),set(name)})
#
# gdegree(a,x) ==> degree of a in x
# gdegree(a,{x1,x2,...,xn}) ==> total degree in x1,x2,...,xn
# gdegree(a) ==> total degree in all variables
#
# This is an example of how to write a Maple procedure which
# walks through a Maple expression recursively.
#
# Author: MBM June/92
#

gdegree := proc(p) local t,v;
    v := args[2..nargs];
    if type(p,constant) then 0 # Note, includes symbolic constants e.g. Pi
    elif type(p,name) then
	if nargs=1 then 1
	elif type(v,{set,list}) then if member(p,v) then 1 else 0 fi
	else if p=v then 1 else 0 fi
	fi
    elif type(p,`*`) then convert([seq(gdegree(t,v), t=p)], `+`)
    elif type(p,`^`) then gdegree(op(1,p),v)*op(2,p)
    elif type(p,`+`) then max(seq(gdegree(t,v),t=p))
    elif nargs=1 or has(p,v) then ERROR(`unable to compute degree`)
    else 0
    fi
end:


# save `gdegree.m`;
# quit
