with(share):readshare(partials,analysis):
with(partials):
#####################################################################
#
# Edgardo S. Cheb-Terrab
# E-Mail: TERRAB@BRUERJ.BITNET
# Address:
#        Edgardo S. Cheb-Terrab
#        Departamento de Fisica Teorica, Instituto de Fisica
#        Universidade do Estado do Rio de Janeiro, UERJ:
#        Rua Sao Francisco Xavier 524, RJ 20550-013
#        Brazil
#
# Test for the commands of the Partials package.
#
#####################################################################
#                        TEST procedure

TEST := proc(example)
global NUMBER;

NUMBER := NUMBER + 1:              # NUMBER of example being tested.
print();                           # Separator.
if example=0

# if any "example" <> 0 please turn on the following two lines:
#
# or frontend(expand,[example]) = 0
# or simplify(example) = 0 or expand(example) = 0

then
print(cat(`Example `,NUMBER,`) :   OK`));

# Alternative output:
#
# OK;
#
# print(OK);

else
print(cat(`Example `,NUMBER,`) : FAIL`));
print(`Unexpected error`,
`the input and expected output can be seen in the ASCII partials.tes file.`):

# print(`Please contact E.S.Cheb-Terrab`,`e-mail: TERRAB@BRUERJ.BITNET`):

fi:
end:

#####################################################################
# Load the package

#read `partials`;
#with(partials);
#####################################################################
# Initialize counters and timing

TOTNUMBER := 0:    # Total number of examples
TIME0 := time():

#####################################################################
# Here begins the TEST.
#
# 1) Command: Intc, Int2c, Int3c Int4c
#

print(_______________________________________________________________):
print(`Testing procedures Intc, Int2c, Int3c and Int4c.`):
print(_______________________________________________________________):

NUMBER := 0:       # number of examples of this command

# Example 1)
'Intc'(f(x,y,z,t),x):
TEST("-Int(f(x,y,z,t),x = -infinity..infinity));

# Example 2)
'Int2c'(f(x,y,z,t),x,y):
TEST("-Int(Int(f(x,y,z,t),x = -infinity..infinity),
y = -infinity..infinity));


# Example 3)
'Int3c'(f(x,y,z,t),x,y,z):
TEST("-Int(Int(Int(f(x,y,z,t),x = -infinity..infinity),
y = -infinity..infinity),z = -infinity..infinity));


# Example 4)
'Int4c'(f(x,y,z,t),x,y,z,t):
TEST("-Int(Int(Int(Int(f(x,y,z,t),x = -infinity..infinity),
y =-infinity..infinity),z=-infinity..infinity),t=-infinity..infinity));


TOTNUMBER := TOTNUMBER + NUMBER:
#####################################################################
#
# 2) Command: Value
#
# Procedure for illustrating the test: Value/d_
# Expected argument: p = d_[k](f(X,Y,...)) <- meaning -> diff(f(x,y,...),xk)
#

`Value/d_`:=proc(p) option `i n d e x e d`;diff(op(p),cat(x,op(op(0,p)))) end:

#

print(_______________________________________________________________):
print(`Testing procedure Value.`):
print(_______________________________________________________________):

NUMBER := 0:

# Example 1)
'Value'(exp(Int(x,x))):
TEST("-(exp(1/2*x^2)));

# Example 2)
'Value'(Limit(Diff(x^2,x),x=2)):
TEST("-4);

# Example 3)
'Value'(d_[1](f(x1,x2,x3,x4))):
TEST("-'diff'(f(x1,x2,x3,x4),x1));

# Example 4)
'Value'(d_[2](f(x1,x2,x3,x4))):
TEST("-'diff'(f(x1,x2,x3,x4),x2));

# Example 5)
'Value'(d_[3](f(x1,x2,x3,x4))):
TEST("-'diff'(f(x1,x2,x3,x4),x3));

# Example 6)
'Value'(d_[4](f(x1,x2,x3,x4))):
TEST("-'diff'(f(x1,x2,x3,x4),x4));

# Example 7)
'Value'(d_[5](f(x1,x2,x3,x4))):
TEST("-0);

# Example 8)
'op'('Value'(parameters(m))):
TEST("-m);
m := 'm':

# Example 9)
'Value'(Sum(Limit(x^n,n=''i''),''i''=1..3)):
TEST("-(x+x^2+x^3));

# Example 10)
'Value'(Normal(Sum(Limit(x^n,n=''i''),''i''=1..3))):
TEST("-(x+x^2+x^3));

# Example 11)
'Value'(Product(Sum(Limit(x^n,n=''i''),''i''=1..3),x=1..3)):
TEST("-1638);

# Example 12)
'Value'(Diff(x*Limit(y^x,x=4),x)):
TEST("-y^4);

# Example 13)
'Value'(Int(Diff(x*Limit(y^x,x = 4),x),x = 1..3)):
TEST("-2*y^4);

# Example 14)
'Value'(Pdiff(Int(f(x),x=A(g(x))..B(g(x))),g(x))):
TEST("-(f(B(g(x)))*D(B)(g(x))-f(A(g(x)))*D(A)(g(x))));

# Example 15)
'Value'(Limit(f[x],x = 8)):
TEST("-f[8]);

# Example 16)
'Value'(Limit(f[g(x)](x),x=8)):
TEST("-f[g(8)](8));

# Removing the auxiliary procedure:

`Value/d_`:='`Value/d_`':

TOTNUMBER := TOTNUMBER + NUMBER:
#####################################################################
#
# 3) Command: evalDi
#

print(_______________________________________________________________):
print(`Testing procedure evalDi.`):
print(_______________________________________________________________):

NUMBER := 0:

# Example 1)
'evalDi'(Intc(f(x)*Dirac(a*x+b),x)):
TEST("-(1/abs(a)*f(-b/a)));

# Example 2)
'evalDi'(Intc(f(x)*Dirac(x/a-b),x)):
TEST("-(abs(a)*f(b*a)));

# Example 3)
'evalDi'(Intc(f(x)*'diff'(Dirac(a*x+b),x),x)):
TEST("-(-D(f)(-b/a)/abs(a)));

# Example 4)
'evalDi'(Int2c(f(x,y)*Dirac(a*x-u)*'diff'(Dirac(b*y-v),y$3),x,y)):
TEST("-(-1/abs(a)*D[2,2,2](f)(u/a,v/b)/abs(b)));

# Example 5)
'evalDi'(Intc(f(y)*Dirac(y)*Diff(P(y),y$3),y)):
TEST("-(f(0)*((`@@`(D,3))(P))(0)));

# Example 6)
'evalDi'(Intc(f(y)*'diff'(Dirac(b*y-v),y$3),y)):
TEST("-(-`@@`(D,3)(f)(v/b)/abs(b)));

# Example 7)
'evalDi'(Intc(f(y)*'diff'(Dirac(b*y-v),y$3),y)):
TEST("-(-`@@`(D,3)(f)(v/b)/abs(b)));

# Example 8)
'evalDi'(Intc(f(x)*Diff(Dirac(x/a-1),x),x)):
TEST("-(diff(f(a),a)*abs(a)));

# Example 9)
'evalDi'(Intc(f(x1,x2,x3,x0)*exp(Int3c(L(x1,x2,x3,x0)*Diff(Dirac(a*x1-u1),x1)
       *Dirac(x2-u2)*Dirac(x3-u3),x1,x2,x3)),x0)):
TEST("-(Int(f(x1,x2,x3,x0)*exp(-D[1](L)(u1/a,u2,u3,x0)/abs(a)),
       x0 = -infinity..infinity)));


# Example 10)
'evalDi'(Intc(g(z,r)*Dirac(z-s)*Intc(Intc(f(x,y,z)*(Intc(g(x,t),t)+Intc(g(x,n)
       *Dirac(n-m),n)),x),y),z)):
TEST("-(g(s,r)*Int(Int(f(x,y,s)*(Int(g(x,t),t = -infinity..infinity)+g(x,m)),
        x = -infinity..infinity),y = -infinity..infinity)));

# Example 11)
'evalDi'(Intc(g(z,r)*Dirac(z-s)*Intc(Intc('diff'(Dirac(a*x+b),x)*f(x,y,z)
       *(Intc(g(x,t),t)+Intc(g(x,n)*Dirac(n-m),n)),x),y),z)):
TEST("-
g(s,r)*Int(-(D[1](f)(-b/a,y,s)*Int(g(-b/a,t),t = -infinity .. infinity)+f(-b/
a,y,s)*`diff/Int`(g(-b/a,t),t = -infinity .. infinity,0)*a)/abs(a)-(D[1](f)(-
b/a,y,s)*g(-b/a,m)+f(-b/a,y,s)*D[1](g)(-b/a,m))/abs(a),y = -infinity .. 
infinity) );

# Example 12)
'evalDi'(Int(Int(f(x3,x4)*Dirac(e*x3+f)*exp(Int(Int(f(x1,x2)*G(x1,x2,x3,x4)
       *Diff(Dirac(a*x1+b),x1)*Dirac(c*x2+d),x1 = -infinity..infinity),
       x2 = -infinity..infinity))*Diff(Dirac(g*x4+h),x4),x3
       = -infinity..infinity),x4 = -infinity..infinity)):
frontend(expand,["-(-exp(-1/abs(c)*(D[1](f)(-b/a,-d/c)*G(-b/a,-d/c,-f/e,-h/g)
+f(-b/a,-d/c)*D[1](G)(-b/a,-d/c,-f/e,-h/g))/abs(a))*(D[2](f)(-f/e,-h/g)*abs(a)
*abs(c)-f(-f/e,-h/g)*D[1](f)(-b/a,-d/c)*D[4](G)(-b/a,-d/c,-f/e,-h/g)
-f(-f/e,-h/g)*f(-b/a,-d/c)*D[1,4](G)(-b/a,-d/c,-f/e,-h/g))/abs(e)/abs(c)/abs(a)
/abs(g))]):
TEST(");

# Example 13)
'evalDi'(Intc(f(x3,x4)*(Dirac(x3-y1)*Dirac(x4-y2)*Int2c(f(x1,x2),x1,x2)
+f(x3,x4)*Intc(Dirac(x1-y1),x1)*Intc(Dirac(x2-y2),x2))
*exp(f(x3,x4)*Int2c(f(x1,x2),x1,x2)),x3)):
TEST("-(Dirac(x4-y2)*Int(Int(f(x1,x2),x1=-infinity..infinity),
        x2=-infinity..infinity)*f(y1,x4)*exp(f(y1,x4)*Int(Int(f(x1,x2),
        x1=-infinity..infinity),x2=-infinity..infinity))
        +Int(f(x3,x4)^2*exp(f(x3,x4)*Int(Int(f(x1,x2),x1=-infinity..infinity),
        x2=-infinity..infinity)),x3=-infinity..infinity)));

TOTNUMBER := TOTNUMBER + NUMBER:
#####################################################################
#
# 4) Command: fdiff
#

print(_______________________________________________________________):
print(`Testing procedure fdiff.`):
print(_______________________________________________________________):

NUMBER := 0:

# Example 1)
'fdiff'(q(u),q(x)):
TEST("-Dirac(u-x));

# Example 2)
'fdiff'(q(u1,u2,u3,u0),q(x1,x2,x3,x0)):
TEST("-Dirac(u1-x1)*Dirac(u2-x2)*Dirac(u3-x3)*Dirac(u0-x0));

# Example 3)
'fdiff'(D(q)(t),q(u)):
TEST("-Dirac(1,t-u));

# Example 4)
'fdiff'(Int(1/2*'diff'(q(t),t)^2-1/2*k*q(t)^2,t=-infinity..infinity),q(u)):
TEST("-(-k*q(u)-'diff'((D(q))(u),u)));

# Example 5)
'fdiff'(Int(1/2*'diff'(q(t),t)^2-1/2*k*q(t)^2,t = -a..a),q(u)):
TEST("-(Int(-Dirac(t-u)*k*q(t)+D(q)(t)*Dirac(1,t-u),t = -a..a)));

# Example 6)
'fdiff'(Int(r(t)+f(y),y=-infinity..infinity),f(u)):
TEST("-1);

# Example 7)
'fdiff'(Int(Int(-1/2*(-Diff(A1(x1,x0),x0)-Diff(A0(x1,x0),x1))
        *(Diff(A1(x1,x0),x0)+Diff(A0(x1,x0),x1))+1/2*m^2
        *(A0(x1,x0)^2-A1(x1,x0)^2),x1= -infinity..infinity),
        x0 = -infinity..infinity),A1(u1,u0)):
TEST("-(-m^2*A1(u1,u0)-'diff'(((D[2])(A1))(u1,u0),u0)
      -'diff'(((D[1])(A0))(u1,u0),u0)));

# Example 8)
'fdiff'(Int(Int(-1/2*(-Diff(A1(x1,x0),x0)-Diff(A0(x1,x0),x1))
        *(Diff(A1(x1,x0),x0)+Diff(A0(x1,x0),x1))+1/2*m^2
        *(A0(x1,x0)^2-A1(x1,x0)^2),x1=-infinity..infinity),
        x0=-infinity..infinity),A0(u1,u0)):
TEST("-(m^2*A0(u1,u0)-D[1,2](A1)(u1,u0)-D[1,1](A0)(u1,u0)));

# Example 9)
'fdiff'(Int2c(f(x1,x2)*f(x3,x4),x1,x2),f(y1,y2)):
TEST("-(Dirac(x3-y1)*Dirac(x4-y2)*Int(Int(f(x1,x2),x1=-infinity..infinity),
       x2=-infinity..infinity)+f(x3,x4)));

# Example 10)
'fdiff'(exp(Int2c(f(x1,x2)*f(x3,x4),x1,x2)),f(y1,y2)):
TEST("-((Dirac(x3-y1)*Dirac(x4-y2)*Int(Int(f(x1,x2),
x1 = -infinity..infinity),x2 = -infinity..infinity)
+f(x3,x4))*exp(Int(Int(f(x1,x2)*f(x3,x4),x1 = -infinity..infinity),
x2 = -infinity..infinity))));

# Example 11)
'fdiff'(exp(Int4c(f(x1,x2)*f(x3,x4),x1,x2,x3,x4)),f(y1,y2)):
TEST("-((Int(Int(f(x1,x2),x1 = -infinity..infinity),x2 = -infinity..infinity)
+Int(Int(f(x3,x4),x3 = -infinity..infinity),x4 = -infinity..infinity))
*exp(Int(Int(Int(Int(f(x1,x2)*f(x3,x4),x1 = -infinity..infinity),
x2 = -infinity..infinity),x3 = -infinity..infinity),x4 = -infinity..infinity))));

# Example 12)
'fdiff'(f(x3,x4)*exp(Int2c(f(x1,x2)*f(x3,x4),x1,x2)),f(y1,y2)):
TEST("-(Dirac(x3-y1)*Dirac(x4-y2)*exp(f(x3,x4)*Int(Int(f(x1,x2),
x1 = -infinity..infinity),x2 = -infinity..infinity))
+f(x3,x4)*(Dirac(x3-y1)*Dirac(x4-y2)*Int(Int(f(x1,x2),x1 = -infinity..infinity),
x2 = -infinity..infinity)+f(x3,x4))*exp(Int(Int(f(x1,x2)*f(x3,x4),
x1 = -infinity..infinity),x2 = -infinity..infinity))));

# Example 13)
'fdiff'(Int2c(f(x3,x4)*exp(Int2c(f(x1,x2)*G(x1,x2)*f(x3,x4),x1,x2)),x3,x4),
        f(y1,y2)):
TEST("-(exp(f(y1,y2)*Int(Int(f(x1,x2)*G(x1,x2),x1 = -infinity..infinity),
x2 = -infinity..infinity))+Int(Int(f(x1,x2)*G(x1,x2),x1 = -infinity..infinity),
x2 = -infinity..infinity)*f(y1,y2)*exp(Int(Int(f(x1,x2)*G(x1,x2)*f(y1,y2),
x1 = -infinity..infinity),x2 = -infinity..infinity))
+G(y1,y2)*Int(Int(f(x3,x4)^2*exp(Int(Int(f(x1,x2)*G(x1,x2)*f(x3,x4),
x1 = -infinity..infinity),x2 = -infinity..infinity)),x3 = -infinity..infinity),
x4 = -infinity..infinity)));

# Example 14)
'fdiff'(Int2c(f(x3,x4)*exp(Int2c(f(x1,x2)*G(x1,x2,x3,x4),x1,x2)),x3,x4),
        f(y1,y2)):
TEST("-(exp(Int(Int(f(x1,x2)*G(x1,x2,y1,y2),x1 = -infinity..infinity),
x2 = -infinity..infinity))
+Int(Int(f(x3,x4)*G(y1,y2,x3,x4)*exp(Int(Int(f(x1,x2)*G(x1,x2,x3,x4),
x1 = -infinity..infinity),x2 = -infinity..infinity)),x3 = -infinity..infinity),
x4 = -infinity..infinity)));

TOTNUMBER := TOTNUMBER + NUMBER:
#####################################################################
#
# 5) Command: odiff
#

print(_______________________________________________________________):
print(`Testing procedure odiff.`):
print(_______________________________________________________________):

NUMBER := 0:

# Example 1)
odiff(diff(f(u,v),u$2,v$3)):
TEST("-(5));

# Example 2)
odiff(diff(f(u,v),u$2,v$3),u):
TEST("-(2));

# Example 3)
odiff(diff(f(u,v),u$2,v$3),v):
TEST("-(3));

# Example 4)
odiff(D[1,2,2,3,3,3](f)(x,y,z)):
TEST("-(6));

# Example 5)
odiff(D[1,2,2,3,3,3](f)(x,y,z),x):
TEST("-(1));

# Example 6)
odiff(D[1,2,2,3,3,3](f)(x,y,z),y):
TEST("-(2));

# Example 7)
odiff(D[1,2,2,3,3,3](f)(x,y,z),z):
TEST("-(3));

# Example 8)
odiff(g(x)):
TEST("-(0));

# Example 9
odiff(h(t)*diff(f(x,y,z),x$2,z$3)+h(x,y,z)*Diff(D[2,2,2,2](j)(x,y,z),x),x):
TEST("-(2));

# Example 10)
odiff(h(t)*diff(f(x,y,z),x$2,z$3)+h(x,y,z)*Diff(D[2,2,2,2](j)(x,y,z),x),y):
TEST("-(4));

# Example 11)
odiff(h(t)*diff(f(x,y,z),x$2,z$3)+h(x,y,z)*Diff(D[2,2,2,2](j)(x,y,z),x),z):
TEST("-(3));

# Example 12)
odiff(h(t)*diff(f(x,y,z),x$2,z$3)+h(x,y,z)*Diff(D[2,2,2,2](j)(x,y,z),x),t):
TEST("-(0));

# Example 13)
odiff(h(t)*diff(f(x,y,z),x$2,z$3)+h(x,y,z)*Diff(D[2,2,2,2](j)(x,y,z),x),k):
TEST("-(0));

# Example 14)
odiff(diff(f(x),x$n)):
TEST("-(n));

# Example 15)
odiff(diff(f(x),x$n),x):
TEST("-(n));

TOTNUMBER := TOTNUMBER + NUMBER:
#####################################################################
#
# 6) Command: parameters
#

print(_______________________________________________________________):
print(`Testing procedure parameters.`):
print(_______________________________________________________________):

NUMBER := 0:

# Example 1)
parameters(k):
TEST(op(")- k);

# Example 2)
parameters():
TEST(op(")- k);

# Example 3)
(k*x)(t):
TEST("-(k*x(t)));

# Example 4)
k := 'k':
(k*x)(t):
TEST("-(k(t)*x(t)));

# Example 5)
parameters():
TEST(nops("));

TOTNUMBER := TOTNUMBER + NUMBER:
#####################################################################
#
# 7) Command: pdiff
#

print(_______________________________________________________________):
print(`Testing procedure pdiff.`):
print(_______________________________________________________________):

NUMBER := 0:

# Example 1)
pdiff(cos(q(t)),q(t)):
TEST("-(-sin(q(t))));

# Example 2)
pdiff(diff(q(t),t)^(1/2),D(q)(t)):
TEST("-(1/2/diff(q(t),t)^(1/2)));

# Example 3)
pdiff(diff(q(t),t)^(1/2)+D(q)(t)^3,diff(q(t),t)):
TEST("-(1/2/(D(q))(t)^(1/2)+3*(D(q))(t)^2));

# Example 4)
alias(Q=(q(t),diff(q(t),t),t)):     # defines a general functionality
pdiff(L(Q),t):                      # The total derivative:
TEST("-(D[1](L)(Q)*diff(q(t),t)+D[2](L)(Q)*diff(diff(q(t),t),t)+D[3](L)(Q)));

# Example 5)
p1 := pdiff(L(Q),q(t)):
TEST("-(D[1](L)(Q)));

# Example 6)
p2 := pdiff(L(Q),D(q)(t)):
TEST("-(D[2](L)(Q)));

# Example 7)
p3 := pdiff(L(Q),t,{q(t)}):
TEST("-(D[3](L)(Q)));

# Example 8)
L(Q) := 1/2*diff(q(t),t)^2-1/2*k * q(t)^2 - cos(w*t): # Assigning a value
usepdiff(p1):
TEST("-(-k*q(t)));

# Example 9)
usepdiff(p2):
TEST("-('diff'(q(t),t)));

# Example 10
usepdiff(p3):
TEST("-(sin(w*t)*w));

#
# Unassignment of draft variables:
#
    alias(Q=Q):
    L := 'L':
    p1 := 'p1':
    p2 := 'p2':
    p3 := 'p3':
#

# Example 11)
pdiff(g(x)*diff(f(x),x),x,{diff(g(x),x),D(f)(x)}):
TEST("-(0));

# Example 12)
pdiff(g(x)*diff(f(x),x),x,{D(f)(x)}):
TEST("-('diff'(g(x),x)*'diff'(f(x),x)));

# Example 13)
pdiff(g(x)*diff(f(x),x),x,{diff(g(x),x)}):
TEST("-(g(x)*'diff'('diff'(f(x),x),x)));

# Example 14)
pdiff(g(f(x))*f(x),f(x),{g(f(x))}):
TEST("-(g(f(x))));

# Example 15)
pdiff(g(h(x),f(x))*f(x),x,{D(f)(x)}):
TEST("-(D[1](g)(h(x),f(x))*'diff'(h(x),x)*f(x)));

# Example 16)
pdiff(g(f(x))*f(x),f(x)):
TEST("-(D(g)(f(x))*f(x)+g(f(x))));

# Example 17)
pdiff(Int(f(x),x=1..h(y)*f(x)),x,{f(x)}):
TEST("-('pdiff'(Int(f(x),x = 1..h(y)*f(x)),x,{f(x)})));

# Example 18)
pdiff(Int(f(x),x=1..h(y)*f(x)),f(x)):
TEST("-(f(h(y)*f(x))*h(y)));

# Example 19)
pdiff(Int(f(x),x=1..h(x)*x),x,{f(x)}):
TEST("-('pdiff'(Int(f(x),x = 1..h(x)*x),x,{f(x)})));

# Example 20)
pdiff(int(f(x),x=1..h(x)*f(x)),x,{f(x)}):
TEST("-('pdiff'('int'(f(x),x = 1..h(x)*f(x)),x,{f(x)})));

# Example 21)
pdiff(int(f(x),x),x):
TEST("-(f(x)));

# Example 22)
pdiff(int(f(x),x),x,{f(x)}):
TEST("-('pdiff'('int'(f(x),x),x,{f(x)})));

# Example 23)
pdiff(int(cos(x),x),x,{f(x)}):
TEST("-(cos(x))):

# Example 24)
pdiff(Int(diff(f(x),x),x),x,{f(x)}):
TEST("-('pdiff'('Int'('diff'(f(x),x),x),x,{f(x)})));

# Example 25)
Value(pdiff(Int(diff(f(x),x),x),x,{f(x)})):
TEST("-(0));

# Example 26)
pdiff(Int(D(f)(x),x),x,{f(x)}):
TEST("-('pdiff'(Int(D(f)(x),x),x,{f(x)})));

# Example 27)
pdiff(Int(D(f)(x),x),x,{D(f)(x)}):
TEST("-('pdiff'(Int((D(f))(x),x),x,{f(x)})));

# Example 28)
pdiff(Int(f(x),x),x,{f(x),f(y)}):
TEST("-('pdiff'(Int(f(x),x),x,{f(x)})));

# Example 29)
pdiff(int(f(x)*x,x),x):
TEST("-(f(x)*x));

# Example 30)
pdiff(int(f(x)*x,x),x,{f(x)}):
TEST("-('pdiff'('int'(f(x)*x,x),x,{f(x)})));

# Example 31)
pdiff(Int(f(x),x),f(x),{g(x)}):
TEST("-('pdiff'(Int(f(x),x),f(x))));

# Example 32)
pdiff(Int(g(f(x))*f(x),x=1..f(x)),f(x),{g(f(x))}):
TEST("-('pdiff'(Int(g(f(x))*f(x),x = 1..f(x)),f(x),{g(f(x))})));

# Example 33)
pdiff(Int(g(f(x))*f(x),x=1..f(x)),f(x)):
TEST("-(g(f(f(x)))*f(f(x))));

# Example 34)
pdiff(int(g(h(x))*h(x),x=1..diff(g(f(x)),x)),f(x)):
TEST("-('pdiff'('int'(g(h(x))*h(x),x = 1..(D(g))(f(x))*diff(f(x),x)),f(x))));

# Example 35)
pdiff(Int(G(f(z,y),z),z),f(x,y)):
TEST("-(0));

# Example 36)
pdiff(int(g(f(x))*f(x),x=1..2),f(x)):
TEST("-(0));

# Example 37)
pdiff(Int(h(g(x))*f(x)*cos(y),x)*g(x),g(x),{h(g(x))}):
TEST("-(cos(y)*'pdiff'(Int(h(g(x))*f(x),x),g(x),{h(g(x))})*g(x)
        +cos(y)*Int(h(g(x))*f(x),x)));

# Example 38)
pdiff(f(x*g(x)),x):
TEST("-(D(f)(x*g(x))*(g(x)+x*'diff'(g(x),x))));

# Example 39)
pdiff(f(x*g(x)),x,{g(x)}):
TEST("-(D(f)(x*g(x))*g(x)));

# Example 40
pdiff(diff(f(x),x)*int(g(x)*cos(x),x),x):
TEST("-(diff(diff(f(x),x),x)*int(g(x)*cos(x),x)+diff(f(x),x)*g(x)*cos(x)));

# Example 41)
pdiff(diff(f(x),x)*int(g(x)*cos(x),x),x,{g(x)}):
TEST("-('diff'(diff(f(x),x),x)*int(g(x)*cos(x),x)+'diff'(f(x),x)
        *'pdiff'('int'(g(x)*cos(x),x),x,{g(x)})));

# Example 42)
pdiff(diff(f(x),x)*int(g(x)*cos(x),x),x,{f(x)}):
TEST("-('diff'(f(x),x)*'pdiff'('int'(g(x)*cos(x),x),x,{f(x)})));

# Example 43)
pdiff(g(x)*Int(f(x),x=a(x)..b(x)),x,{f(x)}):
TEST("-('diff'(g(x),x)*Int(f(x),x=a(x)..b(x))
        +g(x)*'pdiff'(Int(f(x),x=a(x)..b(x)),x,{f(x)})));

# Example 44)
pdiff(Int(G(f(x,y),z),z),f(x,y)):
TEST("-(Int(D[1](G)(f(x,y),z),z)));

# Example 45)
pdiff(Int(G(h(x),z),x=f(x,y)..g(u)),f(x,y)):
TEST("-(-G(h(f(x,y)),z)));

# Example 46)
pdiff(Int(G(k(x,y),z)*h(x,z)/g(y,z),z),f(x,y)):
TEST("-('pdiff'(Int(G(k(x,y),z)*h(x,z)/g(y,z),z),f(x,y))));

TOTNUMBER := TOTNUMBER + NUMBER:
#####################################################################
#
# 8) Command: seldiff
#

print(_______________________________________________________________):
print(`Testing procedure seldiff.`):
print(_______________________________________________________________):

NUMBER := 0:

# Example 1)
draft :=h(t)*diff(f(x,y,z),x,z$3)+h(t)*Diff(D[2,2,2,2](j)(x,y,z),x)
        +diff(f(t),t):
seldiff(draft,1):
TEST("-(diff(f(t),t)));

# Example 2)
seldiff(draft,2,x):
TEST("-(0));

# Example 3)
seldiff(draft,4,y):
TEST("-(h(t)*diff(((D[2,2,2,2])(j))(x,y,z),x)));

# Example 4)
seldiff(draft,1,x):
TEST("-(h(t)*diff(f(x,y,z),z,z,z,x)+h(t)*diff((D[2,2,2,2](j))(x,y,z),x)));

# Example 5)
seldiff(draft,3,z):
TEST("-(h(t)*diff(f(x,y,z),z,z,z,x)));

# Example 6)
seldiff(draft,4):
TEST("-(h(t)*diff(f(x,y,z),z,z,z,x)));

# Example 7)
draft := diff(f(x,y,z),x$3,y$2,z$4)=h(t)*diff(f(x,y,z),x,z$3)+h(t)
         *Diff(D[2,2,2,2](j)(x,y,z),x)+diff(f(t),t):
seldiff(draft,4,z):
"-(diff(f(x,y,z),y$2,z$4,x$3) = 0):
TEST(lhs(")+rhs("));

# Example 8)
seldiff(draft,2,y):
"-(diff(f(x,y,z),y$2,z$4,x$3) = 0):
TEST(lhs(")+rhs("));

TOTNUMBER := TOTNUMBER + NUMBER:
#####################################################################
#
# 9) Command: useD and usediff
#

print(_______________________________________________________________):
print(`Testing procedures useD and usediff.`):
print(_______________________________________________________________):

NUMBER := 0:

# Example 1)
useD(diff(f(x,y,z),z,y$2,z$3)):
TEST("-(((D[2,2,3,3,3,3])(f))(x,y,z)));

# Example 2)
usediff(useD(diff(f(x,y,z),z,y$2,z$3))):
TEST("-(diff(f(x,y,z),z,y$2,z$3)));

# Example 3)
useD(L(diff(f(t),t))):
TEST("-(L((D(f))(t))));

# Example 4)
usediff(useD(L(diff(f(t),t)))):
TEST("-(L(diff(f(t),t))));

# Example 5)
usediff(D(f)):
TEST("-(D(f)));

# Example 6)
useD(diff(f(x),x)=D(f)(x)):
"-((D(f))(x) = (D(f))(x)):
TEST(lhs(")+rhs("));

# Example 7)
usediff(diff(f(x),x)=D(f)(x)):
"-(diff(f(x),x) = diff(f(x),x)):
TEST(lhs(")+rhs("));

# Example 8)
useD(diff(f(x),y$n)=0):
TEST(lhs(")+rhs("));

# Example 9)
useD(diff(f(x),x$n)=`@@`(D,n)(f)(x)):
"-(((`@@`(D,n))(f))(x) = ((`@@`(D,n))(f))(x)):
TEST(lhs(")+rhs("));

# Example 10
usediff(((`@@`(D,n))(f))(x) = ((`@@`(D,n))(f))(x)):
"-(diff(f(x),$(x,n)) = diff(f(x),$(x,n))):
TEST(lhs(")+rhs("));

# Example 11)
useD(diff(f(x,y,z),x$n)=D[1$n](f)(x,y,z)):
"-(((D[$(1,n)])(f))(x,y,z) = ((D[$(1,n)])(f))(x,y,z)):
TEST(lhs(")+rhs("));

# Example 12)
usediff(((D[$(1,n)])(f))(x,y,z) = ((D[$(1,n)])(f))(x,y,z)):
"-(diff(f(x,y,z),$(x,n)) = diff(f(x,y,z),$(x,n))):
TEST(lhs(")+rhs("));

# Example 13)
usediff(D[x$n](f)(x,y,z)):
TEST("-(D[x$n](f)(x,y,z)));

# Example 14)
useD(g(h((D(g))(x)*diff(f(x),x)))*h((D(g))(x)*diff(f(x),x))*diff((D(g))(x),x)
*diff(f(x),x)):
TEST("-(g(h(D(g)(x)*D(f)(x)))*h(D(g)(x)*D(f)(x))*(`@@`(D,2)(g))(x)*D(f)(x)));

# Example 15)
usediff(g(h((D(g))(x)*diff(f(x),x)))*h((D(g))(x)*diff(f(x),x))
*diff((D(g))(x),x)*diff(f(x),x)):
TEST("-(g(h(diff(g(x),x)*diff(f(x),x)))*h(diff(g(x),x)*diff(f(x),x))
        *diff(g(x),x,x)*diff(f(x),x)));

TOTNUMBER := TOTNUMBER + NUMBER:
#####################################################################
#
# 11) Command: usepdiff
#

print(_______________________________________________________________):
print(`Testing procedure usepdiff.`):
print(_______________________________________________________________):

NUMBER := 0:

# Example 1).  Includes assignment of L
L(q(t),D(q)(t)):= cos(omega*diff(q(t),t)^(1/2))*q(t):
usepdiff(D[2](L)(q(t),D(q)(t))):
TEST("-(-1/2*sin(omega*diff(q(t),t)^(1/2))*omega/'diff'(q(t),t)^(1/2)*q(t)));

# Example 2)
usepdiff(D[2](L)(q(t),diff(q(t),t))):
TEST("-(D[2](L)(q(t),diff(q(t),t))));

# Example 3)
usepdiff(D[1,2](L)(q(t),D(q)(t))):
TEST("-(-1/2*sin(omega*diff(q(t),t)^(1/2))*omega/'diff'(q(t),t)^(1/2)));

# Example 4)
usepdiff(D[1$n](L)(q(t),D(q)(t))):
TEST("-('pdiff'(cos(omega*diff(q(t),t)^(1/2))*q(t),$(q(t),n))));

# Example 5)
usepdiff(D[1$n,2$m](L)(q(t),D(q)(t))):
" - pdiff(pdiff(cos(omega*diff(q(t),t)^(1/2))*q(t),$(q(t),n)),$((D(q))(t),m)):
if "<>0 then
""-(pdiff(pdiff(cos(omega*diff(q(t),t)^(1/2))*q(t),$((D(q))(t),m)),$(q(t),n))):
fi:
TEST(");

# Example 6)
usepdiff(D[x$n](L)(q(t),D(q)(t))):
TEST("-(D[x$n](L)(q(t),D(q)(t))));

# Example 7)
traperror(usepdiff(D[3](L)(q(t),D(q)(t)))):
if lasterror <> `Function L can take no more than 2 arguments`
then FAIL fi;

# Unassigning L
L := 'L':

# Example 8)
F(x(t)) := cos(x(t)^2):
usepdiff(D(F)(x(t))):
TEST("-(-2*sin(x(t)^2)*x(t)));

# Example 9)
usepdiff(`@@`(D,3)(F)(x(t))):
TEST("-(8*sin(x(t)^2)*x(t)^3-12*cos(x(t)^2)*x(t)));

# Unassigning F
F := 'F':

TOTNUMBER := TOTNUMBER + NUMBER:
#####################################################################
# Timing:

print(_______________________________________________________________):
print(cat(`Total number of examples: `,TOTNUMBER));
print(cat(`Time consumed: `,time()-TIME0));
print(
`Time consumed by a 486 DX-33 for processing this test:  around 60 seconds.`);
TOTNUMBER := 'TOTNUMBER':  NUMBER := 'NUMBER':
#####################################################################

#quit

