#
# Produce the list of minimum-length coset representatives for a parabolic
# subgroup of a Weyl group. 
#
#   coset_reps(J,R);  (R = a crystallographic root system)
#   coset_reps(J,S);  (S = a list of base vectors)
#
# In both forms, J should be a list or subset of {1,...,n}, taken as an index
# set for the reflections generating the parabolic subgroup. The output is a
# list of left-coset representatives, where 'left' means xG, not Gx.
#  
with(weyl,weights);
#
coset_reps:=proc(J,R) local S,i,v0,v,res,w,Wt;
  if type(args[2],'list') then S:=R else S:=coxeter['base'](R) fi;
  Wt:=weyl['weights'](S); [seq(Wt[i],i={$1..nops(S)} minus {op(J)})];
  v0:=convert(",`+`); res:=[];
  for v in coxeter['orbit'](v0,S) do;
    coxeter['vec2fc'](v,S,'w'); res:=[op(res),w];
  od;
  res;
end;
#
# Produce the length generating function for the minimal coset rep's.
# 
#    coset_gf(J,R); 
#    coset_gf(J,R,z);
#
#  J,R = as above; z = variable for the generating function (default=q).
#
coset_gf:=proc(J,R) local i,S,R0,z;
  if type(args[2],'list') then S:=R else S:=coxeter['base'](R) fi;
  R0:=coxeter['name_of']([seq(S[i],i=J)]);
  normal(coxeter['length_gf'](R,z)/coxeter['length_gf'](R0,z));
  if nargs=3 then subs(z=args[3],") else subs(z=q,") fi;
end;
#
