#
## <SHAREFILE=program/lambda/lambda.mpl >
## <DESCRIBE>
##                The lambda function from lambda calculus.  Takes as input a
##                Maple expression and outputs a Maple function.  For example
##
##                > f := int( ln(a*x)*x, x ):
##                > lambda(x,f);
##
##                                    x -> ln(u x) x - x
##
##                AUTHOR: Michael Monagan, monagan@inf.ethz.ch
## </DESCRIBE>

# The implementation produces funny looking subs calls in the resulting
# procedures.  These substitutions are implementing nested lexical
# scoping rules which Maple does not have.  Just ignore them.
#
# Author: MBM Nov/90
#

macro( GENSYM = readlib(`tools/gensym`) );

lambda := proc()
local f, x, n, i, t, X, Y, Yp;

f := args[nargs];
if nargs = 1 then RETURN(eval(f,1)) fi;

x := args[1];
if type(x,name) then x := [x] elif type(x,set) then x := [op(x)] fi;

if not type(x,list(name)) or nops(x) <> nops({op(x)}) then
	ERROR(`variables must be unique and of type name`) fi;

if not type(x,list(string)) then
	n := nops(x);
	X := [seq( GENSYM( cat('x',``.i) ), i=1..n )];
	RETURN( lambda( X, args[2..nargs-1],
		subs( [seq( x[i]=X[i], i=1..n )], eval(f,1) ) ) )
fi;

if nargs > 2 then f := lambda( args[2..nargs-1], eval(f,1) ) fi;

if has(eval(f,1), x) and hastype(eval(f,1),procedure) then
	Y := {seq( t = GENSYM(t), t=x )};
	Yp := {seq( rhs(t)=lhs(t), t=Y )};
	f := subs(Y, eval(f,1) );
	subs( {_PARMS=op(x),_SUBS=Yp,_BODY=eval(f,1)},
		_PARMS -> subs(_SUBS,_BODY) )
else subs( {_BODY=eval(f,1),_PARMS=op(x)}, _PARMS -> _BODY )
fi

end:

macro(GENSYM = GENSYM);

#save `lambda.m`;
#quit
