#
## <SHAREFILE=algebra/subres/subres.mpl >
## <DESCRIBE>
##                Given two polynomials a and b in x the function subres(a,b,x)
##               computes the subresultant polynomial remainder sequence.
##                AUTHOR: George Labahn, glabahn@daisy.waterloo.edu
## </DESCRIBE>

#
#--> subres(a,b,x)
#
#  Input :   a,b: two multivariate polynomial with algebraic number
#                 coefficients -- rationals, RootOf's or radicals,
#              x: a variable,
#
#  Output:      : returns the subresultant sequence,
#		a sequence of polynomials in decreasing degree in x
#
#  Reference:	"Algorithms for Computer Algebra"
#		Geddes K. O, Labahn G., Czapor S.
#
#		"Computer Algebra"
#		J. Davenport, E. Tournier
#
#  G. Labahn and M. Monagan July 1991.
#


subres := proc(a,b,x) local t,S;
option `Copyright 1991 by the University of Waterloo`;

    if not type(x,name) then ERROR(`3rd argument must be a name`) fi;
    if not type(a,'polynom(anything,x)') or not type(b,polynom(anything,x)) then
	ERROR(`1st and 2nd arguments must be polynomials in `,x) fi;

if printlevel > 1 then
lprint(`subres: starting a subresultant computation at time`,time()) fi;

    if   type(a,'polynom(rational)') and 
         type(b,'polynom(rational)') then S := `subres/rational`(a,b,x);

    elif type(a,'polynom(algnum)') and
         type(b,'polynom(algnum)') then S := `subres/algnum`(a,b,x);

    elif type(a,'polynom(radnum)') and
         type(b,'polynom(radnum)') then
	 S := [`subres/algnum`(convert(a,RootOf), convert(b,RootOf), x)];
	 S := seq( convert(t,radical), t=S );

    else ERROR(`1st and 2nd arguments must multivariate polynomials`.
		`whose coefficients are rationals or algebraic numbers`);
    fi;

if printlevel > 1 then
lprint(`subres: finishing a subresultant computation at time`,time()) fi;

    S;

end:


`subres/rational` := proc(a,b,x)
local c,d,j,u,v,r,g,h,du,ddu,dv,ddv,S,s,t;

	u := expand(a);
	v := expand(b);


        if degree(u,x) < degree(v,x) then
	   t := u; u := v; v := t; s := (-1)^(degree(u,x)*degree(v,x));
        else
	   s := 1;
        fi;


	du := degree(u,x);
	dv := degree(v,x);

if printlevel > 2 then
lprint(`subres: degrees of input polynomials`,du,dv) fi;

	S := collect(u,x);
	ddu := du; ddv := dv;
	if u = 0 or v = 0 then RETURN(S) fi;
	if du = 0 and dv = 0 then RETURN(1) fi;
	if dv = 0 then RETURN(u,v,expand(v^du)) fi;

	c := 1;  g := 1;  h := 1;
	while dv > 0 do
		d := du-dv;
		c := c*(-1)^(du*dv);
		r := prem(u,v,x);
		u := v; v := r; du := dv; dv := degree(r,x);
		j := degree(u,x);
                S := S, collect(s^((ddu-j)*(ddv-j))*u,x);

if printlevel > 2 then
lprint(`subres: degree of pseudo remainder`,degree(u,x)) fi;

		divide(v,g*h^d,'v');
		g := coeff(u,x,du);
		if d = 1 then h := g else divide(g^d,h^(d-1),'h') fi;
	od;
	if du = 1 then RETURN( S, expand(s^(ddu*ddv)*c*v) ) fi;
	divide(v,h,'r');
	S, expand(s^(ddu*ddv)*c*v*r^(du-1));

end:

`subres/algnum` := subs( [divide=evala@Divide,
			 prem=evala@Prem,
			 expand=evala@Expand], " ):
#save `subres.m`;
#quit
