#
## <SHAREFILE=linalg/pascal/pascal.mpl >
## <DESCRIBE>
##                Create an n by n Pascal matrix.
##                A family of matrices with nice properties -- real
##                eigenvalues, determinant = 1.
##                AUTHOR: Michael Monagan, monagan@inf.ethz.ch
## </DESCRIBE>

#--> pascal(n:posint) -- an n by n Pascal matrix
#
# Creates an n by n or n Pascal matrix constructed as follows:
# First set A[1,i] = A[i,1] = x
# Now set A[i,j] = A[i-1,j] + A[i,j-1] for i=2..n, j=1..n
#
# The matrices pascal(n) have many nice properties.
# The determinant = 1 hence the inverse is over Z.
# The matrix is strongly positive definite meaning all minors
# are positive definite.
#
# Author MBM Nov/92
#

pascal := proc(n)
local A,i,j;
    A := array(1..n,1..n);
    for i to n do A[1,i] := 1; A[i,1] := 1 od;
    for i from 2 to n do
        for j from 2 to n do
            A[i,j] := A[i,j-1] + A[i-1,j]
        od;
    od;
    eval(A)
end:

`help/text/pascal` := TEXT(
`FUNCTION: pascal - create a Pascal matrix`,
`      `,
`CALLING SEQUENCE:`,
`   pascal(n)`,
`      `,
`PARAMETERS:`,
`   n - a positive integer`,
`      `,
`SYNOPSIS:   `,
`- The procedure pascal(n) constructs an n by n Pascal matrix.`,
`  A Pascal matrix is defined as follows`,
`   `,
`	A[1,i] = A[i,1] = 1 for i = 1..n`,
`	A[i,j] = A[i-1,j] + A[i,j-1] otherwise`,
`   `,
`- The resulting symmetric matrix has many nice properties and`,
`  interesting factorizations.  The determinant of pascal(n) = 1`,
`  hence the inverse is also a matrix of integers.  The`,
`  eigenvalues are all real and positive etc. etc.`,
`      `,
`EXAMPLES:   `,
`> pascal(5);`,
`   `,
`                              [ 1  1   1   1   1 ]`,
`                              [                  ]`,
`                              [ 1  2   3   4   5 ]`,
`                              [                  ]`,
`                              [ 1  3   6  10  15 ]`,
`                              [                  ]`,
`                              [ 1  4  10  20  35 ]`,
`                              [                  ]`,
`                              [ 1  5  15  35  70 ]`
):

#save `pascal.m`;
#quit
