with(share): readshare(pof, science): # read `pof.m`:
macro(monopoly=`pof/monopoly`):
macro(t_evo=`pof/t_evo`):
macro(pof_norm=`pof/pof_norm`):
macro(SQjump=`pof/SQjump`):
macro(preQF=`pof/preQF`):
macro(doQF=`pof/doQF`):
macro(CFT=`pof/CFT`):
macro(MonCFT=`pof/MonCFT`):
macro(Cos_FT=`pof/Cos_FT`):
macro(MonCosFT=`pof/MonCosFT`):
macro(combi=`pof/combi`):
macro(MonoPreFT=`pof/MonoPreFT`):
macro(do_ph_cor=`pof/do_ph_cor`):
macro(getW=`pof/getW`):
macro(plotsub=`pof/plotsub`):
macro(monosuper=`pof/monosuper`):

equal:=proc(a,b)
 if(a=b) then print(okay)
 else
   print(cat(`result `,a,` should be `,b,` in procedure `.fname)):
   assign('err',err+1):
 fi
end:

first:=proc(a) global err,fname; err := 0; fname := a; end:

last:=proc() if(err<>0) then print(`ERROR(S) in `.fname) fi end:

NEXT:=proc(a) last(); first(a); end:


f:=(s) -> 1:
first(`monopoly`):
equal(monopoly(f,A*B+C*D),2):
equal(monopoly(f,A*B+C*D+Q),3):
equal(monopoly(f,A*B*C),1):

NEXT(`nmrsubs`):
equal(nmrsubs(J[A,B]=0,Sin(Pi*J[A,B]*t1)),0):
equal(nmrsubs(J[A,B]=1/t,Ix[A]*Cos(Pi*J[A,B]*t)),-Ix[A]):

NEXT(`spinsystem`):
equal(spinsystem([[A,A2],B]),Iz[A]+Iz[A2]+Iz[B]):
equal(symmetric,op(1,op(J))):
equal(J[A,A2],0):
equal(W[A],W[A2]):
equal(J[A,B],J[A2,B]):
equal(T,[A,A2,B]):

NEXT(`xpulse`):
equal(xpulse(Ix[A]+Iz[B],{A},Pi/2),Ix[A]+Iz[B]):
equal(xpulse(Iz[A]+Iy[B],{A,B},Pi),-Iz[A]-Iy[B]):
equal(xpulse(Iz[A]+Iz[B],{A,B},Pi/2),-Iy[A]-Iy[B]):

NEXT('ypulse'):
equal(ypulse(Ix[A]+Iz[B],{A},Pi/2),-Iz[A]+Iz[B]):
equal(ypulse(Iz[A]+Iy[B],{A,B},Pi),-Iz[A]+Iy[B]):
equal(ypulse(Ix[A]+Ix[B],[A],Pi),-Ix[A]+Ix[B]):

NEXT('zpulse'):
equal(zpulse(Ix[A]+Iz[B],{A},Pi/2),Iy[A]+Iz[B]):
equal(zpulse(Iz[A]+Iy[B],{A,B},Pi),Iz[A]-Iy[B]):
equal(zpulse(Ix[A]+Iy[B],{B},Pi),Ix[A]-Iy[B]):

NEXT(`pulse`):
equal(pulse(Ix[A]+Iy[B]+Iz[C],{A,B,C},Pi/2,Pi/2),
        ypulse(Ix[A]+Iy[B]+Iz[C],{A,B,C},Pi/2)):
equal(pulse(Ix[A]+Iy[B]+Iz[C],{A,B,C},0,Pi/2),
        xpulse(Ix[A]+Iy[B]+Iz[C],{A,B,C},Pi/2)):
equal(pulse(Ix[A],{A},Pi/3,Pi/4),pulse(Ix[A],{A},[Pi/2,Pi/3],Pi/4)):
equal(pulse(Iz[A],{A},Pi/2,Pi/2),Ix[A]):
equal(pulse(Iz[A],{A},-Pi/2,Pi/2),-Ix[A]):
equal(pulse(Iz[A],{A},[Pi/2,-Pi/2],Pi/2),-Ix[A]):
equal(pulse(spinsystem([A,B]),{},Pi/2,Pi/2),Ix[A]+Ix[B]):

NEXT(`shift`):
Trig:=proc(a) subs(sin=Sin,cos=Cos,a) end:
equal(shift(Ix[A]+Iz[B],{A},t),
        Trig(zpulse(Ix[A]+Iz[B],{A},2*Pi*W[A]*t)-Iz[B])):
T:=[A,B]:
  equal(shift(Ix[A],T,t),
        Trig(zpulse(Ix[A],T,2*Pi*W[A]*t))):
s:=2*Pi*W[A]*t1:
equal(shift(Ix[A]+Iy[B],[A],t1),Ix[A]*Cos(s)+Iy[A]*Sin(s)):
T:='A': equal(shift(Ix[A],{},t1),Ix[A]*Cos(s)+Iy[A]*Sin(s)):

NEXT(`couple`):
T:=[A,B,C]:
r:=Cos(Pi*J[A,B]*t)*Ix[A]*Cos(Pi*J[C,A]*t)
        + 2*Cos(Pi*J[A,B]*t)*Iy[A]*Iz[C]*Sin(Pi*J[C,A]*t)
        + 2*Iz[B]*Sin(Pi*J[A,B]*t)*Iy[A]*Cos(Pi*J[C,A]*t)
        - 4*Iz[B]*Sin(Pi*J[A,B]*t)*Ix[A]*Iz[C]*Sin(Pi*J[C,A]*t):
equal(r,couple(Ix[A],t)):
j:=Pi*J[A,X]*t1:
equal(couple(xpulse(spinsystem([A,X]),{A},Pi/2),t1),
        -Iy[A]*Cos(j)+2*Ix[A]*Iz[X]*Sin(j)+Iz[X]):

NEXT(`evolve`):
spinsystem([A,X]):r:xpulse(",{A},Pi/2):
equal(evolve(r,{},t),couple(shift(r,{},t),t)):
equal(evolve(r,{},t),shift(couple(r,t),{},t)):

NEXT(`t_evo`):
equal(monopoly(t_evo,Ix[A]+Iy[B]+Iz[C]+Ix[A]*Iy[B]+Iy[D]*Iz[A]),
       Ix[A]+Iy[B]+Iy[D]*Iz[A]):

NEXT(`observe`):
T:=[A,B]: s:=2*Pi*W[A]*t: j:=Pi*J[A,B]*t:
equal(observe(Ix[A]+Iy[B],{A},t,0),expand(Cos(j)/2*(Cos(s)+I*Sin(s)))):
equal(observe(Ix[A],{A},t,Pi/2),expand(Cos(j)/2*(-I*Cos(s)+Sin(s)))):
equal(observe(Ix[A]+Iy[B],{A,B},t,Pi/2),
        -observe(Ix[A]+Iy[B],{A,B},t,-Pi/2)):
s:=2*Pi*W[A]*t:j:=Pi*J[A,X]*t:
xpulse(spinsystem([A,X]),{A},Pi/2): observe(",{A},t,0):
equal(",expand(Cos(j)/2*(Sin(s)-I*Cos(s)))):

NEXT(`cleanup`):
equal(cleanup(Iz[A]^5),1/16*Iz[A]):
equal(cleanup(Cos(2*x)*Sin(x)),Sin(3*x)/2-Sin(x)/2):
equal(cleanup(Cos(5*x)*Cos(x)),Cos(6*x)/2+Cos(4*x)/2):
equal(cleanup(Sin(5*x)*Sin(x)),Cos(4*x)/2-Cos(6*x)/2):
equal(cleanup(Sin(3)),sin(3)):
equal(cleanup(Sin(x)^3),3*Sin(x)/4-Sin(3*x)/4):
equal(cleanup(Cos(Pi/2)),0):

NEXT(`pm_xy`):
T:=[A]:
equal(pm_xy(Ip[A]),Ix[A]+I*Iy[A]):
equal(pm_xy(Im[A]),Ix[A]-I*Iy[A]):

NEXT(`xy_pm`):
T:=[A]:
equal(xy_pm(Ix[A]),Ip[A]/2+Im[A]/2):
equal(xy_pm(Iy[A]),-I*Ip[A]/2+I*Im[A]/2):
equal(xy_pm(Iz[A]),Iz[A]):
T:=[A,B]:
equal(pm_xy(xy_pm(Ix[A]*Iy[B]+Ix[B]*Iz[A])),Ix[A]*Iy[B]+Ix[B]*Iz[A]);

NEXT(`QC`): T:='T':
equal(QC(Ip[A]*Ip[B]),2):
equal(QC(Ip[A]*Im[B]),0):

NEXT(`QCset`):
T:=[A]: equal(QCset(Ix[A]),{-1,1}):
T:=[A,B]: equal(QCset(Ix[A]*Iy[B]),{-2,0,2}):

NEXT(`SQjump`):
T:=[A]:
equal(SQjump(Ip[A],{A},Pi/2,Pi/2,0,1),I*Iy[A] - Iz[A]):
equal(SQjump(Ip[A],{A},Pi/2,Pi/2,1,1),0):
equal(SQjump(Im[A],{A},Pi/2,Pi/2,0,1),-I*Iy[A] - Iz[A]):

NEXT(`QFpulse`):
T:=[A,B]: equal(QFpulse(Iy[A],{A},0,Pi/2,0,2),0):
equal(QFpulse(Iy[A]*Iz[B],{A,B},0,Pi/2,0,2),-Iz[A]*Iy[B]):

NEXT(`preQF`):
equal(preQF(Ix[A]*Iy[B],2),Ix[A]*Iy[B]):
equal(preQF(Ix[A]*Iy[B],1),0):
equal(preQF(Iz[A],0),Iz[A]):

NEXT(`doQF`):
equal(doQF(Ip[A],1),Ip[A]):
equal(doQF(Im[A],1),Im[A]):
equal(doQF(Ip[A]*Im[B],1),0):

NEXT(`QF`):
T:=[A,B]: equal(QF(Ix[A]*Iz[B],2),0):
equal(QF(Ix[A]*Iy[B]+Iy[A]*Ix[B],2),Ix[A]*Iy[B]+Iy[A]*Ix[B]):

NEXT(`CFT`):
equal(CFT(Sin(4*Pi*t),t),(Di(2,t)-I*Ab(2,t)-(Di(-2,t)-I*Ab(-2,t)))/2):
equal(CFT(Cos(4*Pi*t),t),(Ab(2,t)+I*Di(2,t)+Ab(-2,t)+I*Di(-2,t))/2):

NEXT(`MonCFT`):
equal(MonCFT(Sin(4*Pi*t)*Cos(Pi*J[A,B]*t2),t),
        CFT(Sin(4*Pi*t),t)*Cos(Pi*J[A,B]*t2)):
equal(MonCFT(Sin(2*Pi*W[A]*t)*Cos(Pi*J[A,B]*t),t),
        CFT(Sin(2*Pi*W[A]*t),t)*CFT(Cos(Pi*J[A,B]*t),t)):

NEXT(`Cos_FT`):
equal(Cos_FT(Sin(4*Pi*t),t),evalc(Re(CFT(Sin(4*Pi*t),t)))):
equal(Cos_FT(Cos(4*Pi*t),t),evalc(Re(CFT(Cos(4*Pi*t),t)))):

NEXT(`MonCosFT`):
equal(MonCosFT(Sin(4*Pi*t)*Cos(Pi*J[A,B]*t2),t),
        Cos_FT(Sin(4*Pi*t),t)*Cos(Pi*J[A,B]*t2)):
equal(MonCosFT(Sin(4*Pi*t)*Cos(Pi*J[A,B]*t),t),
        Cos_FT(Sin(4*Pi*t),t)*Cos_FT(Cos(Pi*J[A,B]*t),t)):

NEXT(`combi`):
s:=2*Pi*W[A]*t: j:=Pi*J[A,B]*t: j2:=Pi*J[A,B]*t2:
equal(combi(Sin(s),Cos(j),t),(Sin(s+j)+Sin(s-j))/2):
equal(combi(Sin(s)*Cos(j2),1,t),Sin(s)*Cos(j2)):

NEXT(`MonoPreFT`):
s:=2*Pi*W[A]*t: j:=Pi*J[A,B]*t: j2:=Pi*J[A,B]*t2:
equal(MonoPreFT(Sin(s)*Cos(j),t),Sin(s+j)/2+Sin(s-j)/2):
equal(MonoPreFT(Sin(s)*Cos(j2),t),Sin(s)*Cos(j2)):

NEXT(`do_ph_cor`):
s:=2*Pi*W[A]*t: j:=Pi*J[A,B]*t: j2:=Pi*J[A,B]*t2:
equal(do_ph_cor(Sin(s)*Cos(j2),Pi/2,t),Cos(s)*Cos(j2)):
equal(do_ph_cor(Sin(s)*Cos(j),Pi/2,t),-Cos(s)*Sin(j)):

NEXT(`FT`):
h:=W[A]+J[A,B]/2: l:=W[A]-J[A,B]/2:
equal(FT(Cos(2*Pi*W[A]*t)*Sin(Pi*J[A,B]*t),Pi/2,t,v),
        (Ab(h,v)+I*Di(h,v)-Ab(l,v)-I*Di(l,v))/4):
equal(FT(Cos(2*Pi*W[A]*t1)*Cos(2*Pi*W[B]*t2),0,t2,v2),
        expand(Cos(2*Pi*W[A]*t1)*(Ab(W[B],v2)+I*Di(W[B],v2))/2)):

NEXT(`CosFT`):
equal(CosFT(Cos(2*Pi*W[A]*t)*Sin(Pi*J[A,B]*t),Pi/2,t,v),
        Ab(W[A]+J[A,B]/2,v)/4-Ab(W[A]-J[A,B]/2,v)/4):
equal(CosFT(Cos(2*Pi*W[A]*t1)*Cos(2*Pi*W[B]*t2),0,t2,v2),
        Cos(2*Pi*W[A]*t1)*Ab(W[B],v2)/2):

NEXT(`getW`):
equal(getW(W[A]),A):
equal(getW(W[A]+J[A,B]/2+J[A,X]),A):


NEXT(`pA`):
equal(pA(0,1/T2,T2)/pA(0,0,T2),1/(1+4*Pi^2)):
equal(pA(v,v,T2),2*T2):

NEXT(`pD`):
equal(pD(0,1/T2,T2)/pD(0,1/(2*Pi*T2),T2),4*Pi/(1+4*Pi^2)):
equal(map(expand,{solve(diff(pD(v0,v,T2),v)=0,v)}),
       {v0-1/(2*Pi*T2),v0+1/(2*Pi*T2)}):
equal(pD(v,v+1/(2*Pi*T2),T2),-T2):
equal(pD(v,v-1/(2*Pi*T2),T2),T2):

NEXT(`plotsub`):
equal(plotsub(Ab(W[A]+J[A,B],v)),'pA(Wv[A]+Jv[A,B],v,T2[A])'):
equal(plotsub(Di(W[A]+J[A,B],v1)*Ab(W[B],v2)),
       'pD(Wv[A]+Jv[A,B],v1,T2[A])*pA(Wv[B],v2,T2[B])'):
last():

#quit
