#
## <SHAREFILE=analysis/Var/Var.mpl >
## <DESCRIBE>
##             Package for the direct and the inverse problem of the
##                calculus of variations.  Covers: Euler-Lagrange expressions
##                of a lagrangian, Anderson-Duchamp-Krupka variationality test,
##                Veinberg-Tonti lagrangian.
##                AUTHOR: Michal Marvan, mar10um@fpf.slu.cz
## </DESCRIBE>
## <UPDATE=R4 >

##########################
# standard input
###
# Convert from 5.2 to Release 3

# Instructions: Open this file in a fresh Maple session, and run it through.
# Then do the same with the file Var_help
#
# Next time you can open it as follows:
#
#   read `Var.m`;
#   with (Var);
#
# Ending the `with` command with colon rather than a semicolon will suppress
# all initial printing.
#

Var[init] := proc () 
global  oldnormal, normal;
local p,lp;
  if not assigned(oldnormal) then
    oldnormal := eval(normal):
    unprotect(normal);
    normal := proc(f)
      `indexed//string`(oldnormal(`string//indexed`(f)))
    end:
    protect(normal);
    lprint(`Warning: new definition for   normal`)
  fi:
  #if not interface(endcolon) then
  if not parse() then
    if assigned(`help/text/declarations`) then
      p := `Online help available`
    else
      p := `To enable online help, read ``Var_help.m`` `
    fi:
    lp := proc(n,f) lprint(cat(` `$n, f)) end:
    lp(0,` `): lp(0,` `): lp(0,` `): lp(0,` `):
    lp(5,`The Direct and the Inverse Problem of the Calculus of Variations`):
    lp(0,` `):
    lp(21,`(Michal.Marvan@decsu.fpf.slu.cz)`):
    lp(0,` `): lp(0,` `):
    lp(14,`Version 1.1 (April 1994) for Maple ver. 5.2.0`):
    lp(0,` `): lp(0,` `): lp(0,` `): lp(0,` `):
    lp(0,`Default declarations: coordinates(x,t); fields(u);`):
    lp(0,p):
    lp(0,` `): lp(0,` `):
  fi:
  interface(prettyprint=1,labelling=false):
  coordinates (x,t):
  fields (u):
end:


`string//indexed` := proc (f)
  if type (f, 'constant') then f
  elif type (f, 'name') then
    if type (f, {`f/var`,`b/var`}) then f['`no index`'] else f fi
  elif type (f,{`+`,`*`,`^`,'function','series'}) then map (procname, f)
  else ERROR (`unexpected object`, f)
  fi
end:

`indexed//string` := proc (f)
  if type (f, 'constant') then f
  elif type (f, 'name') then
    if type (f, 'indexed') and type (op(0,f), {`f/var`,`b/var`})
      and op(1,f) = '`no index`' then op(0,f) else f fi
  elif type (f,{`+`,`*`,`^`,'function','series'}) then map (procname, f)
  else ERROR (`unexpected object`, f)
  fi
end:

Var[diff] := proc (f,x)
  if not type([args[2..nargs]],'list(indeterminate)') then
    ERROR (`wrong type of indeterminates`) fi;
  if type (f, 'constant') then 0
  elif type (f, 'indeterminate') then
    if [args[2..nargs]] = [f] then 1 else 0 fi
  elif type (f,`+`) then map (procname,f,args[2..nargs])
  elif nargs > 2 then diff(diff(f,x), args[3..nargs])
  elif type (f,`*`) then `diff/*`(f,x)
  elif type (f,`^`) then `diff/^`(op(f),x)
  elif type (f,'function') then
    if type (f, specfunc(anything,diff)) then
      if member(x,[op(op(1,f))]) then
        'diff'(op(1,f), op(sort([op(2..nops(f),f),x])))
      else 0
      fi
    elif not traperror(readlib(`diff/`.(op(0,f)))) = lasterror then
      `diff/`.(op(0,f)) (op(f),x)
    else `diff/function`(op(0..nops(f),f),x)
    fi
  elif type(f, 'series') then readlib(`diff/series`) (f,x)
  else ERROR (`unknown object`, f)
  fi
end:

`diff/*` := proc (f,x) local i;
  convert([seq(subsop (i=diff(op(i,f),x), f), i=1..nops(f))], `+`)
end:

`diff/^` := proc (f,g,x)
  if type (g,'integer') then g*f^(g-1)*diff(f,x)
  else g*f^(g-1)*diff(f,x) + ln(f)*f^g*diff(g,x)
  fi
end:

`diff/function` := proc(f,a,x) local i;
  if nargs = 3 then
    if type(a,'indeterminate') then
      if a = x then 'diff(f(a),x)' else 0 fi
    else D(f)(a)*diff(a,x)
    fi
  elif type([args[2..nargs-1]],'list(indeterminate)') and
      nops({args[2..nargs-1]}) = nargs-2 then
    if member(args[nargs],[args[2..nargs-1]]) then
      'diff'(f(args[2..nargs-1]),args[nargs])
    else 0
    fi
  else convert([seq(D[i](f)(args[2..nargs-1])*diff(args[i+1], args[nargs]),
      i=1..nargs-2)], `+`)
  fi
end:

`type/indeterminate` := {name}:

`print/diff` := proc (f)
  if not type(f,'function') or type (f,'specfunc(anything,diff)') then
    ERROR(`this should not happen`) fi;
  ['d'^(nargs-1)*op(0,f)/convert(map(`diff//d`,[args[2..nargs]]), `*`)]
end:

`diff//d` := proc (f)
  if type (f,'string') then cat('d',f)
  elif type (f,'indexed') then procname(op(0,f))[op(f)]
  elif type (f,'function') then procname(op(0,f))
  fi
end:


Var[coordinates] := proc ()
  global  `b/var/s`;
  if nargs > 0 then
    if not type({args}, set(string)) then
      ERROR (args, `Sorry, names of coordinates must be strings`)
    fi;
    `b/var/s` := {args};
  fi;
  `b/var/s`
end:

`type/b/var` := proc (x) type(x,'string') and member (x, `b/var/s`) end:

Var[fields] := proc ()
  global  `f/var/s`;
  if nargs > 0 then
    if not type({args}, set(string)) then
      ERROR (args, `Sorry, names of fields must be strings`)
    fi;
    `f/var/s` := {args};
    map (proc (u) u := table (symmetric, []); u[] := u end, {args});
  fi;
  `f/var/s`
end:

`type/f/var` := proc (f) type(f,'string') and member (f, `f/var/s`) end:

`type/j/var` := proc (f)
  type (f, 'indexed') and member (op(0,f), `f/var/s`)
end:

`type/var` := {`b/var`, `f/var`, `j/var`}:

Var[depends] := proc (f)
  if type (f, 'constant') then {}
  elif type (f, 'name') then
    if type (f, 'var') then {f}
    else {}
    fi
  elif type (f,{`+`,`*`,`^`}) then `union`(op(map(procname,[op(f)])))
  elif type (f,'function') then `union`(op(map(procname,[op(f)])))
  else ERROR (`unexpected object`, f)
  fi
end:


Var[Tdiff] := proc (f)
  if nargs = 1 then f
  elif nargs = 2 then `Tdiff/1`(f, args[2])
  else Tdiff (`Tdiff/1`(f,args[2]), args[3..nargs])
  fi
end:


`Tdiff/1` := proc (f,x)
  if not type (x, `b/var`) then ERROR (`not a coordinate`, x) fi;
  if type (f, 'constant') then 0
  elif type (f, 'name') then
    if type (f,`b/var`) then if f = x then 1 else 0 fi
    elif type (f,`f/var`) then f[x]
    elif type (f,`j/var`) then op(0,f)[op(f),x]
    else 0
    fi
  else
    convert(map(proc(p,f,x) diff(f,p)*Tdiff(p,x) end,
      [op(depends(f))], f,x),`+`)
  fi
end:

Var[variation] := proc (f,p)
  if not type(p,`f/var`) then ERROR(`not a field variable`, p) fi;
  convert (map (proc (q,f,p)
    if q = p then diff(f,p)
    elif type (q, `j/var`) and op(0,q) = p then
      (-1)^nops(q) * Tdiff(diff(f,q), op(q))
    else 0
    fi
  end, [op(depends (f) minus `b/var/s`)], f, p), `+`)
end:


Var[variationality] := proc () local argb,argn,et,el,xs,p,q,x,a,as;
  if type (args[nargs],'name') then
    argb := args[1..nargs-1]; argn := args[nargs]
  else argb := args; argn := NULL;
  fi;
  if not type ([argb], 'list'(`=`)) then
    ERROR (`Pairs ``field identifier`` = ``expression`` expected.`)
  fi;
  et := table ([argb]);
  el := map(proc(q,et) if assigned (et[q]) then et[q]
      else ERROR (`no expression for a field identifier`, q)
      fi
    end, [op(`f/var/s`)], et);
  xs := `union`(op(map(proc(s)
    map(proc(q) if type(q,`j/var`) then [op(q)] else [] fi end,
      depends(s) minus `b/var/s`) end, el)));
  as := {};
  for p in `f/var/s` do
    for q in `f/var/s` do
      for x in xs do
        userinfo (5,variationality,`Test run for`, p, q[op(x)]);
        a := diff(et[p],q[op(x)])
          - `variation/j`(et[q],p[op(x)]);
        if traperror(normal(a)) <> lasterror then a := normal(a) fi;
        if a <> 0 then as := {a, op(as)};
          userinfo (3,variationality,`Test negative for`, p, q[op(x)])
        fi
      od
    od
  od;
  userinfo (5,variationality,`Tests done`);
  if as <> {} then
    print (`Variationality test negative`);
    if argn = NULL then table ([op(as)])
    else assign (args[nargs], table([op(as)])); NULL
    fi;
  else
    if argn <> NULL then assign (args[nargs], table([])) fi;
    print (`Variationality test positive`)
  fi
end:

`variation/j` := proc (f,p)
  if not type(p,{`f/var`,`j/var`}) then ERROR (`bad call`, p) fi;
  if type (p,`f/var`) then RETURN (variation (f,p)) fi;
  convert (map (proc (q,f,p)
    if type (q, `j/var`) and evalb(op(0,p) = op(0,q))
        and `sub/list`([op(p)],[op(q)]) then
      (-1)^nops(q) * `var/c` ([op(q)], [op(p)])
        * Tdiff (diff(f,q), op(`minus/list`([op(q)],[op(p)])))
    else 0
    fi
  end, [op(depends (f) minus `b/var/s`)], f, p), `+`)
end:

`sub/list` := proc (x,y)
  evalb (min(op(map (proc (t,x,y) occurrences (t,y) - occurrences (t,x) end,
    `b/var/s`, x, y))) >= 0)
end:

`minus/list` := proc (x,y)
  map (proc (t,x,y) local i;
    seq(t,i = occurrences(t,y)+1..occurrences(t,x))
  end, [op(`b/var/s`)], x, y)
end:

`var/c` := proc (x,y)
  convert(map(proc(t,x,y)
      combinat[binomial](occurrences(t,x),occurrences(t,y))
    end,
    [op(`b/var/s`)],x,y), `*`)
end:

occurrences := proc (t,x)
  if not type (x,'list') then ERROR (`bad call`, x) fi;
  nops (select (proc (s,t) evalb (s = t) end, x, t))
end:


Var[lagrangian] := proc () local argb,argn,et;
  if type (args[nargs],'name') then
    argb := args[1..nargs-1]; argn := args[nargs]
  else argb := args; argn := []
  fi;
  if not type ([argb], 'list'(`=`)) then
    ERROR (`Pairs ``field identifier`` = ``expression`` expected.`)
  fi;
  et := table ([argb]);
  convert(map(proc (q,et,argn) local _t;
      if not assigned (et[q]) then
         ERROR (`no expression for a field identifier`, q)
      fi;
      q*int(`lagrangian/1`(et[q],_t), _t=0..1, op(argn))
    end, [op(`f/var/s`)], et, argn), `+`)
end:

`lagrangian/1` := proc (f,t)
  if type (f, 'constant') then f
  elif type (f, 'name') then
    if type (f, `f/var`) then t*f
    elif type (f, `j/var`) then t*f
    elif type (f, `b/var`) then f
    else f
    fi
  elif type (f,{`+`,`*`,`^`}) then map (procname, f, t)
  elif type (f,'function') then
    if type (f,specfunc(anything,'diff')) then
      map (procname, `diff//D`(f), t)
    else map (procname, f, t)
    fi
  else ERROR (`unexpected object`, f)
  fi
end:

`diff//D` := proc (f) local f1,x,fun,inds,i;
  f1 := op(1,f); x := op(2,f);
  if type (f1, specfunc(anything,'diff')) then f1 := procname (f1) fi;
  fun := op(0,f1); inds := op(f1);
  if [inds] = [x] then D(fun)(x)
  elif member(x,[inds],'i') then D[i](fun)(inds)
  else ERROR (`this should not happen`, f)
  fi
end:


#save `Var.m`:
#quit
