#
## <SHAREFILE=science/orbitals/orbitals.mpl >
## <DESCRIBE>
## The Orbitals packages provides procedures for the computation of
##      real and complex spherical solid and surface harmonics. These
##                 are the familiar functions for the angular part of atomic
##                 orbitals in quantum mechanics. 
##       AUTHOR: Herbert Homeier, Herbert.Homeier@chemie.uni-regensburg.de
## SEE ALSO: orbitals.ms
## </DESCRIBE>
## <UPDATE=R4 >

#### Code file for orbitals ########
#2345678901234567890123456789012345678901234567890123456789012345678901234567890
#
# author and copyright:  Herbert H. H. Homeier, 1994
# email: na.hhomeier@na-net.ornl.gov
# date: May 20, 1994
# 
# description: procedures to compute real and complex spherical harmonics
#
#
orbitals[ComplexSurfaceHarmonic]:=
proc(l::nonnegint,m::integer,theta::algebraic,phi::algebraic)
   local mm,x,i;
   option `Copyright 1994 by Herbert H. H. Homeier`;
   mm:=abs(m);
   if mm>l then
     ERROR(`Invalid second argument m`,m,`. Required not to exceed the`.
       `first argument l`,l,` in magnitude`);
   fi;
   if l+mm=0 then RETURN(sqrt(1/4/Pi)); fi;
     I**(m+mm)*
     1/2^l/l!*(sin(theta))^mm*
     simplify(
       subs(x=cos(theta),
            diff( (x*x-1)^l,seq(x,i=1..(l+mm)))
           )
       )*
     exp(I*m*phi)*
     sqrt((2*l+1)*(l-mm)!/(l+mm)!/4/Pi);
 end:
#
#
orbitals[RealSurfaceHarmonic]:=
proc(l::nonnegint,m::integer,theta::algebraic,phi::algebraic)
   local mm,x,i;
   option `Copyright 1994 by Herbert H. H. Homeier`;
   mm:=abs(m);
   if mm>l then
     ERROR(`Invalid second argument m`,m,`. Required not to exceed the`.
       `first argument l`,l,` in magnitude`);
   fi;
   if m<0 then
     1/2^l/l!*(sin(theta)^mm*
     simplify(
       subs(x=cos(theta),
            diff( (x*x-1)^l,seq(x,i=1..(l+mm)))
           )
       )*
     (-1)^m*sin(mm*phi))*
     sqrt((2*l+1)*(l-mm)!/(l+mm)!/4/Pi);
   else
     if l+mm=0 then RETURN(sqrt(1/4/Pi)); fi;
     1/2^l/l!*(sin(theta))^mm*
     simplify(
       subs(x=cos(theta),
            diff( (x*x-1)^l,seq(x,i=1..(l+mm)))
           )
       )*
     (-1)^m*cos(mm*phi)*
     sqrt((2*l+1)*(l-mm)!/(l+mm)!/4/Pi);
   fi;
end:
#
#2345678901234567890123456789012345678901234567890123456789012345678901234567890
orbitals[ComplexSolidHarmonic]:=
proc(l::nonnegint,m::integer,x::algebraic,y::algebraic,z::algebraic)
   local j;
   option `Copyright 1994 by Herbert H. H. Homeier`;
   if abs(m)>l then
     ERROR(`Invalid second argument m`,m,`. Required not to exceed the`.
       `first argument l`,l,` in magnitude`);
   fi;  
  sqrt((2*l+1)*(l+m)!*(l-m)!/4/Pi)*
  sum((-x-I*y)^(m+j)*(x-I*y)^j*z^(l-m-2*j)/2^(2*j+m)/(j+m)!/j!/(l-m-2*j)!,
      j=max(0,-m)..iquo(l-m,2));
end:
#2345678901234567890123456789012345678901234567890123456789012345678901234567890
#save `orbitals.m`;
#quit;
