#
# Partial order of positive roots in a root system 
#
#   root_poset(R)   (R = a crystallographic root system)
#
# The positive roots are partially ordered by "r1<r2 if r2-r1 is a sum of
#  positive roots". This procedure produces the partial order of positive
#  roots, in a format compatible with the 'posets' package.
# The output is the "abstract Hasse diagram"; i.e., the set of ordered pairs
#  [i,j] for which j covers i in the poset.
#
root_poset:=proc(R) local S,res,i,s,Rplus,j;
  S:=coxeter['base'](R); res:={};
  Rplus:=coxeter['pos_roots'](R);
  for i to nops(Rplus) do;
    for s in S do;
      if member(Rplus[i]+s,Rplus,'j') then res:={op(res),[i,j]} fi;
    od;
  od;
  res;
end;
#
