with(share):
readshare(fit,numerics): # read `fit.m`:
interface(prettyprint=false):
Digits := 20:
compare := proc(r1,r2) local L,L1,L2: 
   L1 := [coeffs(r1)]: L2 := [coeffs(r2)]:
   if evalf(L1=L2, 6) then print('okay') else print(r2,r1) fi:
end:

# 1)
coords := [seq(Pi*i/10, i=0..10)]:
data  := map(sin, coords):
r1 := Float(-25578303,-9)+1.272296749*x-.4049846343*x**2:
r2 := fit(coords, data, c0+c1*t+c2*t^2, t):
compare(r1,r2):
r2 := fit(coords, data, [1, t, t^2], t):
compare(r1,r2):

# 2)
coord := [seq(i/5, i=0..5)]:
data  := map(x -> exp(sin(x)), coord):
r1 := .9895592227+2.041992053*sin(x)-.418176476*sin(2*x):
r2 := fit(coord, data, c0 + c1*sin(x) + c2*sin(2*x), x):
compare(r1,r2):

# 3)
coord := [-2.0,-1.5,-1.0,-0.5, 0.0, 0.5, 1.0, 1.5, 2.0]:
data  := [ 1.0, 1.3, 1.6, 2.1, 2.7, 3.5, 4.5, 5.8, 7.4]:
r1 := exp(.5023791374*x+.9981928103):
r2 := exp(fit(coord, map(ln,data), a*x+b, x)):
compare(ln(r1),ln(r2)):

# 4)
coord := [ seq( seq([i/4, j/4], i=0..4), j=0..4) ]:
data  := map(z -> 1 + 5*op(1,z) - op(1,z)*op(2,z), coord):
r1 := 1.000000000+5.000000000*x-1.000000000*x*y:
r2 := fit(coord, data, c1 + c2*x + c3*y + c4*x*y, [x, y]):
compare(r1,r2):

#quit
