#
#  Compute the Cartan matrix
#
# cartan_matrix(R)   (R = a crystallographic root system) 
# cartan_matrix(S)   (S = a list of base vectors)
#
cartan_matrix:=proc() local S,n,i,j,len;
  if type(args[1],'list') then S:=args[1]
    else S:=coxeter['base'](args[1]) fi;
  n:=nops(S); len:=[seq(coxeter['iprod'](S[i],S[i]),i=1..n)];
  array([seq([seq(2*coxeter['iprod'](S[i],S[j])/len[i],j=1..n)],i=1..n)]);
end;
#
