# LAST EDIT: Mon Jan  4 13:23:14 1993 by Axel Boldt (6500axel@ucsbuxa.ucsb.edu)

# Test-File for the Maple-routine coxpoly, which computes Coxeterpolynomials.

with(share): readshare(coxpoly,combinat): # read `coxpoly.m`;

# Test 1
result:=coxpoly([B1,B2],T):
if normal(result-
          (&Chi(B1)*&chi(B2)+&Chi(B2)*&chi(B1)-(T+1)*&chi(B1)*&chi(B2)))
   =0
then
  print('okay')
else
  print(result)
fi:

#Test 2
result:=coxpoly(4 &* [ 3, &C( [4,5], 4, &K(3), 3, &C([3,3]), 5) ], U):
if normal(result-
          (U^20-9*U^19-7*U^18+36*U^17+126*U^16+156*U^15-75*U^14-683*U^13-
          1569*U^12-2374*U^11-2700*U^10-2374*U^9-1569*U^8-683*U^7-75*U^6+
          156*U^5+126*U^4+36*U^3-7*U^2-9*U+1))
   =0
then
  print('okay')
else
  print(result)
fi:

# Test 3
result:=coxpoly([ p(i)&*[2,2] $ i=1..t ],1):
if normal(result-
          (4^t*(2-t)))
   =0
then
  print('okay')
else
  print(result)
fi:

# Test 4
result:=coxpoly([n&*[k(i)&*B(i)$i=1..t,4],&C([p,q],p+1,[[]],q+1),B],T,V):
if normal(result-
          ((V(n-1)*Product(V(k(i)-1)*&Chi(B(i))-T*V(k(i)-2)*&chi(B(i)),
          i = 1 .. t)*V(4)*(Sum((V(k(i))*&Chi(B(i))-T*V(k(i)-1)*&chi(B(i)))
          /(V(k(i)-1)*&Chi(B(i))-T*V(k(i) -2)*&chi(B(i))),i = 1 .. t)-
          (t-1)*V(2)+V(5)/V(4)-V(2))-T*V(n-2)*Product(V(k(i)-
          1)*&Chi(B(i)) -T*V(k(i)-2)*&chi(B(i)),i = 1 .. t)*V(4))*
          (V(p+1)*V(q)+V(p)*V(q+1) -V(2)*V(p)*V(q))*&chi(B)*
          ((V(n)*Product(V(k(i)-1)*&Chi(B(i))-T*V(k(i)-2)*
          &chi(B(i)),i = 1 .. t)*V(4)*(Sum((V(k(i))*&Chi(B(i))-
          T*V(k(i)-1)*&chi(B(i)))/(V(k(i)-1)*&Chi(B(i))-T*V(k(i)-2)*
          &chi(B(i))),i = 1 .. t)-(t-1)*V(2)+V(5)/V(4)-V(2))-T*
          V(n-1)*Product(V(k(i)-1)*&Chi(B(i))-T*V(k(i)-2)*&chi(B(i)),
          i = 1 .. t)*V(4))/(V(n-1)*Product(V(k(i)-1)*&Chi(B(i))-
          T*V(k(i)-2)*&chi(B(i)),i = 1 .. t)*V(4)*
          (Sum((V(k(i))*&Chi(B(i))-T*V(k(i)-1)*&chi(B(i)))/
          (V(k(i)-1)*&Chi(B(i))-T*V(k(i)-2)* &chi(B(i))),
          i = 1 .. t)-(t-1)*V(2)+V(5)/V(4)-V(2))-T*V(n-2)*
          Product(V(k(i)-1)* &Chi(B(i))-T*V(k(i)-2)*&chi(B(i)),
          i = 1 .. t)*V(4))+(T**p-1)*(T**q-1)/(V(p+1)*V(q)+V(p)*
          V(q+1)-V(2)*V(p)*V(q))+&Chi(B)/&chi(B)-2*V(2))))
   =0
then
  print('okay')
else
  print(result)
fi:

#Test 5
result:=coxpoly([&K(2)&*[&K(3),2&*&C([2,1])],
                 2&*[3,&C([2,2],3,3,2,[2,2],2)]],T):
if normal(result-
          coxpoly([3,&C([2,2],3,[3,2&*&K(2)&*
                   [&K(3),2&*[&C([1,2])]]],2,[2,2],2)],T))
   =0
then
  print('okay')
else
  print(result)
fi:

#Test 6
result:=coxpoly(&K(n)&*m&*[[p(i),q(i)]$i=1..t],T):
result2:=coxpoly(&K(2)&*3&*[[p(i),q(i)]$i=1..5],0):
if normal(result2-
          simplify(subs([Sum=sum,Product=product,T=0,n=2,m=3,t=5],result)))
  =0
then
  print('okay')
else
  print(result2)
fi:

#Test 7
result:=coxpoly(&K(n)&*m&*[[p(i),q(i)]$i=1..t],T):
result2:=coxpoly(&K(1)&*1&*[[2,1]],2):
if normal(result2-
          subs([p(1)=2,q(1)=1],
               simplify(subs([Sum=sum,Product=product,T=2,t=1,n=1,m=1],
                             result))))
  =0
then
  print('okay')
else
  print(result2)
fi:


#quit
