with(share):readshare(syrup,engineer):
#------------------------------Test Functions------------------------------------
tst := proc(result, expected)
	if (map(normal, result) = map(normal, expected)) or
           (map(expand, map(simplify,result,symbolic)) = 
            map(expand, map(simplify,expected,symbolic))) then
		print(okay)
	else
		ERROR('Result' = result, 'Expected' = expected)
	fi
end:

test := proc(r::{integer,integer..integer})
local i,output;
	for i from op(1,r) to op(nops(r),r) do
		output := traperror(tst(test.i));
		if output = lasterror then
			print(i,output);
			break
		fi
	od;
end:

#------------------------------Test Circuits-------------------------------------
ckt1 := TEXT(`Simple RC circuit`,
             `V  1 0 5.0`,
             `R1 1 2 1K`,
             `R2 2 0 1K`,
             `C  2 0 1uF IC=1mV`,
             `.END`):

test1 := '(syrup(ckt1,dc),{v1 = 5, v2 = 5/2})':
test2 := '(syrup(ckt1,dc,symbolic),{v1 = V, v2 = V*R2/(R1+R2)})':
test3 := '(syrup(ckt1,ac,symbolic),{v1 = V, v2 = V*R2/(R1+R2)/(1+s*C*R1*R2/(R1+R2))})':
test4 := '([syrup(ckt1,tran,'curr')],
           [{vC(0) = 1/1000, diff(vC(t),t) = -2000*vC(t)+5000}, {vC(t)}])':
test5 := '(curr,{iV  = -1/200+1/1000*vC(t),
                 iR2 = 1/1000*vC(t),
                 iR1 = 1/200-1/1000*vC(t),
                 iC  = -1/500*vC(t)+1/200})':
	             
ckt2 := TEXT(`Coupled Inductors`,
	           `V p 0`,
	           `Lp p 0 L`,
	           `Ls s 0 L`,
	           `K  Lp Ls 0.5`,
	           `R  s 0`,
	           `.end`):
	            
test6 := '(syrup(ckt2,ac),{vp = V, vs = V/(2 + (3/2)*(s*L/R))})':
test7 := '([syrup(ckt2,tran)],
               [{diff(iLp(t),t) =  2/3*(2*V+R*iLs(t))/L,
	              diff(iLs(t),t) = -2/3*(V+2*R*iLs(t))/L,
	              iLs(0) = 0,
	              iLp(0) = 0}, {iLp(t), iLs(t)}])':

test8 := '(syrup(TEXT(`Dependent Sources`,
                      `V 1 0`,
                      `E 2 0 1 0 e`,
                      `F 0 1 V f`,
                      `G 0 1 1 0 g`,
                      `H 3 0 V h`,
                      `.end`),dc),
             {v1 = V, v2 = e*V, v3 = h*g*V/(1-f)})':

test9 := '(syrup(TEXT(`Check Subcircuit`,
                      `V 1 0`,
                      `X1 1 2 RC`,
                      `X2 2 3 RC`,
                      `*`,
                      `.subckt RC vin vout`,
                      `R vin vout`,
                      `C vout 0`,
                      `.ends`,
                      `.end`),ac),
               {v1 = V, v2 = (1+C*s*R)*V/(3*C*s*R+C^2*s^2*R^2+1),
                v3 = V/(3*C*s*R+C^2*s^2*R^2+1)})':

################################
# Check syntax error detection #
################################

test10 := '(traperror(syrup(TEXT(`Missing Nodes`,
                                 `V1 1`,
                                 `.end`),dc))[1],
             `Missing nodes`)':

test11 := '(traperror(syrup(TEXT(`Illegal Node`,
                                 `V1 1 in`,
                                 `.end`),dc))[1],
             `Illegal node name`)':

test12 := '(traperror(syrup(TEXT(`Illegal Value`,
                                 `V1 1 2 x)`,
                                 `.end`),dc))[1],
             `Problem converting`)':

test13 := '(traperror(syrup(TEXT(`Missing end statement`,
                                 `V1 1 2`),dc)),
             `Out of text, check for missing ``.end`` in [sub]circuit`)':

test14 := '(traperror(syrup(TEXT(`Missing subcircuit definition`,
                                 `X 1`,
                                 `.end`),dc))[1],
             `Could not find subcircuit definition`)':

test15 := '(traperror(syrup(TEXT(`Missing coupled inductor`,
                                 `K L1 L2`,
                                 `.end`),dc))[1],
             `Could not find value of inductor`)':

test16 := '(traperror(syrup(TEXT(`Duplicate element`,
                                 `V 1 0`,
                                 `V 1 2`,
                                 `.end`),dc))[1],
             `Duplicate element name in`)':

test17 := '(traperror(syrup(TEXT(`Non-matching nodes in subckt and call`,
                                    `X 1 2 dum`,
                                    `.subckt dum 1`,
                                    `R1 1 0`,
                                    `.ends`,
                                    `.end`),dc))[1],
             `Different number of nodes in subcircuit call and definition`)':

test18 := '(traperror(syrup(TEXT(`Empty subcircuit`,
                                    `X 1 dum`,
                                    `.subckt dum 1`,
                                    `.ends`,
                                    `.end`),dc))[1],
             `No elements in subcircuit`)':

test19 := '(traperror(syrup(TEXT(`Empty semiconductor subcircuit`,
                                    `D1 1 2 dum`,
                                    `.subckt dum 1 2`,
                                    `.ends`,
                                    `.end`),dc))[1],
             `No elements in subcircuit`)':

test20 := '(syrup(TEXT(`Semiconductors`,
                       `V 1 0`,
                       `Df 1 2 diode`,
                       `Xr 0 2 Diode`,
                       `.subckt Diode a k`,
                       `D1 a k diode`,
                       `.ends`,
                       `.subckt diode a k`,
                       `Vd a k Vt*ln(iVd/Vt+1)`,
                       `.ends`,
                       `.end`),dc),
              {v1 = V, v2 = -Vt*ln(2*exp(-V/Vt)/(1+exp(-V/Vt)))})':

test21 := '(syrup(TEXT(`Nonlinear Subcircuit`,
                          `V 1 0`,
                          `R 1 2`,
                          `X 2 0 power`,
                          `.subckt power 1 2`,
                          `V 1 2 P/iV`,
                          `.ends`,
                          `.end`),dc),
              {v1 = V, v2 = P/RootOf(-V*_Z+P+_Z^2*R)})':

#-------------------------------Run tests----------------------------------------

#read `syrup.m`;
test(1..19);
#quit
#
# tests  20 and 21 require extra work at zero recognition:
#
result_20:=syrup(TEXT(`Semiconductors`,
                       `V 1 0`,
                       `Df 1 2 diode`,
                       `Xr 0 2 Diode`,
                       `.subckt Diode a k`,
                       `D1 a k diode`,
                       `.ends`,
                       `.subckt diode a k`,
                       `Vd a k Vt*ln(iVd/Vt+1)`,
                       `.ends`,
                       `.end`),dc):
assign(result_20):
if (v1-V = 0) and
   expand(simplify(v2-(-Vt*ln(2*exp(-V/Vt)/(1+exp(-V/Vt)))),symbolic)) = 0 then
       okay;
else {v1, v2};
fi;

v1:='v1': v2:='v2':


result_21:=syrup(TEXT(`Nonlinear Subcircuit`,
                          `V 1 0`,
                          `R 1 2`,
                          `X 2 0 power`,
                          `.subckt power 1 2`,
                          `V 1 2 P/iV`,
                          `.ends`,
                          `.end`),dc):
assign(result_21):
correct1:=P/RootOf(-V*_Z+P+_Z^2*R):
correct2:=-RootOf(_Z^2*R-_Z*V+P)*R+V:
if (v1=V) and (v2=correct1 or v2=correct2) then
    okay;
else
   {v1, v2}
fi;
v1:='v1': v2:='v2':
