#
## <SHAREFILE=geometry/surfaces/surfaces.mpl >
## <DESCRIBE>
##                A set of procedures to calculate basic differential-geometric
##                quantities of parametric surfaces in space.  The procedures
##                are intended to calculate first and second fundamental forms,
##                metric determinant, Gauss curvature and Mean curvature.
##                AUTHOR: Tim Murdoch, murdoch@wlu.edu
## </DESCRIBE>

#Surfaces package. Programmed for MapleV by Tim Murdoch December, 1992. 
#Revised for Release 2 in August, 1993
#This package consists of procedures to compute the coefficients of the 
#first and second fundamental forms, a unit normal vector, Gauss curvature and 
#mean curvature of a parametric surface in R^3. 
#Parameterized surfaces are represent as a list of three functions:
#[f(u,v),g(u,v),h(u,v)] (the independent variables may have any names).

surfaces := `_surfaces`:

g11:=proc(f::list,x::list)
local localf, localx, f1;
localf:=array(f); localx:=array(x);
f1:=map(diff, localf, x[1]);
linalg[dotprod](f1,f1)
end:

g12:=proc(f::list,x::list)
local localf, localx, f1, f2;
localf:=array(f); localx:=array(x);
f1:=map(diff, localf, x[1]);
f2:=map(diff, localf, x[2]);
linalg[dotprod](f1,f2)
end:

g21:=proc(f::list,x::list)
local localf, localx;
localf:=f; localx:=x;
g12(localf,localx)
end:	

g22:=proc(f::list,x::list)
local localf, localx, f2;
localf:=array(f); localx:=array(x);
f2:=map(diff, localf, x[2]);
linalg[dotprod](f2,f2)
end:

metricdet:=proc(f::list,x::list)
local localf, localx;
localf:=f; localx:=x;
simplify(g11(localf,localx)*g22(localf,localx)-g12(localf,localx)^2) 
end:

unitnormal:=proc(f::list,x::list)
local localf, localx, f1, f2, n, length;
localf:=array(f); localx:=array(x);
f1:=map(diff, localf, x[1]);
f2:=map(diff, localf, x[2]);
length:=sqrt(metricdet(convert(localf,list),convert(localx,list)));
convert(evalm((1/length)*linalg[crossprod](f1,f2)),list)
end:

b11:=proc(f::list,x::list)
local localf, localx, f11, n;
localf:=array(f); localx:=array(x);
f11:=map(diff, localf, x[1], x[1]);
n:=unitnormal(convert(localf,list),convert(localx,list));
-linalg[dotprod](n,f11)
end:

b12:=proc(f::list,x::list)
local localf, localx, f12, n;
localf:=array(f); localx:=array(x);
f12:=map(diff, localf, x[1], x[2]);
n:=unitnormal(convert(localf,list),convert(localx,list));
-linalg[dotprod](n,f12)
end:

b21:=proc(f::list,x::list)
local localf, localx;
localf:=f; localx:=x;
b12(localf,localx)
end:	

b22:=proc(f::list,x::list)
local localf, localx, f22, n;
localf:=array(f); localx:=array(x);
f22:=map(diff, localf, x[2], x[2]);
n:=unitnormal(convert(localf,list),convert(localx,list));
-linalg[dotprod](n,f22)
end:

Gausscurv:=proc(f::list,x::list)
local localf, localx;
localf:= f; localx:= x;
simplify((b11(localf,localx)*b22(localf,localx)-b12(localf,localx)^2)/(metricdet(localf, localx)))
end:

Meancurv:=proc(f::list,x::list)
local localf, localx;
localf:= f; localx:= x;
simplify((b11(localf,localx)*g22(localf,localx)-2*g12(localf,localx)*b12(localf,localx)+g11(localf,localx)*b22(localf,localx))/(2*metricdet(localf, localx)))
end:

catalogue:=proc(f::list,x::list)
local localf, localx, a, b, c, d, e;
localf:= f; localx:= x;
a:=linalg[matrix]([map(simplify,[g11(localf, localx),g12(localf, localx)]),
map(simplify,[g21(localf, localx),g22(localf, localx)])]);
print(`First fundamental form`= evalm(a));
b:=map(simplify,unitnormal(localf, localx));
print(`Unit normal vector`= evalm(b));
c:=linalg[matrix]([map(simplify,[b11(localf, localx),b12(localf, localx)]),
map(simplify,[b21(localf, localx),b22(localf, localx)])]);
print(`Second fundamental form`= evalm(c));
d:=Gausscurv(localf, localx);
print(`Gauss curvature`= d);
e:=Meancurv(localf, localx);
print(`Mean curvature`= e);
end:


#save `surfaces.m`;
#quit
