#
# Test file for SqrFree.
#
# I realize that many different answers are correct,
# but I don't really want to check them all.
#
 
with(share): readshare(`mod/SqrFree`): # read `SqrFree.m`;
 
a := SqrFree(2*x^2+6*x+6) mod 7:
if nops(a) = 2 and a[1] = 2 and a[2] = [[x^2+3*x+3,1]] then
	print( okay );
else
	print( a );
fi;
 
b := SqrFree(4*x^2+4*x+1) mod 7:
if nops(b) = 2 and b[1] = 4 and b[2] = [[x+4,2]] then
	print( okay );
else
	print( b );
fi;
 
alias(alpha=RootOf(x^2+x+1)):
c := SqrFree(alpha*x^3+(alpha+1)*x^2+x+alpha) mod 2:
if nops(c) = 2 and c[1] = alpha and c[2] = [[x + alpha, 3]] then
	print( okay );
else
	print( c );
fi;
 
d := SqrFree(x^3+y^3-z^3) mod 3:
if nops(d) = 2 and d[1] = 1 and d[2] = [[y + 2*z + x, 3]] then
	print( okay );
else
	print( d );
fi;
 
Expand( (x+y^2)^2*(2*x+3*y^2)^3 ) mod 5:
e := SqrFree( " ) mod 5:
if nops(e) = 2 and e[1] = 3 and e[2] = [[x+y^2,2], [x+4*y^2,3]] then
	print( okay );
else
	print( e );
fi;
 
alias(alpha=RootOf(x^4+x+1)):
a := Expand((x^2+y^2+alpha+1)^2*(x+y+alpha)) mod 2:
e := SqrFree(a) mod 2:
if nops(e) = 2 and e[1] = 1 and e[2] = [[x+y+alpha, 1], [x+y+alpha^2, 4]] then 
	print( okay );
else
	print( e );
fi;
 
#quit
