with(share):readshare(daub,numerics):
# test.map - Installation test for the daub packages
#
#   daubcc( p)  - Correct 2p coefficients of Daubechies Minimum Phase filter.
#   daubcc(-p)  - Correct 2p coefficients of Daubechies Least Asym. filter.
#
#   daubdd(p)   -  The 2p coefficients of Daubechies Minimum Phase filter,
#                   via Deslauriers-Dubuc Lagrange interpolation method.
#
#   daublh(p)   -  The 2p coefficients of Daubechies Minimum Phase filter,
#     via the spectral method (from the Mma program of Tong Chen, Meng Xu).
#
#   daubs(p)      -  System of 2p equations for Daubechies filter coefficients
#   drefine(c0,N) -  Refine filter coefficients c0 to N digits of precision.
#   daubacc(c)    -  Accuracy of coefficients c of Daubechies filter.
#   trap(a,b,n,f) - ~Int(f,x=a..b) using n trapezoids.
#   simp(a,b,n,f) - ~Int(f,x=a..b) using n parabolas.
#   rich(a,b,n,f) - ~Int(f,x=a..b) using Richardson extrapolation.
#   
#   dyad(x)     - Convert x to a dyadic number k/2^Ndyad
#   daubc(p)    - Coefficients of the Minimum Phase Daubechies filter
#   daubv(p)    - Values of the Daubechies scaling function phi at integers
#   phid(p,x)   - Daubechies scaling function phi at dyadic points x=k/2^Ndyad
#   psid(p,x)   - Daubechies wavelet psi at dyadic points
#   Phid(p,x)   - Antiderivative of phi at dyadic points
#   Psid(p,x)   - Antiderivative of psi at dyadic points
#   daubV(p)    - Values of the antiderivative of phi at integers
#   Dphid(p,x)  - Derivative of phi at dyadic points (p>3)
#   Dpsid(p,x)  - Derivative of psi at dyadic points (p>3)
#   daubDv(p)   - Values of the derivative of phi at integers (p>3)
#   mphid(p,m)  - Moment of order m of phi
#   mpsid(p,m)  - Moment of order m of psi
#   mPhid(p,m)  - Moment of order m of the antiderivative of phi over [0,2p-1]
#   mPsid(p,m)  - Moment of order m of the antiderivative of psi
#   mDphid(p,m) - Moment of order m of the derivative Dphi
#   mDpsid(p,m) - Moment of order m of the derivative Dpsi
#   
# (Copyright) Jacques Gelinas, Ph.D., Maths, CMR, aout 1994, gelinas@cmr.ca

Digits:=10;
timr := time();
lprint( `test timing (Maple V (1.1) + 486/33/8 meg) :`, 75.2, `sec.` );

warn:= proc( x, y, fuz )               local k, s; 
  s := 1 + max( op(map(abs,x)) );
  for k to nops(x) do  if nargs<3 then x[k]=y[k] else
    evalf(1+x[k]/s,Digits-fuz)=evalf(1+y[k]/s,Digits-fuz) fi;
    if not evalb(") then  print(abs(x[k]-y[k]),x,y) else print(`ok`) fi od end:

#read `daubcc.mpl`;

warn( daubcc(1),   [1., 1.] );
warn(  daubcc(2),
            [.683012701892219323381861585376468091735701313452,
                1.18301270189221932338186158537646809173570131345,
                .316987298107780676618138414623531908264298686547,
                -.183012701892219323381861585376468091735701313452] );

warn( daubcc(-2),  [1/4 + (1/4)*sqrt(3), 3/4 + (1/4)*sqrt(3),
                    3/4 - (1/4)*sqrt(3), 1/4 - (1/4)*sqrt(3) ]);

warn( daubcc(-10),
  [.00108917044724, .000135245019942, -.0122206426341, -.00207236392055,
   .0649509246030, .0164188694163, -.225558972320, -.1002402150130,
   .667071338429, 1.08825153074, .542813011103, -.0502565403406,
  -.0452407723042, .0707035675623, .00815281678378, -.0287862319439,
  -.00113753531067, .00649572837868, .0000806612029979, -.000649589896782] );

warn( daubcc(10),
[.0377171575922413777705637759431255, .266122182793841789833652873332770,
    .745575071486466769777677876091071, .973628110733639891366619631290027,
    .397637741769017379022100736335968, -.353336201794112600498754105574950,
    -.277109878720966305712580587644395, .180127448533393332685537070907716,
    .131602987101070014647323012218178, -.100966571196779434139432035849558,
    -.0416592480876016139620934376147523, .0469698140973971216920437651915258,
  .00510043696781447746534190223219333,  -.0151790023358564987876837378676650,
  .00197332536496320518826708836473664,  .00281768659019467621145676572652435,
 -.000969947839856410962969128814103162, -.000164709006090777955103110159239787,
  .000132354366851106766368762887969254, -.0000187584156275004083371169971592603
] );


#read `daublh.mpl`;
warn( daublh(2), [.6830127018, 1.183012702, .3169872981, -.1830127018], 1 );

#read `daubdd.mpl`;
warn( daubdd(2), [.6830127018, 1.183012702, .3169872981, -.1830127018], 1 );

dd3 := daubdd(3):
warn(  dd3, [ .4704672076, 1.141116915, .6503650004,
                   -.1909344153, -.1208322083, .04981749969 ], 1 );

#read `daubut.mpl`;
warn( daubs(3),
   [2 - c0 - c1 - c2 - c3 - c4 - c5, c0*c2 + c1*c3 + c2*c4 + c3*c5,
       c0*c4 + c1*c5, c0 - c1 + c2 - c3 + c4 - c5,
       - c1 + 2*c2 - 3*c3 + 4*c4 - 5*c5, - c1 + 4*c2 - 9*c3 + 16*c4 - 25*c5] );

warn( [ daubacc(dd3) ], [  9 ] );
dd340 := drefine( dd3, 40 ):

warn( dd340,
                [.4704672077841636807533291075711704583018,
                    1.141116915831443625760125629659421558190,
                    .6503650005262325285069348290341612831737,
                    -.1909344155683273615066582151423409166036,
                    -.1208322083103962092602639366053317414754,
                    .04981749973688373574653258548291935841317], 1 );

warn( [ daubacc( dd340 ) ], [ 39 ] );


Digits:=20;

#read `daub.mpl`;

warn( [dyad(2)], [2] );
warn( evalf([dyad( 2.1 )]), [ 2.1 ], 1 );

warn( daubc( 2 ), 
     [.68301270189221932338, 1.1830127018922193234, .31698729810778067662,
         -.18301270189221932338], 1 );

warn( daubv(2),  [0, 1.3660254037844386468, -.36602540378443864682, 0], 1 );

warn(map(x->phid(2,x),[1,1.25,1.5,1.75,2] ),
           [1.3660254037844386468, .34150635094610966163, -.6*10^(-19)   ,
               -.091506350946109661702, -.36602540378443864682], 1 );

warn( map(x->psid(2,x),[1,1.25,1.5,1.75,2] ),
    [-.36602540378443864677, 1.0915063509461096618, 1.7320508075688772936,
        -.65849364905389033840, -1.3660254037844386469], 1 );

warn( daubV(2), [0, .84967936855888599015, 1.0163460352255526568, 1.], 1 );

warn( map(x->Phid(2,x),[1,1.25,1.5,1.75,2] ),
     [.84967936855888599015, 1.0242453086546953902, 1.0773502691896257646,
         1.0763286419880287235, 1.0163460352255526568], 1 );

warn( map(x->Psid(2,x),[1,1.25,1.5,1.75,2] ),
    [-.22767090063073977449, -.09048472374451262063, .25000000000000000006,
        .28840139041117928737, .06100423396407310780], 1 );

warn( daubDv(4),
[0, 1.7760720075221846394, -2.7853493972295431416, 1.1924525366322781739,
-.13137451518467295877,-.053571028220239235923,.001770396479992522766,0], 2 );

warn( map(x->Dphid(4,x),[1,1.25,1.5,1.75,2] ),
    [1.7760720075221846394, -.6205965392105553153, -1.6854404465841185913,
        -1.3734103028008503832, -2.7853493972295431416], 4 );

warn( map(x->Dpsid(4,x),[1,1.25,1.5,1.75,2] ),
    [-.081699484827082953198, .22449608495572359653, .37824638822490915201,
        .38582137352395099941, .58962542183146203556], 2 );

warn( map(m->mphid(2,m),[0,1,2,3,4]),
   [1, .63397459621556135325, .40192378864668405974, .13109155679036177119,
       -.30219332850655733895], 1 );

warn( map(m->mpsid(2,m),[0,1,2,3,4]), [0, 0,
 -.21650635094610966168, -.78677857925749347765, -2.0143420887185900945], 1);

warn( map(m->mPhid(2,m),[0,1,2,3,4]),
     [2.3660254037844386468, 4.2990381056766579702, 8.9563028144032127429,
         20.325548332126639335, 48.813174562577271210], 1 );

warn( map(m->mPsid(2,m),[0,1,2,3,4]),
   [0, .10825317547305483084, .26225952641916449255, .50358552217964752363,
       .88885596673397613754], 1 );

warn( map(m->mDphid(2,m),[0,1,2,3,4]), [0, -1, -1.2679491924311227065,
 -1.2057713659400521792, -.52436622716144708476], 1 );

warn( map(m->mDpsid(2,m),[0,1,2,3,4]),  [0, 0, 0, .64951905283832898504, 
        3.1471143170299739106], 1 );


pz := proc(x,m) if m=0 then 1 else x^m fi end:

warn(  [seq(mphid(4,m), m=0..3)], 
       [seq(rich(0,7,7*2, x->pz(x,m) * phid(4,x) ), m=0..3)], 4);

warn(  [seq(mpsid(4,m), m=0..7)],
       [seq(rich(0,7,7*2, x->pz(x,m) * psid(4,x) ), m=0..7)], 4);

warn(  [seq(mPsid(4,m), m=0..7)], 
       [seq(rich(0,7,7*2, x->pz(x,m) * Psid(4,x) ), m=0..7)], 4);

warn(  [seq(mDphid(4,m), m=0..3)], 
       [seq(rich(0,7,7*2, x->pz(x,m) * Dphid(4,x) ), m=0..3)], 4);

warn(  [seq(mDpsid(4,m), m=0..3)], 
       [seq(trap(0,7,7*2, x->pz(x,m) * Dpsid(4,x) ), m=0..7)], 4);

lprint(`test timing : `, time()-timr );

print(`Jacques Gelinas, Ph.D., Maths, CMR, aout 1994, gelinas@cmr.ca`);

# end of test.map
