#
## <SHAREFILE=numerics/fft/fft.mpl >
## <DESCRIBE>
## Maple routines for the calculation of the Fast Fourier 
## Transform.  The fft routine works for complex
## sequences.
## AUTHOR: Stephen Earl, Telephone 0332 529615
## 3 Faygate Crescent, Bexleyheath, Kent DA6 7NS, England
## </DESCRIBE>


# A Maple Package for the calculation of the Fast Fourier Transform.
# 
# COPYRIGHT NOTICE:
# Copyright (c) September 1993 by Stephen Earl.
#  
# Permission is granted to anyone to to use, modify, or redistribute this
# software freely, subject to the following restrictions:
# 
# 1. The author accepts no responsibility for any consequences of this
#    software and makes no guarantee that the software is free of defects.
#
# 2. The origin of this software must not be misrepresented, either by
#    explicit claim or by omission.
#
# 3. This notice and the copyright must be included in all copies or
#    altered versions of this software.
#
# 4. This software may not be included or redistributed as part of any
#    package to be sold for profit unless the author has given explicit 
#    written permission to do so.
# 
# Stephen Earl
# 3 Faygate Crescent
# Bexleyheath
# Kent DA6 7NS
# England
#
# Telephone 0332 529615 
#
#############################################################################


fft := proc(datasize :: integer, Rin :: array, Iin :: array,
            Rtrans :: array, Itrans :: array, domain :: boolean)

local csn,expt,j,k,m,n,omega,p,perm,pwr,sign,size,sne,temp,total,u,v;

  if nargs <> 6 then 
    ERROR(`Incorrect number of arguments`);
  elif domain = true then 
    sign := -1;
  elif domain = false then 
    sign := 1;
  fi;

    n := datasize;

  while n > 1 do
    n := n / 2;
  od;

  if n <> 1 then 
    ERROR(`The length of the data is not an exact power of 2`);
  fi;

    expt := round(ln(datasize)/ln(2));

  for j from 1 to datasize do
    size := j - 1;
    total := 0;

    for k from 1 to expt do
      temp := floor(size / 2);
      total := total + total + size - temp - temp;
      size := temp;
    od:

    perm := total + 1;

    Rtrans[perm] := Rin[j];
    Itrans[perm] := Iin[j];
  od;

    pwr := 2;

  for j from 1 to expt do
    p := pwr / 2;

      for k from 1 to p do
        n := k;
        omega := evalf(Pi) * (k - 1) / p;
        sne := sign * evalf(-sin(omega));
        csn := evalf(cos(omega));

        while n < datasize do
          m := n + p;
          u := Rtrans[m] * csn + Itrans[m] * sne;
          v := Itrans[m] * csn - Rtrans[m] * sne;
          Rtrans[m] := Rtrans[n] - u;
          Itrans[m] := Itrans[n] - v;
          Rtrans[n] := Rtrans[n] + u;
          Itrans[n] := Itrans[n] + v;
          n := n + pwr;
        od;

      od;

    pwr := pwr + pwr;
  od;

  if domain = false then
    for j from 1 to datasize do
      Rtrans[j] := Rtrans[j] / datasize;
      Itrans[j] := Itrans[j] / datasize;
    od;
  fi;

  RETURN(datasize);
	
end:

#save `fft.m`;
#quit
