#	Test file for Hankel functions
#
#	Author:		Douglas B. Meade
#	Created:	27 July 1993

with(share): readshare(hankel,program): # read `hankel.m`;

s := sqrt(2)/sqrt(Pi)/sqrt(r):
answer[1] := s*sin(r)-I*cos(r)*s:
result[1] := BesselH(1,1/2,r):
if result[1]=answer[1] then okay else result[1] fi;

answer[2] := -BesselH(1,3,r^2+4):
result[2] := BesselH(1,-3,r^2+4):
if result[2]=answer[2] then okay else result[2] fi;

answer[3] := BesselH(2,2,1+2*I):
result[3] := evalc(BesselH(2,2,1+2*I)):
if result[3]=answer[3] then okay else result[3] fi;

answer[4] := BesselH(1,1/3,r)-4/3/r*BesselH(1,4/3,r):
result[4] := diff(BesselH(1,4/3,r),r):
if result[4]=answer[4] then okay else result[4] fi;

answer[5] := (BesselJ(1/3,exp(r))-4/3/exp(r)*BesselJ(4/3,exp(r)))*exp(r)+
I*(BesselY(1/3,exp(r))-4/3/exp(r)*BesselY(4/3,exp(r)))*exp(r):
result[5] := evalc(diff(BesselH(1,4/3,exp(r)),r)):
if result[5]=answer[5] then okay else result[5] fi;

answer[6] := 0.57672480775687338720-.10703243154093754689*I:
result[6] := evalf(BesselH(1,1,2),20):
if result[6]=answer[6] then okay else result[6] fi;

answer[7] := -(-8*BesselH(2,1,x)+4*BesselH(2,0,x)*x+BesselH(2,1,x)*x^2)/x^2:
result[7] := simplify(BesselH(2,3,x)):
if result[7]=answer[7] then okay else result[7] fi;

answer[8] := 8/x^2*BesselH(2,1,x)-4/x*BesselH(2,0,x)-BesselH(2,1,x):
result[8] := expand(BesselH(2,3,x)):
if result[8]=answer[8] then okay else result[8] fi;

# End of test file
#quit
