# readlib(mathematica):
with(share): readshare(math,system): # read `math.m`:

T := proc(a)
  local i;
  for i from 2 to nargs do if a=args[i] then print(okay); RETURN() fi od;
  print(args[1])
end:

T(mathematica(a+b*c),	`a+b*c`);
T(mathematica(a*b-c),	`a*b-c`);
T(mathematica(a*(b-c)),	`a*(b-c)`);
T(mathematica(-b+c),	`-b+c`);
T(mathematica(a/b),	`a/b`);
T(mathematica(a/(b*c)),	`a/(b*c)`);
T(mathematica(a/(b*c)*d),	`a*d/(b*c)`);
T(mathematica(a/2),	`1/2*a`);
T(mathematica(c0+c1*x+c2*x^2),	`c0+c1*x+c2*x^2`);
T(mathematica((a*b)^c),	`(a*b)^c`);
T(mathematica(a^c*b^c),	`a^c*b^c`);
T(mathematica((a^b)^c),	`(a^b)^c`);
T(mathematica(a^(b^c)),	`a^(b^c)`);
T(mathematica(a/b^2),	`a/b^2`);
T(mathematica(a/sin(b)),	`a/Sin[b]`);
T(mathematica(a/(b*c)^d),	`a/(b*c)^d`);
T(mathematica(a+b^2*c-sin(e)*(1-x)),	`a+b^2*c-Sin[e]*(1-x)`);
T(mathematica(a+b/(1+c/(1+d/e))),	`a+b/(1+c/(1+d/e))`);
T(mathematica((-2)^(1/3)),	`(-2)^(1/3)`);
T(mathematica(-2^(1/3)),	`-2^(1/3)`);
T(mathematica(-1-x),	`-1-x`);
T(mathematica(-2-x),	`-2-x`);
T(mathematica(-3*a-x),	`-3*a-x`);
T(mathematica(-x-z),	`-x-z`);
T(mathematica(1/a),	`1/a`);
T(mathematica(2/a),	`2/a`);
T(mathematica(a=(b and c)),	`a==(b && c)`);
T(mathematica(a and b or c),	`a && b || c`);
T(mathematica(a and b and c),	`a && b && c`);
T(mathematica(a and b + c),	`a && b+c`);
T(mathematica((a=b) <> (c and d)),	`(a==b)!=(c && d)`);
T(mathematica( (x,y) -> x and y ),	`( #1 && #2 )&`);
T(mathematica( (x,y) -> x + y ),	`( #1+#2 )&`);
T(mathematica( x -> if x<0 then 0 else x fi),	`( If[#1<0,0,#1] )&`);
T(mathematica( series(GAMMA(x), x=0, 2 )), 
	`SeriesData[x, 0, {1,-EulerGamma,1/12*Pi^2+1/2*EulerGamma^2,0}, -1, 2, 1]`);
T(mathematica( (f,x) -> diff(f,x,x) ),	`( D[#1,#2,#2] )&`);
T(mathematica(-85*W(x)^5-55*W(x)^4-37*W(x)^3-35*W(x)^2+97*W(x)+50),
	`-85*W[x]^5-55*W[x]^4-37*W[x]^3-35*W[x]^2+97*W[x]+50`);
T(mathematica(x -> int(x,x)),	`( Integrate[#1,#1] )&`);
T(mathematica(linalg[matrix](2,3,[1,2,3,4,5/2,6])),	`{{1, 2, 3}, {4, 5/2, 6}}`);
T(mathematica(Int(1/(x^2-2*x+1), x=0..2)),	`Integrate[1/(x^2-2*x+1),{x, 0, 2}]`);
T(mathematica(Limit(Ei(x-1/x)-Ei(x), x=infinity)),
	`Limit[ExpIntegralEi[x-1/x]-ExpIntegralEi[x], x -> Infinity]`);
T(mathematica((x,y) -> (x^2+y^2)/(x^2-y^2)),	`( (#1^2+#2^2)/(#1^2-#2^2) )&`);
T(mathematica(W(x) * exp(W(x)) = x),	`W[x]*Exp[W[x]]==x`);
c := k -> sum(ccoef(i)*(k-kss)*i/i!, i=0..n):
T(mathematica(c), `( Sum[ccoef[i]*(#1-kss)*i/Factorial[i],{i, 0, n}] )&`);

#done;
