# 
## <DESCRIBE>
##   Print vectors as column vectors.
##   AUTHOR: Michael Monagan, monagan@cecm.sfu.ca
## </DESCRIBE>



#--> `print/array`(A,N)
#
# Inputs: A an array, N either false or the name of A
# Output: one of the following with for unassigned entries either N or `?`
#
# type(A,vector(anything)) ==> VECTOR( anything* )
# type(A,matrix(anything)) ==> MATRIX( list(list(anything)) )
#
# Otherwise, arrays produce one of the following
#
# ARRAY( list(integer..integer), list( expseq(integer) = anything ) )
# ARRAY( string, list(integer..integer), list( expseq(integer) = anything ) )
#
# Author: MBM Nov/89
#

`print/array` := proc(A,N) local indexes,aname,indfunc;

    option `Copyright 1992 by the University of Waterloo`;
    if not type(A,'array') or type(A,'name') then ERROR(`system error`) fi;

    aname := `print/array/name`(N);

    if type(A,'vector(anything)') then
	RETURN( `print/array/vector`(A,aname) ) fi;
    if type(A,'matrix(anything)') then
	RETURN( `print/array/matrix`(A,aname) ) fi;

    indexes := [op(2,A)];
    indfunc := op(1,A);
    if nops(indexes)=0 then RETURN( `print/array/constant`(A,aname) ) fi;

    'ARRAY'(indfunc,indexes,
        [`print/array/array`(A,1,nops(indexes),indexes,[],aname)])

end:

`print/array/name` := proc(N)
    option `Copyright 1992 by the University of Waterloo`;
    if N = false or not type(N,name) then '`?`' else N fi
end:

`print/array/constant` := proc(A,aname) local lA;
    option `Copyright 1992 by the University of Waterloo`;
    lA := A;
    subs('lA'=aname,lA[])
end:

`print/array/vector` := proc(A,aname) local i,n,lA,v;
    option `Copyright 1992 by the University of Waterloo`;
    i := [op(2,A)];
    n := op(2,i[1]);
    lA := A;
    if pvac = true
    then v := 'MATRIX'([seq([eval(lA[i],1)],i=1..n)]);
    else v := 'VECTOR'([seq(eval(lA[i],1),i=1..n)]);
    fi;
    subs('lA'=aname,v)
end:

`print/array/matrix` := proc(A,aname) local i,j,m,n,lA;
    option `Copyright 1992 by the University of Waterloo`;
    i := [op(2,A)];
    m := op(2,i[1]);
    n := op(2,i[2]);
    lA := A;
    m := 'MATRIX'([seq([seq(lA[i,j],j=1..n)],i=1..m)]);
    subs('lA'=aname,m)
end:

`print/array/array` := proc(A,l,n,indexes,S,aname) local low,high,i,s,lA;
    option `Copyright 1992 by the University of Waterloo`;
    s := op(S);
    low := op(1,indexes[l]);
    high := op(2,indexes[l]);
    lA := A;
    if l = n then
	s := [seq((s,i)=lA[s,i],i=low..high)];
	op(subs('lA'=aname,s))
    else seq(procname(A,l+1,n,indexes,[s,i],aname),i=low..high)
    fi
end:

#savelib('`print/array/matrix`','`print/array/name`',\
	'`print/array`','`print/array/array`','`print/array/vector`',\
	'`print/array/constant`','`print/array.m`'):

pvac:=true:

