import 'package:geo_quiz_flutter/data/models/question.dart';

/// Represents the state of the main screen stored in the MainViewModel.
/// The [questionList] field is guaranteed to be immutable.
class MainScreenState {
  final int currentIndex;
  /// An immutable list of questions. Do not modify.
  final List<Question> questionList;

  MainScreenState({
    this.currentIndex = 0,
    List<Question> questionList = const [],
  }) : questionList = List.unmodifiable(questionList);

  /// Creates a copy of the current state with optional new values.
  MainScreenState copyWith({int? currentIndex, List<Question>? questionList}) {
    return MainScreenState(
      currentIndex: currentIndex ?? this.currentIndex,
      questionList: questionList ?? this.questionList,
    );
  }
}
