import 'package:flutter/material.dart';

void main() {
  runApp(const GridViewApp());
}

class GridViewApp extends StatefulWidget {
  const GridViewApp({super.key});

  @override
  State<GridViewApp> createState() => _GridViewAppState();
}

class _GridViewAppState extends State<GridViewApp> {
  List<int> _values = List<int>.generate(12, (i) => i + 1);

  void _squareValues() {
    setState(() {
      _values = _values.map((v) => v * v).toList();
    });
  }

  @override
  Widget build(BuildContext context) {
    return MaterialApp(
      home: Scaffold(
        appBar: AppBar(title: const Text('Flutter GridView Example')),
        body: Padding(
          padding: const EdgeInsets.all(8.0),
          child: GridView.builder(
            gridDelegate: const SliverGridDelegateWithFixedCrossAxisCount(
              crossAxisCount: 3,
              crossAxisSpacing: 4.0,
              mainAxisSpacing: 4.0,
            ),
            itemCount: _values.length,
            itemBuilder: (context, index) {
              final value = _values[index];
              final colorIndex = (value % 9 + 1) * 100;
              return Container(
                color: Colors.blue[colorIndex.clamp(100, 900)],
                child: Center(
                  child: Text(
                    '$value',
                    style: const TextStyle(color: Colors.white, fontSize: 16),
                  ),
                ),
              );
            },
          ),
        ),
        floatingActionButton: FloatingActionButton.extended(
          onPressed: _squareValues,
          icon: const Icon(Icons.square_foot),
          label: const Text('Square'),
        ),
      ),
    );
  }
}
