// dart
import 'package:flutter/material.dart';

void main() {
  runApp(const WidgetsDemoApp());
}

class WidgetsDemoApp extends StatelessWidget {
  const WidgetsDemoApp({super.key});

  @override
  Widget build(BuildContext context) {
    return MaterialApp(
      title: 'Stateful Widgets Demo',
      theme: ThemeData(useMaterial3: true),
      home: const WidgetsDemoPage(title: 'Stateful Widgets Demo'),
    );
  }
}

class WidgetsDemoPage extends StatefulWidget {
  const WidgetsDemoPage({super.key, required this.title});
  final String title;

  @override
  State<WidgetsDemoPage> createState() => _WidgetsDemoPageState();
}

class _WidgetsDemoPageState extends State<WidgetsDemoPage> {
  int _counter = 0;
  bool _isFavorite = false;
  bool _showImage = true;

  void _incrementCounter() {
    setState(() {
      _counter++;
    });
  }

  void _toggleFavorite() {
    setState(() {
      _isFavorite = !_isFavorite;
    });
  }

  void _reset() {
    setState(() {
      _counter = 0;
      _isFavorite = false;
      _showImage = true;
    });
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        title: Text(widget.title),
        actions: [
          IconButton(
            tooltip: 'Reset',
            onPressed: _reset,
            icon: const Icon(Icons.refresh),
          ),
        ],
      ),
      body: Padding(
        padding: const EdgeInsets.all(16),
        child: Column(
          mainAxisAlignment: MainAxisAlignment.center,
          children: [
            // Counter display and button
            Text('Counter: $_counter', style: Theme.of(context).textTheme.headlineMedium),
            const SizedBox(height: 12),
            ElevatedButton.icon(
              onPressed: _incrementCounter,
              icon: const Icon(Icons.add),
              label: const Text('Increment'),
            ),

            const SizedBox(height: 24),

            // Favorite toggle (stateful using setState)
            Row(
              mainAxisAlignment: MainAxisAlignment.center,
              children: [
                Text(_isFavorite ? 'Marked Favorite' : 'Not Favorite'),
                const SizedBox(width: 8),
                IconButton(
                  onPressed: _toggleFavorite,
                  icon: Icon(
                    _isFavorite ? Icons.favorite : Icons.favorite_border,
                    color: _isFavorite ? Colors.red : null,
                  ),
                ),
              ],
            ),

            const SizedBox(height: 24),

            // Switch to show/hide image
            Row(
              mainAxisAlignment: MainAxisAlignment.center,
              children: [
                const Text('Show image'),
                Switch(
                  value: _showImage,
                  onChanged: (v) => setState(() => _showImage = v),
                ),
              ],
            ),

            const SizedBox(height: 12),

            if (_showImage)
              ClipRRect(
                borderRadius: BorderRadius.circular(8),
                child: Image.network(
                  'https://www.znu.edu.ua/gallery/2019/02/photo-3603-photo-3603-adminkorpus.jpg',
                  height: 160,
                  fit: BoxFit.cover,
                ),
              ),
          ],
        ),
      ),
    );
  }
}
