import 'package:flutter/material.dart';
import 'data/repositories/local_question_repository.dart';
import 'ui/viewmodels/main_view_model.dart';
import 'ui/views/main_screen.dart';

void main() {
  final viewModel = MainViewModel(
    questionRepository: LocalQuestionRepository(),
  );
  runApp(MyApp(viewModel: viewModel));
}

class MyApp extends StatelessWidget {
  final MainViewModel viewModel;
  const MyApp({super.key, required this.viewModel});

  @override
  Widget build(BuildContext context) {
    return MaterialApp(
      title: 'MainScreen Demo',
      theme: ThemeData(primarySwatch: Colors.blue),
      home: MainScreen(viewModel: viewModel),
    );
  }
}
