import 'package:uuid/uuid.dart';

/// Model class representing a quiz question.
class Question {
  final String id;
  final String text;
  final bool answer;

  /// Constructor with optional id parameter. If id is not provided,
  /// a new UUID is generated.
  Question({String? id, required this.text, required this.answer})
    : id = id ?? _generateId(); //initializer - runs before the constructor body
  // and sets the final field id to the provided id or, when id is null/omitted,
  // to a generated UUID.

  /// Creates a copy of the current Question with optional new values.
  Question copyWith({String? id, String? text, bool? answer}) {
    return Question(
      id: id ?? this.id,
      text: text ?? this.text,
      answer: answer ?? this.answer,
    );
  }

  /// Override equality operator and hashCode to compare Question objects
  /// based on their id field.
  @override
  bool operator ==(Object other) =>
      identical(this, other) ||
      other is Question && runtimeType == other.runtimeType && id == other.id;

  /// Override hashCode to be consistent with the equality operator.
  @override
  int get hashCode => id.hashCode;
}

/// UUID generator instance
final Uuid _uuid = Uuid();

/// Generates a new UUID string.
String _generateId() => _uuid.v4();
