import '../models/question.dart';
import '../services/question_data_source.dart';
import '../repositories/question_repository.dart';

class LocalQuestionRepository implements QuestionRepository {
  final QuestionDataSource _dataSource;

  LocalQuestionRepository([QuestionDataSource? dataSource])
      : _dataSource = dataSource ?? QuestionDataSource();

  @override
  List<Question> getQuestionBank() => _dataSource.getQuestions();

  @override
  Question getQuestionByIndex(int index) {
    final list = _dataSource.getQuestions();
    return list[index];
  }

  @override
  int getQuestionBankSize() => _dataSource.getQuestions().length;
}
