import 'package:flutter/foundation.dart';
import 'package:flutter/material.dart';
import '../views/main_screen_state.dart';
import '../../data/models/question.dart';
import '../../data/repositories/question_repository.dart';

/// ViewModel for MainScreen
/// Holds the state and business logic for the MainScreen
/// Uses ChangeNotifier that provides a simple observable implementation
/// the UI can subscribe to. Extending ChangeNotifier lets the view model:
/// - call notifyListeners() when state changes (e.g. in onNextQuestionButtonClick()),
class MainViewModel extends ChangeNotifier {
  final QuestionRepository questionRepository;
  MainScreenState _mainScreenState;
  MainScreenState get mainScreenState => _mainScreenState;

  MainViewModel({required this.questionRepository})
    : _mainScreenState = MainScreenState(
        currentIndex: 0,
        questionList: questionRepository.getQuestionBank(),
      );

  Question getQuestionByIndex(int index) {
    return questionRepository.getQuestionByIndex(index);
  }

  String getQuestionText(int index) {
    final question = questionRepository.getQuestionByIndex(index);
    return question.text;
  }

  /// Returns a message string (to be shown in a SnackBar)
  String onAnswerButtonClick(bool userAnswer) {
    final currentQuestion = questionRepository.getQuestionByIndex(_mainScreenState.currentIndex);
    final correct = userAnswer == currentQuestion.answer;
    return correct ? 'Правильно' : 'Неправильно';
  }

  void onNextQuestionButtonClick() {
    final size = questionRepository.getQuestionBankSize();
    if (size == 0) return;
    _mainScreenState = _mainScreenState.copyWith(
      currentIndex: (_mainScreenState.currentIndex + 1) % size,
    );
    debugPrint(
      'MainViewModel.onNextQuestionButtonClick currentIndex: $_mainScreenState.currentIndex',
    );
    // The UI will be notified to rebuild. ChangeNotifier provides this method.
    notifyListeners();
  }
}
