import 'package:flutter/material.dart';

void main() {
  runApp(const LayoutApp());
}

class LayoutApp extends StatelessWidget {
  const LayoutApp({super.key});

  @override
  Widget build(BuildContext context) {
    return MaterialApp(
      // At least one of home, routes, onGenerateRoute, or builder must be non-null.
      home: Scaffold(
        appBar: AppBar(title: const Text('Flutter Layouts')),
        // To arrange widgets vertically:
        body: Column(
          children: [
            // To center a single widget within the available space:
            Center(
              child: Text(
                'Hello World',
                style: TextStyle(color: Colors.black, fontSize: 24),
              ),
            ),
            // To arrange multiple widgets horizontally:
            Row(
              mainAxisAlignment: MainAxisAlignment.center,
              children: [
                Icon(Icons.star, color: Colors.red, size: 30),
                SizedBox(width: 10),
                Icon(Icons.star, color: Colors.green, size: 30),
                SizedBox(width: 10),
                Icon(Icons.star, color: Colors.blue, size: 30),
              ],
            ),
            // To create a more complex layout:
            Container(
              color: Colors.blue,
              height: 100,
              child: const Center(
                child: Text(
                  'Container Example',
                  style: TextStyle(color: Colors.white, fontSize: 24),
                ),
              ),
            ),
            // Using Expanded to fill available space
            Expanded(
              child: Row(
                children: [
                  // to create a sidebar and main content area
                  Container(
                    padding: const EdgeInsets.only(left: 10, right: 10),
                    color: Colors.green,
                    width: 120,
                    child: const Center(
                      child: Text(
                        'Sidebar',
                        style: TextStyle(color: Colors.white, fontSize: 18),
                      ),
                    ),
                  ),
                  // Main content area
                  Expanded(
                    child: Container(
                      color: Colors.grey[200],
                      child: const Center(
                        child: Text(
                          'Main Content Area',
                          style: TextStyle(fontSize: 20),
                        ),
                      ),
                    ),
                  ),
                ],
              ),
            ),
            // Using Stack to overlay widgets
            Stack(
              children: [
                Container(
                  width: double.infinity,
                  height: 150,
                  color: Colors.orange,
                ),
                // Positioned widget to place child at specific position
                Positioned(
                  top: 50,
                  left: 50,
                  child: Container(
                    width: 100,
                    height: 100,
                    color: Colors.purple,
                    child: const Center(
                      child: Text(
                        'Stacked Box',
                        style: TextStyle(color: Colors.white),
                      ),
                    ),
                  ),
                ),
              ],
            ),
            // Footer
            Container(
              color: Colors.blue,
              height: 50,
              width: double.infinity,
              child: const Center(
                child: Text(
                  'Footer',
                  style: TextStyle(color: Colors.white, fontSize: 20),
                ),
              ),
            ),
          ],
        ),
      ),
    );
  }
}
