import 'package:flutter/material.dart';

void main() {
  runApp(const ListViewApp());
}

class ListViewApp extends StatefulWidget {
  const ListViewApp({super.key});

  @override
  State<ListViewApp> createState() => _ListViewAppState();
}

class _ListViewAppState extends State<ListViewApp> {
  final List<Map<String, dynamic>> _items = [
    {'icon': Icons.map, 'title': 'Map'},
    {'icon': Icons.photo_album, 'title': 'Album'},
    {'icon': Icons.phone, 'title': 'Phone'},
    {'icon': Icons.contacts, 'title': 'Contacts'},
    {'icon': Icons.settings, 'title': 'Settings'},
  ];

  void _showMessage(BuildContext ctx, String text) {
    final messenger = ScaffoldMessenger.of(ctx);
    messenger.hideCurrentSnackBar();
    messenger.showSnackBar(
      SnackBar(content: Text(text), duration: Duration(seconds: 2)),
    );
  }

  @override
  Widget build(BuildContext context) {
    return MaterialApp(
      home: Scaffold(
        appBar: AppBar(title: const Text('Flutter ListView Example')),
        body: ListView.builder(
          itemCount: _items.length,
          itemBuilder: (context, index) {
            final item = _items[index];
            return ListTile(
              leading: Icon(item['icon'] as IconData),
              title: Text(item['title'] as String),
              onTap: () => _showMessage(context, 'Tapped: ${item['title']}'),
            );
          },
        ),
      ),
    );
  }
}
